/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1;

import java.io.IOException;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.index.sai.disk.PerSSTableIndexWriter;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.io.IndexOutputWriter;
import org.apache.cassandra.index.sai.disk.v1.MetadataWriter;
import org.apache.cassandra.index.sai.disk.v1.bitpack.NumericValuesWriter;
import org.apache.cassandra.index.sai.disk.v1.keystore.KeyStoreWriter;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableComponentsWriter
implements PerSSTableIndexWriter {
    protected static final Logger logger = LoggerFactory.getLogger(SSTableComponentsWriter.class);
    private final IndexDescriptor indexDescriptor;
    private final MetadataWriter metadataWriter;
    private final NumericValuesWriter partitionSizeWriter;
    private final NumericValuesWriter tokenWriter;
    private final KeyStoreWriter partitionKeysWriter;
    private final KeyStoreWriter clusteringKeysWriter;
    private long partitionId = -1L;

    public SSTableComponentsWriter(IndexDescriptor indexDescriptor) throws IOException {
        this.indexDescriptor = indexDescriptor;
        this.metadataWriter = new MetadataWriter(indexDescriptor.openPerSSTableOutput(IndexComponent.GROUP_META));
        this.tokenWriter = new NumericValuesWriter(indexDescriptor, IndexComponent.TOKEN_VALUES, this.metadataWriter, false);
        this.partitionSizeWriter = new NumericValuesWriter(indexDescriptor, IndexComponent.PARTITION_SIZES, this.metadataWriter, true);
        IndexOutputWriter partitionKeyBlocksWriter = indexDescriptor.openPerSSTableOutput(IndexComponent.PARTITION_KEY_BLOCKS);
        NumericValuesWriter partitionKeyBlockOffsetWriter = new NumericValuesWriter(indexDescriptor, IndexComponent.PARTITION_KEY_BLOCK_OFFSETS, this.metadataWriter, true);
        this.partitionKeysWriter = new KeyStoreWriter(indexDescriptor.componentName(IndexComponent.PARTITION_KEY_BLOCKS), this.metadataWriter, partitionKeyBlocksWriter, partitionKeyBlockOffsetWriter, CassandraRelevantProperties.SAI_SORTED_TERMS_PARTITION_BLOCK_SHIFT.getInt(), false);
        if (indexDescriptor.hasClustering()) {
            IndexOutputWriter clusteringKeyBlocksWriter = indexDescriptor.openPerSSTableOutput(IndexComponent.CLUSTERING_KEY_BLOCKS);
            NumericValuesWriter clusteringKeyBlockOffsetWriter = new NumericValuesWriter(indexDescriptor, IndexComponent.CLUSTERING_KEY_BLOCK_OFFSETS, this.metadataWriter, true);
            this.clusteringKeysWriter = new KeyStoreWriter(indexDescriptor.componentName(IndexComponent.CLUSTERING_KEY_BLOCKS), this.metadataWriter, clusteringKeyBlocksWriter, clusteringKeyBlockOffsetWriter, CassandraRelevantProperties.SAI_SORTED_TERMS_CLUSTERING_BLOCK_SHIFT.getInt(), true);
        } else {
            this.clusteringKeysWriter = null;
        }
    }

    @Override
    public void startPartition(DecoratedKey partitionKey) throws IOException {
        ++this.partitionId;
        this.partitionKeysWriter.add(v -> ByteSource.of(partitionKey.getKey(), v));
        if (this.indexDescriptor.hasClustering()) {
            this.clusteringKeysWriter.startPartition();
        }
    }

    @Override
    public void nextRow(PrimaryKey primaryKey) throws IOException {
        this.tokenWriter.add(primaryKey.token().getLongValue());
        this.partitionSizeWriter.add(this.partitionId);
        if (this.indexDescriptor.hasClustering()) {
            this.clusteringKeysWriter.add(this.indexDescriptor.clusteringComparator.asByteComparable(primaryKey.clustering()));
        }
    }

    @Override
    public void complete() throws IOException {
        try {
            this.indexDescriptor.createComponentOnDisk(IndexComponent.GROUP_COMPLETION_MARKER);
        }
        catch (Throwable throwable) {
            FileUtils.close(this.tokenWriter, this.partitionSizeWriter, this.partitionKeysWriter, this.clusteringKeysWriter, this.metadataWriter);
            throw throwable;
        }
        FileUtils.close(this.tokenWriter, this.partitionSizeWriter, this.partitionKeysWriter, this.clusteringKeysWriter, this.metadataWriter);
    }

    @Override
    public void abort() {
        logger.debug(this.indexDescriptor.logMessage("Aborting per-SSTable index component writer for {}..."), (Object)this.indexDescriptor.sstableDescriptor);
        this.indexDescriptor.deletePerSSTableIndexComponents();
    }
}

