/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.analyzer;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.StringType;
import org.apache.cassandra.index.sai.analyzer.AbstractAnalyzer;
import org.apache.cassandra.index.sai.analyzer.NonTokenizingOptions;
import org.apache.cassandra.index.sai.analyzer.filter.BasicFilters;
import org.apache.cassandra.index.sai.analyzer.filter.FilterPipeline;
import org.apache.cassandra.index.sai.analyzer.filter.FilterPipelineExecutor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonTokenizingAnalyzer
extends AbstractAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(NonTokenizingAnalyzer.class);
    private final AbstractType<?> type;
    private final NonTokenizingOptions options;
    private final FilterPipeline filterPipeline;
    private ByteBuffer input;
    private boolean hasNext = false;

    NonTokenizingAnalyzer(AbstractType<?> type, Map<String, String> options) {
        this(type, NonTokenizingOptions.fromMap(options));
    }

    NonTokenizingAnalyzer(AbstractType<?> type, NonTokenizingOptions tokenizerOptions) {
        this.type = type;
        this.options = tokenizerOptions;
        this.filterPipeline = this.getFilterPipeline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        if (!(this.type instanceof StringType)) {
            return false;
        }
        if (this.hasNext) {
            try {
                String input = this.type.getString(this.input);
                if (input == null) {
                    throw new MarshalException(String.format("'null' deserialized value for %s with %s", ByteBufferUtil.bytesToHex(this.input), this.type));
                }
                String result = FilterPipelineExecutor.execute(this.filterPipeline, input);
                if (result == null) {
                    this.nextLiteral = null;
                    this.next = null;
                    boolean bl = false;
                    return bl;
                }
                this.nextLiteral = result;
                this.next = this.type.fromString(result);
                boolean bl = true;
                return bl;
            }
            catch (MarshalException e) {
                logger.error("Failed to deserialize value with " + this.type, (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                this.hasNext = false;
            }
        }
        return false;
    }

    @Override
    public boolean transformValue() {
        return !this.options.isCaseSensitive() || this.options.isNormalized() || this.options.isAscii();
    }

    @Override
    protected void resetInternal(ByteBuffer input) {
        this.input = input;
        this.hasNext = true;
    }

    private FilterPipeline getFilterPipeline() {
        FilterPipeline builder = new FilterPipeline(new BasicFilters.NoOperation());
        if (!this.options.isCaseSensitive()) {
            builder = builder.add("to_lower", new BasicFilters.LowerCase());
        }
        if (this.options.isNormalized()) {
            builder = builder.add("normalize", new BasicFilters.Normalize());
        }
        if (this.options.isAscii()) {
            builder = builder.add("ascii", new BasicFilters.Ascii());
        }
        return builder;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("caseSensitive", this.options.isCaseSensitive()).add("normalized", this.options.isNormalized()).add("ascii", this.options.isAscii()).toString();
    }
}

