/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.analyzer;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.StringType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.sai.analyzer.NoOpAnalyzer;
import org.apache.cassandra.index.sai.analyzer.NonTokenizingAnalyzer;
import org.apache.cassandra.index.sai.analyzer.NonTokenizingOptions;

public abstract class AbstractAnalyzer
implements Iterator<ByteBuffer> {
    protected ByteBuffer next = null;
    protected String nextLiteral = null;

    public abstract boolean transformValue();

    public void end() {
    }

    @Override
    public ByteBuffer next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract void resetInternal(ByteBuffer var1);

    public void reset(ByteBuffer input) {
        this.next = null;
        this.nextLiteral = null;
        this.resetInternal(input);
    }

    public static AnalyzerFactory fromOptions(AbstractType<?> type, Map<String, String> options) {
        if (AbstractAnalyzer.hasNonTokenizingOptions(options)) {
            if (type instanceof StringType) {
                NonTokenizingOptions.fromMap(options);
                return () -> new NonTokenizingAnalyzer(type, options);
            }
            throw new InvalidRequestException("CQL type " + type.asCQL3Type() + " cannot be analyzed.");
        }
        return NoOpAnalyzer::new;
    }

    private static boolean hasNonTokenizingOptions(Map<String, String> options) {
        return options.keySet().stream().anyMatch(NonTokenizingOptions::hasOption);
    }

    public static Map<String, String> getAnalyzerOptions(Map<String, String> options) {
        return options.entrySet().stream().filter(e -> NonTokenizingOptions.hasOption((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static interface AnalyzerFactory {
        public AbstractAnalyzer create();

        default public void close() {
        }
    }
}

