/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.statements.schema.IndexTarget;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.db.marshal.VectorType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.index.sai.IndexValidation;
import org.apache.cassandra.index.sai.SSTableContext;
import org.apache.cassandra.index.sai.analyzer.AbstractAnalyzer;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.disk.format.Version;
import org.apache.cassandra.index.sai.disk.v1.IndexWriterConfig;
import org.apache.cassandra.index.sai.memory.MemtableIndexManager;
import org.apache.cassandra.index.sai.metrics.ColumnQueryMetrics;
import org.apache.cassandra.index.sai.metrics.IndexMetrics;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.index.sai.utils.TypeUtil;
import org.apache.cassandra.index.sai.view.IndexViewManager;
import org.apache.cassandra.index.sai.view.View;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexContext {
    private static final Logger logger = LoggerFactory.getLogger(IndexContext.class);
    private static final Set<AbstractType<?>> EQ_ONLY_TYPES = ImmutableSet.of((Object)UTF8Type.instance, (Object)AsciiType.instance, (Object)BooleanType.instance, (Object)UUIDType.instance);
    private final AbstractType<?> partitionKeyType;
    private final ClusteringComparator clusteringComparator;
    private final String keyspace;
    private final String table;
    private final ColumnMetadata columnMetadata;
    private final IndexTarget.Type indexType;
    private final AbstractType<?> validator;
    @Nullable
    private final IndexMetadata indexMetadata;
    private final MemtableIndexManager memtableIndexManager;
    private final IndexViewManager viewManager;
    private final IndexMetrics indexMetrics;
    private final ColumnQueryMetrics columnQueryMetrics;
    private final IndexWriterConfig indexWriterConfig;
    private final AbstractAnalyzer.AnalyzerFactory analyzerFactory;
    private final PrimaryKey.Factory primaryKeyFactory;

    public IndexContext(String keyspace, String table, AbstractType<?> partitionKeyType, IPartitioner partitioner, ClusteringComparator clusteringComparator, ColumnMetadata columnMetadata, IndexTarget.Type indexType, @Nullable IndexMetadata indexMetadata) {
        this.keyspace = Objects.requireNonNull(keyspace);
        this.table = Objects.requireNonNull(table);
        this.partitionKeyType = Objects.requireNonNull(partitionKeyType);
        this.clusteringComparator = Objects.requireNonNull(clusteringComparator);
        this.columnMetadata = Objects.requireNonNull(columnMetadata);
        this.indexType = Objects.requireNonNull(indexType);
        this.validator = TypeUtil.cellValueType(columnMetadata, indexType);
        this.primaryKeyFactory = new PrimaryKey.Factory(partitioner, clusteringComparator);
        this.indexMetadata = indexMetadata;
        this.memtableIndexManager = indexMetadata == null ? null : new MemtableIndexManager(this);
        this.indexWriterConfig = indexMetadata == null ? IndexWriterConfig.emptyConfig() : IndexWriterConfig.fromOptions(indexMetadata.name, this.validator, indexMetadata.options);
        this.indexMetrics = indexMetadata == null ? null : new IndexMetrics(this);
        this.viewManager = new IndexViewManager(this);
        this.columnQueryMetrics = this.isLiteral() ? new ColumnQueryMetrics.TrieIndexMetrics(this) : new ColumnQueryMetrics.BalancedTreeIndexMetrics(this);
        this.analyzerFactory = indexMetadata == null ? AbstractAnalyzer.fromOptions(this.getValidator(), Collections.emptyMap()) : AbstractAnalyzer.fromOptions(this.getValidator(), indexMetadata.options);
    }

    public boolean hasClustering() {
        return this.clusteringComparator.size() > 0;
    }

    public AbstractType<?> keyValidator() {
        return this.partitionKeyType;
    }

    public PrimaryKey.Factory keyFactory() {
        return this.primaryKeyFactory;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public IndexWriterConfig getIndexWriterConfig() {
        return this.indexWriterConfig;
    }

    public IndexMetrics getIndexMetrics() {
        return this.indexMetrics;
    }

    public ColumnQueryMetrics getColumnQueryMetrics() {
        return this.columnQueryMetrics;
    }

    public String getTable() {
        return this.table;
    }

    public IndexMetadata getIndexMetadata() {
        return this.indexMetadata;
    }

    public Collection<SSTableContext> onSSTableChanged(Collection<SSTableReader> oldSSTables, Collection<SSTableContext> newSSTables, IndexValidation validation) {
        return this.viewManager.update(oldSSTables, newSSTables, validation);
    }

    public ColumnMetadata getDefinition() {
        return this.columnMetadata;
    }

    public AbstractType<?> getValidator() {
        return this.validator;
    }

    public boolean isNonFrozenCollection() {
        return TypeUtil.isNonFrozenCollection(this.columnMetadata.type);
    }

    public boolean isFrozen() {
        return TypeUtil.isFrozen(this.columnMetadata.type);
    }

    public String getColumnName() {
        return this.columnMetadata.name.toString();
    }

    @Nullable
    public String getIndexName() {
        return this.indexMetadata == null ? null : this.indexMetadata.name;
    }

    public AbstractAnalyzer.AnalyzerFactory getAnalyzerFactory() {
        return this.analyzerFactory;
    }

    public View getView() {
        return this.viewManager.getView();
    }

    public MemtableIndexManager getMemtableIndexManager() {
        assert (this.memtableIndexManager != null) : "Attempt to use memtable index manager on non-indexed context";
        return this.memtableIndexManager;
    }

    public int openPerIndexFiles() {
        return this.viewManager.getView().size() * Version.LATEST.onDiskFormat().openFilesPerColumnIndex(this);
    }

    public void drop(Collection<SSTableReader> sstablesToRebuild) {
        this.viewManager.drop(sstablesToRebuild);
    }

    public boolean isNotIndexed() {
        return this.indexMetadata == null;
    }

    public void invalidate() {
        this.viewManager.invalidate();
        this.analyzerFactory.close();
        if (this.memtableIndexManager != null) {
            this.memtableIndexManager.invalidate();
        }
        if (this.indexMetrics != null) {
            this.indexMetrics.release();
        }
        if (this.columnQueryMetrics != null) {
            this.columnQueryMetrics.release();
        }
    }

    public boolean supports(Operator op) {
        if (op == Operator.LIKE || op == Operator.LIKE_CONTAINS || op == Operator.LIKE_PREFIX || op == Operator.LIKE_MATCHES || op == Operator.LIKE_SUFFIX) {
            return false;
        }
        if (this.isVector()) {
            return op == Operator.ANN;
        }
        if (op == Operator.ANN) {
            return false;
        }
        Expression.IndexOperator operator = Expression.IndexOperator.valueOf(op);
        if (this.isNonFrozenCollection()) {
            if (this.indexType == IndexTarget.Type.KEYS) {
                return operator == Expression.IndexOperator.CONTAINS_KEY;
            }
            if (this.indexType == IndexTarget.Type.VALUES) {
                return operator == Expression.IndexOperator.CONTAINS_VALUE;
            }
            return this.indexType == IndexTarget.Type.KEYS_AND_VALUES && operator == Expression.IndexOperator.EQ;
        }
        if (this.indexType == IndexTarget.Type.FULL) {
            return operator == Expression.IndexOperator.EQ;
        }
        AbstractType<?> validator = this.getValidator();
        if (operator != Expression.IndexOperator.EQ && EQ_ONLY_TYPES.contains(validator)) {
            return false;
        }
        return operator != null && (!TypeUtil.isLiteral(validator) || operator != Expression.IndexOperator.RANGE);
    }

    public ByteBuffer getValueOf(DecoratedKey key, Row row, long nowInSecs) {
        if (row == null) {
            return null;
        }
        switch (this.columnMetadata.kind) {
            case PARTITION_KEY: {
                return this.partitionKeyType instanceof CompositeType ? CompositeType.extractComponent(key.getKey(), this.columnMetadata.position()) : key.getKey();
            }
            case CLUSTERING: {
                return row.isStatic() ? null : row.clustering().bufferAt(this.columnMetadata.position());
            }
            case STATIC: {
                if (!row.isStatic()) {
                    return null;
                }
            }
            case REGULAR: {
                Cell<?> cell = row.getCell(this.columnMetadata);
                return cell == null || !cell.isLive(nowInSecs) ? null : cell.buffer();
            }
        }
        return null;
    }

    public Iterator<ByteBuffer> getValuesOf(Row row, long nowInSecs) {
        if (row == null) {
            return null;
        }
        switch (this.columnMetadata.kind) {
            case STATIC: {
                if (!row.isStatic()) {
                    return null;
                }
            }
            case REGULAR: {
                return TypeUtil.collectionIterator(this.validator, row.getComplexColumnData(this.columnMetadata), this.columnMetadata, this.indexType, nowInSecs);
            }
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnName", (Object)this.getColumnName()).add("indexName", (Object)this.getIndexName()).toString();
    }

    public boolean isLiteral() {
        return TypeUtil.isLiteral(this.getValidator());
    }

    public boolean isVector() {
        return this.getValidator().isVector() && ((VectorType)this.getValidator()).elementType instanceof FloatType;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IndexContext)) {
            return false;
        }
        IndexContext other = (IndexContext)obj;
        return Objects.equals(this.columnMetadata, other.columnMetadata) && this.indexType == other.indexType && Objects.equals(this.indexMetadata, other.indexMetadata) && Objects.equals(this.partitionKeyType, other.partitionKeyType) && Objects.equals(this.clusteringComparator, other.clusteringComparator);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnMetadata, this.indexType, this.indexMetadata, this.partitionKeyType, this.clusteringComparator});
    }

    public String logMessage(String message) {
        return String.format("[%s.%s.%s] %s", this.keyspace, this.table, this.indexMetadata == null ? "?" : this.indexMetadata.name, message);
    }

    public Pair<Collection<SSTableIndex>, Collection<SSTableContext>> getBuiltIndexes(Collection<SSTableContext> sstableContexts, IndexValidation validation) {
        HashSet<SSTableIndex> valid = new HashSet<SSTableIndex>(sstableContexts.size());
        HashSet<SSTableContext> invalid = new HashSet<SSTableContext>();
        for (SSTableContext sstableContext : sstableContexts) {
            if (sstableContext.sstable.isMarkedCompacted()) continue;
            if (!sstableContext.indexDescriptor.isPerColumnIndexBuildComplete(this)) {
                logger.debug(this.logMessage("An on-disk index build for SSTable {} has not completed."), (Object)sstableContext.descriptor());
                continue;
            }
            if (sstableContext.indexDescriptor.isIndexEmpty(this)) {
                logger.debug(this.logMessage("No on-disk index was built for SSTable {} because the SSTable had no indexable rows for the index."), (Object)sstableContext.descriptor());
                continue;
            }
            try {
                if (validation != IndexValidation.NONE && !sstableContext.indexDescriptor.validatePerIndexComponents(this, validation)) {
                    invalid.add(sstableContext);
                    continue;
                }
                SSTableIndex index = sstableContext.newSSTableIndex(this);
                logger.debug(this.logMessage("Successfully created index for SSTable {}."), (Object)sstableContext.descriptor());
                if (valid.add(index)) continue;
                index.release();
            }
            catch (Throwable e) {
                logger.warn(this.logMessage("Failed to update per-column components for SSTable {}"), (Object)sstableContext.descriptor(), (Object)e);
                invalid.add(sstableContext);
            }
        }
        return Pair.create(valid, invalid);
    }

    public long getCellCount() {
        return this.getView().getIndexes().stream().mapToLong(SSTableIndex::getRowCount).sum();
    }

    public long diskUsage() {
        return this.getView().getIndexes().stream().mapToLong(SSTableIndex::sizeOfPerColumnComponents).sum();
    }

    public long indexFileCacheSize() {
        return this.getView().getIndexes().stream().mapToLong(SSTableIndex::indexFileCacheSize).sum();
    }
}

