/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.memtable;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.db.BufferDecoratedKey;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.memtable.AbstractAllocatorMemtable;
import org.apache.cassandra.db.memtable.AbstractMemtable;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.memtable.SkipListMemtableFactory;
import org.apache.cassandra.db.partitions.AbstractUnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.AtomicBTreePartition;
import org.apache.cassandra.db.partitions.BTreePartitionData;
import org.apache.cassandra.db.partitions.BTreePartitionUpdater;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.index.transactions.UpdateTransaction;
import org.apache.cassandra.io.sstable.SSTableReadsListener;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.Cloner;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.apache.cassandra.utils.memory.NativeAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipListMemtable
extends AbstractAllocatorMemtable {
    private static final Logger logger = LoggerFactory.getLogger(SkipListMemtable.class);
    public static final Memtable.Factory FACTORY = SkipListMemtableFactory.INSTANCE;
    protected static final int ROW_OVERHEAD_HEAP_SIZE;
    private final ConcurrentNavigableMap<PartitionPosition, AtomicBTreePartition> partitions = new ConcurrentSkipListMap<PartitionPosition, AtomicBTreePartition>();
    private final AtomicLong liveDataSize = new AtomicLong(0L);

    protected SkipListMemtable(AtomicReference<CommitLogPosition> commitLogLowerBound, TableMetadataRef metadataRef, Memtable.Owner owner) {
        super(commitLogLowerBound, metadataRef, owner);
    }

    @Override
    public boolean isClean() {
        return this.partitions.isEmpty();
    }

    @Override
    public long put(PartitionUpdate update, UpdateTransaction indexer, OpOrder.Group opGroup) {
        AtomicBTreePartition empty;
        DecoratedKey cloneKey;
        Cloner cloner = this.allocator.cloner(opGroup);
        AtomicBTreePartition previous = (AtomicBTreePartition)this.partitions.get(update.partitionKey());
        long initialSize = 0L;
        if (previous == null && (previous = this.partitions.putIfAbsent(cloneKey = cloner.clone(update.partitionKey()), empty = new AtomicBTreePartition(this.metadata, cloneKey, this.allocator))) == null) {
            previous = empty;
            int overhead = (int)(cloneKey.getToken().getHeapSize() + (long)ROW_OVERHEAD_HEAP_SIZE);
            this.allocator.onHeap().allocate(overhead, opGroup);
            initialSize = 8L;
        }
        BTreePartitionUpdater updater = previous.addAll(update, cloner, opGroup, indexer);
        SkipListMemtable.updateMin(this.minTimestamp, update.stats().minTimestamp);
        SkipListMemtable.updateMin(this.minLocalDeletionTime, update.stats().minLocalDeletionTime);
        this.liveDataSize.addAndGet(initialSize + updater.dataSize);
        this.columnsCollector.update(update.columns());
        this.statsCollector.update(update.stats());
        this.currentOperations.addAndGet(update.operationCount());
        return updater.colUpdateTimeDelta;
    }

    @Override
    public long partitionCount() {
        return this.partitions.size();
    }

    @Override
    public MemtableUnfilteredPartitionIterator partitionIterator(ColumnFilter columnFilter, DataRange dataRange, SSTableReadsListener readsListener) {
        AbstractBounds<PartitionPosition> keyRange = dataRange.keyRange();
        PartitionPosition left = (PartitionPosition)keyRange.left;
        PartitionPosition right = (PartitionPosition)keyRange.right;
        boolean isBound = keyRange instanceof Bounds;
        boolean includeLeft = isBound || keyRange instanceof IncludingExcludingBounds;
        boolean includeRight = isBound || keyRange instanceof Range;
        Map<PartitionPosition, AtomicBTreePartition> subMap = this.getPartitionsSubMap(left, includeLeft, right, includeRight);
        return new MemtableUnfilteredPartitionIterator(this.metadata.get(), subMap, columnFilter, dataRange);
    }

    private Map<PartitionPosition, AtomicBTreePartition> getPartitionsSubMap(PartitionPosition left, boolean includeLeft, PartitionPosition right, boolean includeRight) {
        if (left != null && left.isMinimum()) {
            left = null;
        }
        if (right != null && right.isMinimum()) {
            right = null;
        }
        try {
            if (left == null) {
                return right == null ? this.partitions : this.partitions.headMap((Object)right, includeRight);
            }
            return right == null ? this.partitions.tailMap((Object)left, includeLeft) : this.partitions.subMap((Object)left, includeLeft, (Object)right, includeRight);
        }
        catch (IllegalArgumentException e) {
            logger.error("Invalid range requested {} - {}", (Object)left, (Object)right);
            throw e;
        }
    }

    Partition getPartition(DecoratedKey key) {
        return (Partition)this.partitions.get(key);
    }

    @Override
    public UnfilteredRowIterator rowIterator(DecoratedKey key, Slices slices, ColumnFilter selectedColumns, boolean reversed, SSTableReadsListener listener) {
        Partition p = this.getPartition(key);
        if (p == null) {
            return null;
        }
        return p.unfilteredIterator(selectedColumns, slices, reversed);
    }

    @Override
    public UnfilteredRowIterator rowIterator(DecoratedKey key) {
        Partition p = this.getPartition(key);
        return p != null ? p.unfilteredIterator() : null;
    }

    private static int estimateRowOverhead(int count) {
        try (OpOrder.Group group = new OpOrder().start();){
            MemtableAllocator allocator = MEMORY_POOL.newAllocator("");
            Cloner cloner = allocator.cloner(group);
            ConcurrentSkipListMap<DecoratedKey, Object> partitions = new ConcurrentSkipListMap<DecoratedKey, Object>();
            Object val = new Object();
            int testBufferSize = 8;
            for (int i = 0; i < count; ++i) {
                partitions.put(cloner.clone(new BufferDecoratedKey(new Murmur3Partitioner.LongToken(i), ByteBuffer.allocate(8))), val);
            }
            double avgSize = (double)ObjectSizes.measureDeepOmitShared(partitions) / (double)count;
            int rowOverhead = (int)(avgSize - Math.floor(avgSize) < 0.05 ? Math.floor(avgSize) : Math.ceil(avgSize));
            rowOverhead = (int)((long)rowOverhead - new Murmur3Partitioner.LongToken(0L).getHeapSize());
            rowOverhead = (int)((long)rowOverhead + AtomicBTreePartition.EMPTY_SIZE);
            rowOverhead = (int)((long)rowOverhead + BTreePartitionData.UNSHARED_HEAP_SIZE);
            if (!(allocator instanceof NativeAllocator)) {
                rowOverhead -= 8;
            }
            allocator.setDiscarding();
            allocator.setDiscarded();
            int n = rowOverhead;
            return n;
        }
    }

    @Override
    public Memtable.FlushablePartitionSet<?> getFlushSet(final PartitionPosition from, final PartitionPosition to) {
        final Map<PartitionPosition, AtomicBTreePartition> toFlush = this.getPartitionsSubMap(from, true, to, false);
        long keysSize = 0L;
        long keyCount = 0L;
        boolean trackContention = logger.isTraceEnabled();
        if (trackContention) {
            int heavilyContendedRowCount = 0;
            for (AtomicBTreePartition partition : toFlush.values()) {
                keysSize += (long)partition.partitionKey().getKey().remaining();
                ++keyCount;
                if (!partition.useLock()) continue;
                ++heavilyContendedRowCount;
            }
            if (heavilyContendedRowCount > 0) {
                logger.trace("High update contention in {}/{} partitions of {} ", new Object[]{heavilyContendedRowCount, toFlush.size(), this});
            }
        } else {
            for (PartitionPosition key : toFlush.keySet()) {
                assert (key instanceof DecoratedKey);
                keysSize += (long)((DecoratedKey)key).getKey().remaining();
                ++keyCount;
            }
        }
        final long partitionKeysSize = keysSize;
        final long partitionCount = keyCount;
        return new AbstractMemtable.AbstractFlushablePartitionSet<AtomicBTreePartition>(){

            @Override
            public Memtable memtable() {
                return SkipListMemtable.this;
            }

            @Override
            public PartitionPosition from() {
                return from;
            }

            @Override
            public PartitionPosition to() {
                return to;
            }

            @Override
            public long partitionCount() {
                return partitionCount;
            }

            @Override
            public Iterator<AtomicBTreePartition> iterator() {
                return toFlush.values().iterator();
            }

            @Override
            public long partitionKeysSize() {
                return partitionKeysSize;
            }
        };
    }

    @Override
    public long getLiveDataSize() {
        return this.liveDataSize.get();
    }

    @VisibleForTesting
    public void makeUnflushable() {
        this.liveDataSize.addAndGet(0x4000000000000L);
    }

    static {
        int userDefinedOverhead = CassandraRelevantProperties.MEMTABLE_OVERHEAD_SIZE.getInt(-1);
        ROW_OVERHEAD_HEAP_SIZE = userDefinedOverhead > 0 ? userDefinedOverhead : SkipListMemtable.estimateRowOverhead(CassandraRelevantProperties.MEMTABLE_OVERHEAD_COMPUTE_STEPS.getInt());
    }

    private static class MemtableUnfilteredPartitionIterator
    extends AbstractUnfilteredPartitionIterator
    implements UnfilteredPartitionIterator {
        private final TableMetadata metadata;
        private final Iterator<Map.Entry<PartitionPosition, AtomicBTreePartition>> iter;
        private final ColumnFilter columnFilter;
        private final DataRange dataRange;

        MemtableUnfilteredPartitionIterator(TableMetadata metadata, Map<PartitionPosition, AtomicBTreePartition> map, ColumnFilter columnFilter, DataRange dataRange) {
            this.metadata = metadata;
            this.iter = map.entrySet().iterator();
            this.columnFilter = columnFilter;
            this.dataRange = dataRange;
        }

        @Override
        public TableMetadata metadata() {
            return this.metadata;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public UnfilteredRowIterator next() {
            Map.Entry<PartitionPosition, AtomicBTreePartition> entry = this.iter.next();
            assert (entry.getKey() instanceof DecoratedKey);
            DecoratedKey key = (DecoratedKey)entry.getKey();
            ClusteringIndexFilter filter = this.dataRange.clusteringIndexFilter(key);
            return filter.getUnfilteredRowIterator(this.columnFilter, entry.getValue());
        }
    }
}

