/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.commitlog.IntervalSet;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.AbstractStrategyHolder;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.utils.TimeUUID;

public class CompactionStrategyHolder
extends AbstractStrategyHolder {
    private final List<AbstractCompactionStrategy> strategies = new ArrayList<AbstractCompactionStrategy>();
    private final boolean isRepaired;

    public CompactionStrategyHolder(ColumnFamilyStore cfs, AbstractStrategyHolder.DestinationRouter router, boolean isRepaired) {
        super(cfs, router);
        this.isRepaired = isRepaired;
    }

    @Override
    public void startup() {
        this.strategies.forEach(AbstractCompactionStrategy::startup);
    }

    @Override
    public void shutdown() {
        this.strategies.forEach(AbstractCompactionStrategy::shutdown);
    }

    @Override
    public void setStrategyInternal(CompactionParams params, int numTokenPartitions) {
        this.strategies.clear();
        for (int i = 0; i < numTokenPartitions; ++i) {
            this.strategies.add(this.cfs.createCompactionStrategyInstance(params));
        }
    }

    @Override
    public boolean managesRepairedGroup(boolean isRepaired, boolean isPendingRepair, boolean isTransient) {
        if (!isPendingRepair) {
            Preconditions.checkArgument((!isTransient ? 1 : 0) != 0, (Object)"isTransient can only be true for sstables pending repairs");
            return this.isRepaired == isRepaired;
        }
        Preconditions.checkArgument((!isRepaired ? 1 : 0) != 0, (Object)"SSTables cannot be both repaired and pending repair");
        return false;
    }

    @Override
    public AbstractCompactionStrategy getStrategyFor(SSTableReader sstable) {
        Preconditions.checkArgument((boolean)this.managesSSTable(sstable), (Object)"Attempting to get compaction strategy from wrong holder");
        return this.strategies.get(this.router.getIndexForSSTable(sstable));
    }

    @Override
    public Iterable<AbstractCompactionStrategy> allStrategies() {
        return this.strategies;
    }

    @Override
    public Collection<AbstractStrategyHolder.TaskSupplier> getBackgroundTaskSuppliers(long gcBefore) {
        ArrayList<AbstractStrategyHolder.TaskSupplier> suppliers = new ArrayList<AbstractStrategyHolder.TaskSupplier>(this.strategies.size());
        for (AbstractCompactionStrategy strategy : this.strategies) {
            suppliers.add(new AbstractStrategyHolder.TaskSupplier(strategy.getEstimatedRemainingTasks(), () -> strategy.getNextBackgroundTask(gcBefore)));
        }
        return suppliers;
    }

    @Override
    public Collection<AbstractCompactionTask> getMaximalTasks(long gcBefore, boolean splitOutput) {
        ArrayList<AbstractCompactionTask> tasks = new ArrayList<AbstractCompactionTask>(this.strategies.size());
        for (AbstractCompactionStrategy strategy : this.strategies) {
            Collection<AbstractCompactionTask> task = strategy.getMaximalTask(gcBefore, splitOutput);
            if (task == null) continue;
            tasks.addAll(task);
        }
        return tasks;
    }

    @Override
    public Collection<AbstractCompactionTask> getUserDefinedTasks(AbstractStrategyHolder.GroupedSSTableContainer sstables, long gcBefore) {
        ArrayList<AbstractCompactionTask> tasks = new ArrayList<AbstractCompactionTask>(this.strategies.size());
        for (int i = 0; i < this.strategies.size(); ++i) {
            if (sstables.isGroupEmpty(i)) continue;
            tasks.add(this.strategies.get(i).getUserDefinedTask(sstables.getGroup(i), gcBefore));
        }
        return tasks;
    }

    @Override
    public void addSSTables(AbstractStrategyHolder.GroupedSSTableContainer sstables) {
        Preconditions.checkArgument((sstables.numGroups() == this.strategies.size() ? 1 : 0) != 0);
        for (int i = 0; i < this.strategies.size(); ++i) {
            if (sstables.isGroupEmpty(i)) continue;
            this.strategies.get(i).addSSTables(sstables.getGroup(i));
        }
    }

    @Override
    public void removeSSTables(AbstractStrategyHolder.GroupedSSTableContainer sstables) {
        Preconditions.checkArgument((sstables.numGroups() == this.strategies.size() ? 1 : 0) != 0);
        for (int i = 0; i < this.strategies.size(); ++i) {
            if (sstables.isGroupEmpty(i)) continue;
            this.strategies.get(i).removeSSTables(sstables.getGroup(i));
        }
    }

    @Override
    public void replaceSSTables(AbstractStrategyHolder.GroupedSSTableContainer removed, AbstractStrategyHolder.GroupedSSTableContainer added) {
        Preconditions.checkArgument((removed.numGroups() == this.strategies.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((added.numGroups() == this.strategies.size() ? 1 : 0) != 0);
        for (int i = 0; i < this.strategies.size(); ++i) {
            if (removed.isGroupEmpty(i) && added.isGroupEmpty(i)) continue;
            if (removed.isGroupEmpty(i)) {
                this.strategies.get(i).addSSTables(added.getGroup(i));
                continue;
            }
            this.strategies.get(i).replaceSSTables(removed.getGroup(i), added.getGroup(i));
        }
    }

    public AbstractCompactionStrategy first() {
        return this.strategies.get(0);
    }

    @Override
    public List<ISSTableScanner> getScanners(AbstractStrategyHolder.GroupedSSTableContainer sstables, Collection<Range<Token>> ranges) {
        ArrayList<ISSTableScanner> scanners = new ArrayList<ISSTableScanner>(this.strategies.size());
        for (int i = 0; i < this.strategies.size(); ++i) {
            if (sstables.isGroupEmpty(i)) continue;
            scanners.addAll(this.strategies.get((int)i).getScanners(sstables.getGroup((int)i), ranges).scanners);
        }
        return scanners;
    }

    Collection<Collection<SSTableReader>> groupForAnticompaction(Iterable<SSTableReader> sstables) {
        Preconditions.checkState((!this.isRepaired ? 1 : 0) != 0);
        AbstractStrategyHolder.GroupedSSTableContainer group = this.createGroupedSSTableContainer();
        sstables.forEach(group::add);
        ArrayList<Collection<SSTableReader>> anticompactionGroups = new ArrayList<Collection<SSTableReader>>();
        for (int i = 0; i < this.strategies.size(); ++i) {
            if (group.isGroupEmpty(i)) continue;
            anticompactionGroups.addAll(this.strategies.get(i).groupSSTablesForAntiCompaction(group.getGroup(i)));
        }
        return anticompactionGroups;
    }

    @Override
    public SSTableMultiWriter createSSTableMultiWriter(Descriptor descriptor, long keyCount, long repairedAt, TimeUUID pendingRepair, boolean isTransient, IntervalSet<CommitLogPosition> commitLogPositions, int sstableLevel, SerializationHeader header, Collection<Index.Group> indexGroups, LifecycleNewTracker lifecycleNewTracker) {
        if (this.isRepaired) {
            Preconditions.checkArgument((repairedAt != 0L ? 1 : 0) != 0, (Object)"Repaired CompactionStrategyHolder can't create unrepaired sstable writers");
        } else {
            Preconditions.checkArgument((repairedAt == 0L ? 1 : 0) != 0, (Object)"Unrepaired CompactionStrategyHolder can't create repaired sstable writers");
        }
        Preconditions.checkArgument((pendingRepair == null ? 1 : 0) != 0, (Object)"CompactionStrategyHolder can't create sstable writer with pendingRepair id");
        AbstractCompactionStrategy strategy = this.strategies.get(this.router.getIndexForSSTableDirectory(descriptor));
        return strategy.createSSTableMultiWriter(descriptor, keyCount, repairedAt, pendingRepair, isTransient, commitLogPositions, sstableLevel, header, indexGroups, lifecycleNewTracker);
    }

    @Override
    public int getStrategyIndex(AbstractCompactionStrategy strategy) {
        return this.strategies.indexOf(strategy);
    }

    @Override
    public boolean containsSSTable(SSTableReader sstable) {
        return Iterables.any(this.strategies, acs -> acs.getSSTables().contains(sstable));
    }

    @Override
    public int getEstimatedRemainingTasks() {
        int tasks = 0;
        for (AbstractCompactionStrategy strategy : this.strategies) {
            tasks += strategy.getEstimatedRemainingTasks();
        }
        return tasks;
    }
}

