/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions.types;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.cql3.functions.types.CodecUtils;
import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.TypeCodec;
import org.apache.cassandra.cql3.functions.types.TypeTokens;
import org.apache.cassandra.cql3.functions.types.VectorType;
import org.apache.cassandra.cql3.functions.types.exceptions.InvalidTypeException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.vint.VIntCoding;

public abstract class VectorCodec<E>
extends TypeCodec<List<E>> {
    protected final VectorType type;
    protected final TypeCodec<E> subtypeCodec;

    private VectorCodec(VectorType type, TypeCodec<E> subtypeCodec) {
        super((DataType)type, TypeTokens.vectorOf(subtypeCodec.getJavaType()));
        this.type = type;
        this.subtypeCodec = subtypeCodec;
    }

    public static <E> VectorCodec<E> of(VectorType type, TypeCodec<E> subtypeCodec) {
        return subtypeCodec.isSerializedSizeFixed() ? new FixedLength<E>(type, subtypeCodec) : new VariableLength<E>(type, subtypeCodec);
    }

    @Override
    public List<E> parse(String value) throws InvalidTypeException {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        ImmutableList.Builder values = ImmutableList.builder();
        for (String element : Splitter.on((String)", ").split((CharSequence)value.substring(1, value.length() - 1))) {
            values.add(this.subtypeCodec.parse(element));
        }
        return values.build();
    }

    @Override
    public String format(List<E> value) throws InvalidTypeException {
        return value == null ? "NULL" : Iterables.toString(value);
    }

    private static class VariableLength<E>
    extends VectorCodec<E> {
        public VariableLength(VectorType type, TypeCodec<E> subtypeCodec) {
            super(type, subtypeCodec);
        }

        @Override
        public ByteBuffer serialize(List<E> values, ProtocolVersion version) throws InvalidTypeException {
            if (values == null) {
                return null;
            }
            assert (values.size() == this.type.getDimensions());
            int i = 0;
            int outputSize = 0;
            ByteBuffer[] buffers = new ByteBuffer[values.size()];
            for (E value : values) {
                ByteBuffer bb = this.subtypeCodec.serialize(value, version);
                buffers[i++] = bb;
                int elemSize = bb.remaining();
                outputSize += elemSize + VIntCoding.computeUnsignedVIntSize(elemSize);
            }
            ByteBuffer output = ByteBuffer.allocate(outputSize);
            for (ByteBuffer bb : buffers) {
                VIntCoding.writeUnsignedVInt32(bb.remaining(), output);
                output.put(bb.duplicate());
            }
            return output.flip();
        }

        @Override
        public List<E> deserialize(ByteBuffer bytes, ProtocolVersion version) throws InvalidTypeException {
            if (bytes == null || bytes.remaining() == 0) {
                return null;
            }
            ByteBuffer input = bytes.duplicate();
            ImmutableList.Builder values = ImmutableList.builder();
            for (int i = 0; i < this.type.getDimensions(); ++i) {
                int size = VIntCoding.getUnsignedVInt32(input, input.position());
                input.position(input.position() + VIntCoding.computeUnsignedVIntSize(size));
                ByteBuffer value = size < 0 ? null : CodecUtils.readBytes(input, size);
                values.add(this.subtypeCodec.deserialize(value, version));
            }
            return values.build();
        }
    }

    private static class FixedLength<E>
    extends VectorCodec<E> {
        private final int valueLength;

        public FixedLength(VectorType type, TypeCodec<E> subtypeCodec) {
            super(type, subtypeCodec);
            this.valueLength = subtypeCodec.serializedSize() * type.getDimensions();
        }

        @Override
        public int serializedSize() {
            return this.valueLength;
        }

        @Override
        public ByteBuffer serialize(List<E> value, ProtocolVersion protocolVersion) throws InvalidTypeException {
            if (value == null || this.type.getDimensions() <= 0) {
                return null;
            }
            Iterator<E> values = value.iterator();
            ByteBuffer rv = ByteBuffer.allocate(this.valueLength);
            for (int i = 0; i < this.type.getDimensions(); ++i) {
                ByteBuffer valueBuff = this.subtypeCodec.serialize(values.next(), protocolVersion);
                valueBuff.rewind();
                rv.put(valueBuff);
            }
            rv.flip();
            return rv;
        }

        @Override
        public List<E> deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
            if (bytes == null || bytes.remaining() == 0) {
                return null;
            }
            int elementSize = Math.floorDiv(bytes.remaining(), this.type.getDimensions());
            assert (bytes.remaining() % this.type.getDimensions() == 0) : String.format("Expected elements of uniform size, observed %d elements with total bytes %d", this.type.getDimensions(), bytes.remaining());
            ImmutableList.Builder values = ImmutableList.builder();
            for (int i = 0; i < this.type.getDimensions(); ++i) {
                ByteBuffer slice = bytes.slice();
                slice.limit(elementSize);
                values.add(this.subtypeCodec.deserialize(slice, protocolVersion));
                bytes.position(bytes.position() + elementSize);
            }
            bytes.rewind();
            return values.build();
        }
    }
}

