/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.net.InetAddress;
import java.util.Set;
import org.apache.cassandra.auth.AllowAllCIDRAuthorizer;
import org.apache.cassandra.auth.CIDRGroupsMappingManager;
import org.apache.cassandra.auth.CIDRPermissions;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.metrics.CIDRAuthorizerMetrics;
import org.apache.cassandra.utils.FBUtilities;

public interface ICIDRAuthorizer {
    public static ICIDRAuthorizer newCIDRAuthorizer(ParameterizedClass cidrAuthorizer) {
        if (cidrAuthorizer == null || cidrAuthorizer.class_name == null) {
            return new AllowAllCIDRAuthorizer();
        }
        Object className = cidrAuthorizer.class_name;
        if (!((String)className).contains(".")) {
            className = "org.apache.cassandra.auth." + (String)className;
        }
        return (ICIDRAuthorizer)FBUtilities.construct((String)className, "cidr authorizer");
    }

    public void setup();

    public void initCaches();

    public CIDRGroupsMappingManager getCidrGroupsMappingManager();

    public CIDRAuthorizerMetrics getCidrAuthorizerMetrics();

    public boolean requireAuthorization();

    public void setCidrGroupsForRole(RoleResource var1, CIDRPermissions var2);

    public void dropCidrPermissionsForRole(RoleResource var1);

    public boolean invalidateCidrPermissionsCache(String var1);

    public void validateConfiguration() throws ConfigurationException;

    public void loadCidrGroupsCache();

    public Set<String> lookupCidrGroupsForIp(InetAddress var1);

    public boolean hasAccessFromIp(RoleResource var1, InetAddress var2);

    public static enum CIDRAuthorizerMode {
        MONITOR,
        ENFORCE;

    }
}

