/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.cassandra.auth.AuthProperties;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IAuthorizer;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.PermissionDetails;
import org.apache.cassandra.auth.Resources;
import org.apache.cassandra.auth.Role;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.auth.Roles;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.BatchQueryOptions;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraAuthorizer
implements IAuthorizer {
    private static final Logger logger = LoggerFactory.getLogger(CassandraAuthorizer.class);
    private static final String ROLE = "role";
    private static final String RESOURCE = "resource";
    private static final String PERMISSIONS = "permissions";
    private SelectStatement authorizeRoleStatement;

    @Override
    public Set<Permission> authorize(AuthenticatedUser user, IResource resource) {
        try {
            if (user.isSuper()) {
                return resource.applicablePermissions();
            }
            EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);
            for (Role role : user.getRoleDetails()) {
                this.addPermissionsForRole(permissions, resource, role.resource);
            }
            return permissions;
        }
        catch (RequestExecutionException | RequestValidationException e) {
            logger.debug("Failed to authorize {} for {}", (Object)user, (Object)resource);
            throw new UnauthorizedException("Unable to perform authorization of permissions: " + e.getMessage(), e);
        }
    }

    @Override
    public Set<Permission> grant(AuthenticatedUser performer, Set<Permission> permissions, IResource resource, RoleResource grantee) throws RequestValidationException, RequestExecutionException {
        String resourceName;
        String roleName = this.escape(grantee.getRoleName());
        Set<Permission> existingPermissions = this.getExistingPermissions(roleName, resourceName = this.escape(resource.getName()), permissions);
        Sets.SetView nonExistingPermissions = Sets.difference(permissions, existingPermissions);
        if (!nonExistingPermissions.isEmpty()) {
            this.modifyRolePermissions((Set<Permission>)nonExistingPermissions, resource, grantee, "+");
            this.addLookupEntry(resource, grantee);
        }
        return nonExistingPermissions;
    }

    @Override
    public Set<Permission> revoke(AuthenticatedUser performer, Set<Permission> permissions, IResource resource, RoleResource revokee) throws RequestValidationException, RequestExecutionException {
        String resourceName;
        String roleName = this.escape(revokee.getRoleName());
        Set<Permission> existingPermissions = this.getExistingPermissions(roleName, resourceName = this.escape(resource.getName()), permissions);
        if (!existingPermissions.isEmpty()) {
            this.modifyRolePermissions(existingPermissions, resource, revokee, "-");
            this.removeLookupEntry(resource, revokee);
        }
        return existingPermissions;
    }

    @Override
    public void revokeAllFrom(RoleResource revokee) {
        try {
            UntypedResultSet rows = this.process(String.format("SELECT resource FROM %s.%s WHERE role = '%s'", "system_auth", "role_permissions", this.escape(revokee.getRoleName())), CassandraAuthorizer.authReadConsistencyLevel());
            ArrayList<CQLStatement> statements = new ArrayList<CQLStatement>();
            for (UntypedResultSet.Row row : rows) {
                statements.add(QueryProcessor.getStatement(String.format("DELETE FROM %s.%s WHERE resource = '%s' AND role = '%s'", "system_auth", "resource_role_permissons_index", this.escape(row.getString(RESOURCE)), this.escape(revokee.getRoleName())), ClientState.forInternalCalls()));
            }
            statements.add(QueryProcessor.getStatement(String.format("DELETE FROM %s.%s WHERE role = '%s'", "system_auth", "role_permissions", this.escape(revokee.getRoleName())), ClientState.forInternalCalls()));
            this.executeLoggedBatch(statements);
        }
        catch (RequestExecutionException | RequestValidationException e) {
            logger.warn(String.format("CassandraAuthorizer failed to revoke all permissions of %s", revokee.getRoleName()), (Throwable)e);
        }
    }

    @Override
    public void revokeAllOn(IResource droppedResource) {
        try {
            UntypedResultSet rows = this.process(String.format("SELECT role FROM %s.%s WHERE resource = '%s'", "system_auth", "resource_role_permissons_index", this.escape(droppedResource.getName())), CassandraAuthorizer.authReadConsistencyLevel());
            ArrayList<CQLStatement> statements = new ArrayList<CQLStatement>();
            for (UntypedResultSet.Row row : rows) {
                statements.add(QueryProcessor.getStatement(String.format("DELETE FROM %s.%s WHERE role = '%s' AND resource = '%s'", "system_auth", "role_permissions", this.escape(row.getString(ROLE)), this.escape(droppedResource.getName())), ClientState.forInternalCalls()));
            }
            statements.add(QueryProcessor.getStatement(String.format("DELETE FROM %s.%s WHERE resource = '%s'", "system_auth", "resource_role_permissons_index", this.escape(droppedResource.getName())), ClientState.forInternalCalls()));
            this.executeLoggedBatch(statements);
        }
        catch (RequestExecutionException | RequestValidationException e) {
            logger.warn(String.format("CassandraAuthorizer failed to revoke all permissions on %s", droppedResource), (Throwable)e);
        }
    }

    private Set<Permission> getExistingPermissions(String roleName, String resourceName, Set<Permission> expectedPermissions) {
        UntypedResultSet rs = this.process(String.format("SELECT permissions FROM %s.%s WHERE role = '%s' AND resource = '%s'", "system_auth", "role_permissions", roleName, resourceName), ConsistencyLevel.LOCAL_ONE);
        if (rs.isEmpty()) {
            return Collections.emptySet();
        }
        UntypedResultSet.Row one = rs.one();
        HashSet existingPermissions = Sets.newHashSetWithExpectedSize((int)expectedPermissions.size());
        for (String permissionName : one.getSet(PERMISSIONS, UTF8Type.instance)) {
            Permission permission = Permission.valueOf(permissionName);
            if (!expectedPermissions.contains((Object)permission)) continue;
            existingPermissions.add(permission);
        }
        return existingPermissions;
    }

    private void executeLoggedBatch(List<CQLStatement> statements) throws RequestExecutionException, RequestValidationException {
        BatchStatement batch = new BatchStatement(BatchStatement.Type.LOGGED, VariableSpecifications.empty(), Lists.newArrayList((Iterable)Iterables.filter(statements, ModificationStatement.class)), Attributes.none());
        this.processBatch(batch);
    }

    private void addPermissionsForRole(Set<Permission> permissions, IResource resource, RoleResource role) throws RequestExecutionException, RequestValidationException {
        QueryOptions options = QueryOptions.forInternalCalls(CassandraAuthorizer.authReadConsistencyLevel(), Lists.newArrayList((Object[])new ByteBuffer[]{ByteBufferUtil.bytes(role.getRoleName()), ByteBufferUtil.bytes(resource.getName())}));
        ResultMessage.Rows rows = this.select(this.authorizeRoleStatement, options);
        UntypedResultSet result = UntypedResultSet.create(rows.result);
        if (!result.isEmpty() && result.one().has(PERMISSIONS)) {
            for (String perm : result.one().getSet(PERMISSIONS, UTF8Type.instance)) {
                permissions.add(Permission.valueOf(perm));
            }
        }
    }

    private void modifyRolePermissions(Set<Permission> permissions, IResource resource, RoleResource role, String op) throws RequestExecutionException {
        this.process(String.format("UPDATE %s.%s SET permissions = permissions %s {%s} WHERE role = '%s' AND resource = '%s'", "system_auth", "role_permissions", op, "'" + StringUtils.join(permissions, (String)"','") + "'", this.escape(role.getRoleName()), this.escape(resource.getName())), CassandraAuthorizer.authWriteConsistencyLevel());
    }

    private void removeLookupEntry(IResource resource, RoleResource role) throws RequestExecutionException {
        this.process(String.format("DELETE FROM %s.%s WHERE resource = '%s' and role = '%s'", "system_auth", "resource_role_permissons_index", this.escape(resource.getName()), this.escape(role.getRoleName())), CassandraAuthorizer.authWriteConsistencyLevel());
    }

    private void addLookupEntry(IResource resource, RoleResource role) throws RequestExecutionException {
        this.process(String.format("INSERT INTO %s.%s (resource, role) VALUES ('%s','%s')", "system_auth", "resource_role_permissons_index", this.escape(resource.getName()), this.escape(role.getRoleName())), CassandraAuthorizer.authWriteConsistencyLevel());
    }

    @Override
    public Set<PermissionDetails> list(AuthenticatedUser performer, Set<Permission> permissions, IResource resource, RoleResource grantee) throws RequestValidationException, RequestExecutionException {
        if (!(performer.isSuper() || performer.isSystem() || performer.getRoles().contains(grantee) || performer.getPermissions(RoleResource.root()).contains((Object)Permission.DESCRIBE) || grantee != null && performer.getPermissions(grantee).contains((Object)Permission.DESCRIBE))) {
            throw new UnauthorizedException(String.format("You are not authorized to view %s's permissions", grantee == null ? "everyone" : grantee.getRoleName()));
        }
        if (null == grantee) {
            return this.listPermissionsForRole(permissions, resource, null);
        }
        Set<RoleResource> roles = DatabaseDescriptor.getRoleManager().getRoles(grantee, true);
        HashSet<PermissionDetails> details = new HashSet<PermissionDetails>();
        for (RoleResource role : roles) {
            details.addAll(this.listPermissionsForRole(permissions, resource, role));
        }
        return details;
    }

    private Set<PermissionDetails> listPermissionsForRole(Set<Permission> permissions, IResource resource, RoleResource role) throws RequestExecutionException {
        HashSet<PermissionDetails> details = new HashSet<PermissionDetails>();
        for (UntypedResultSet.Row row : this.process(this.buildListQuery(resource, role), CassandraAuthorizer.authReadConsistencyLevel())) {
            if (!row.has(PERMISSIONS)) continue;
            for (String p : row.getSet(PERMISSIONS, UTF8Type.instance)) {
                Permission permission = Permission.valueOf(p);
                if (!permissions.contains((Object)permission)) continue;
                details.add(new PermissionDetails(row.getString(ROLE), Resources.fromName(row.getString(RESOURCE)), permission));
            }
        }
        return details;
    }

    private String buildListQuery(IResource resource, RoleResource grantee) {
        ArrayList vars = Lists.newArrayList((Object[])new String[]{"system_auth", "role_permissions"});
        ArrayList<String> conditions = new ArrayList<String>();
        if (resource != null) {
            conditions.add("resource = '%s'");
            vars.add(this.escape(resource.getName()));
        }
        if (grantee != null) {
            conditions.add("role = '%s'");
            vars.add(this.escape(grantee.getRoleName()));
        }
        Object query = "SELECT role, resource, permissions FROM %s.%s";
        if (!conditions.isEmpty()) {
            query = (String)query + " WHERE " + StringUtils.join(conditions, (String)" AND ");
        }
        if (resource != null && grantee == null) {
            query = (String)query + " ALLOW FILTERING";
        }
        return String.format((String)query, vars.toArray());
    }

    public Set<DataResource> protectedResources() {
        return ImmutableSet.of((Object)DataResource.table("system_auth", "role_permissions"));
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
    }

    @Override
    public void setup() {
        this.authorizeRoleStatement = this.prepare(ROLE, "role_permissions");
    }

    private SelectStatement prepare(String entityname, String permissionsTable) {
        String query = String.format("SELECT permissions FROM %s.%s WHERE %s = ? AND resource = ?", "system_auth", permissionsTable, entityname);
        return (SelectStatement)QueryProcessor.getStatement(query, ClientState.forInternalCalls());
    }

    private String escape(String name) {
        return StringUtils.replace((String)name, (String)"'", (String)"''");
    }

    ResultMessage.Rows select(SelectStatement statement, QueryOptions options) {
        return statement.execute(QueryState.forInternalCalls(), options, Clock.Global.nanoTime());
    }

    @VisibleForTesting
    UntypedResultSet process(String query, ConsistencyLevel cl) throws RequestExecutionException {
        return QueryProcessor.process(query, cl);
    }

    void processBatch(BatchStatement statement) {
        QueryOptions options = QueryOptions.forInternalCalls(CassandraAuthorizer.authWriteConsistencyLevel(), Collections.emptyList());
        QueryProcessor.instance.processBatch(statement, QueryState.forInternalCalls(), BatchQueryOptions.withoutPerStatementVariables(options), Clock.Global.nanoTime());
    }

    public static ConsistencyLevel authWriteConsistencyLevel() {
        return AuthProperties.instance.getWriteConsistencyLevel();
    }

    public static ConsistencyLevel authReadConsistencyLevel() {
        return AuthProperties.instance.getReadConsistencyLevel();
    }

    @Override
    public Supplier<Map<Pair<AuthenticatedUser, IResource>, Set<Permission>>> bulkLoader() {
        return () -> {
            HashMap entries = new HashMap();
            String cqlTemplate = "SELECT %s, %s, %s FROM %s.%s";
            logger.info("Warming permissions cache from role_permissions table");
            UntypedResultSet results = this.process(String.format(cqlTemplate, ROLE, RESOURCE, PERMISSIONS, "system_auth", "role_permissions"), AuthProperties.instance.getReadConsistencyLevel());
            HashBasedTable individualRolePermissions = HashBasedTable.create();
            results.forEach(arg_0 -> CassandraAuthorizer.lambda$bulkLoader$0((Table)individualRolePermissions, arg_0));
            Roles.getAllRoles().forEach(arg_0 -> CassandraAuthorizer.lambda$bulkLoader$3((Table)individualRolePermissions, entries, arg_0));
            return entries;
        };
    }

    private static BiConsumer<IResource, Set<Permission>> accumulator(Map<IResource, ImmutableSet.Builder<Permission>> accumulator) {
        return (resource, permissions) -> accumulator.computeIfAbsent((IResource)resource, k -> new ImmutableSet.Builder()).addAll((Iterable)permissions);
    }

    private static Set<Permission> permissions(Set<String> permissionNames) {
        return permissionNames.stream().map(Permission::valueOf).collect(Collectors.toSet());
    }

    private static Pair<AuthenticatedUser, IResource> cacheKey(RoleResource role, IResource resource) {
        return CassandraAuthorizer.cacheKey(role.getRoleName(), resource);
    }

    private static Pair<AuthenticatedUser, IResource> cacheKey(String roleName, IResource resource) {
        return Pair.create(new AuthenticatedUser(roleName), resource);
    }

    private static /* synthetic */ void lambda$bulkLoader$3(Table individualRolePermissions, Map entries, RoleResource roleResource) {
        if (Roles.canLogin(roleResource)) {
            HashMap<IResource, ImmutableSet.Builder<Permission>> userPermissions = new HashMap<IResource, ImmutableSet.Builder<Permission>>();
            BiConsumer<IResource, Set<Permission>> accumulator = CassandraAuthorizer.accumulator(userPermissions);
            Roles.getRoleDetails(roleResource).forEach(grantedRole -> individualRolePermissions.rowMap().getOrDefault(grantedRole.resource.getRoleName(), Collections.emptyMap()).forEach(accumulator));
            userPermissions.forEach((resource, builder) -> entries.put(CassandraAuthorizer.cacheKey(roleResource, resource), builder.build()));
        }
    }

    private static /* synthetic */ void lambda$bulkLoader$0(Table individualRolePermissions, UntypedResultSet.Row row) {
        if (row.has(PERMISSIONS)) {
            individualRolePermissions.put((Object)row.getString(ROLE), (Object)Resources.fromName(row.getString(RESOURCE)), CassandraAuthorizer.permissions(row.getSet(PERMISSIONS, UTF8Type.instance)));
        }
    }
}

