/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.auth.CIDRGroupsMappingManagerMBean;
import org.apache.cassandra.auth.CassandraAuthorizer;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.CIDR;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.MBeanWrapper;
import org.apache.cassandra.utils.Pair;

public class CIDRGroupsMappingManager
implements CIDRGroupsMappingManagerMBean {
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=CIDRGroupsMappingManager";
    private SelectStatement getCidrGroupsStatement;
    private SelectStatement getCidrsForCidrGroupStatement;
    private static final int PAGE_SIZE = 128;

    public void setup() {
        if (!MBeanWrapper.instance.isRegistered(MBEAN_NAME)) {
            MBeanWrapper.instance.registerMBean((Object)this, MBEAN_NAME);
        }
        String getCidrGroupsQuery = String.format("SELECT %s FROM %s.%s", "cidr_group", "system_auth", "cidr_groups");
        this.getCidrGroupsStatement = (SelectStatement)QueryProcessor.getStatement(getCidrGroupsQuery, ClientState.forInternalCalls());
        String getCidrsForCidrGroupQuery = String.format("SELECT %s FROM %s.%s where %s = ?", "cidrs", "system_auth", "cidr_groups", "cidr_group");
        this.getCidrsForCidrGroupStatement = (SelectStatement)QueryProcessor.getStatement(getCidrsForCidrGroupQuery, ClientState.forInternalCalls());
    }

    @VisibleForTesting
    ResultMessage.Rows select(SelectStatement statement, QueryOptions options) {
        return statement.execute(QueryState.forInternalCalls(), options, Clock.Global.nanoTime());
    }

    UntypedResultSet process(String query, ConsistencyLevel cl) throws RequestExecutionException {
        return QueryProcessor.process(query, cl);
    }

    protected static String getCidrTuplesSetString(List<CIDR> cidrs) {
        String inner = cidrs.stream().map(CIDR::asCqlTupleString).collect(Collectors.joining(", "));
        return "{" + inner + "}";
    }

    public UntypedResultSet getCidrGroupsTableEntries() {
        String getAllRowsQuery = String.format("SELECT * FROM %s.%s", "system_auth", "cidr_groups");
        return QueryProcessor.executeInternalWithPaging(getAllRowsQuery, 128, new Object[0]);
    }

    @Override
    public Set<String> getAvailableCidrGroups() {
        HashSet<String> availableCidrGroups = new HashSet<String>();
        QueryOptions options = QueryOptions.forInternalCalls(CassandraAuthorizer.authReadConsistencyLevel(), Collections.emptyList());
        ResultMessage.Rows rows = this.select(this.getCidrGroupsStatement, options);
        UntypedResultSet result = UntypedResultSet.create(rows.result);
        for (UntypedResultSet.Row row : result) {
            if (!row.has("cidr_group")) {
                throw new IllegalStateException("Invalid row " + row + " in table: system_auth.cidr_groups");
            }
            availableCidrGroups.add(row.getString("cidr_group"));
        }
        return availableCidrGroups;
    }

    public Set<Pair<InetAddress, Short>> retrieveCidrsFromRow(UntypedResultSet.Row row) {
        if (!row.has("cidrs")) {
            throw new RuntimeException("Invalid row, doesn't have column cidrs");
        }
        HashSet<Pair<InetAddress, Short>> cidrs = new HashSet<Pair<InetAddress, Short>>();
        TupleType tupleType = new TupleType(Arrays.asList(InetAddressType.instance, ShortType.instance));
        Set<ByteBuffer> cidrAsTuples = row.getFrozenSet("cidrs", tupleType);
        for (ByteBuffer cidrAsTuple : cidrAsTuples) {
            ByteBuffer[] splits = tupleType.split(ByteBufferAccessor.instance, cidrAsTuple);
            InetAddress ip = (InetAddress)InetAddressType.instance.compose(splits[0]);
            short netMask = (Short)ShortType.instance.compose(splits[1]);
            cidrs.add(Pair.create(ip, netMask));
        }
        return cidrs;
    }

    @Override
    public Set<String> getCidrsOfCidrGroupAsStrings(String cidrGroupName) {
        QueryOptions options = QueryOptions.forInternalCalls(CassandraAuthorizer.authReadConsistencyLevel(), Lists.newArrayList((Object[])new ByteBuffer[]{ByteBufferUtil.bytes(cidrGroupName)}));
        ResultMessage.Rows rows = this.select(this.getCidrsForCidrGroupStatement, options);
        UntypedResultSet result = UntypedResultSet.create(rows.result);
        if (result.isEmpty()) {
            return Collections.emptySet();
        }
        Set<Pair<InetAddress, Short>> allCidrs = this.retrieveCidrsFromRow(result.one());
        HashSet<String> cidrStrs = new HashSet<String>();
        for (Pair<InetAddress, Short> cidr : allCidrs) {
            cidrStrs.add(cidr.left().getHostAddress() + "/" + cidr.right());
        }
        return cidrStrs;
    }

    @Override
    public void updateCidrGroup(String cidrGroupName, List<String> cidrs) {
        ArrayList<CIDR> validCidrs = new ArrayList<CIDR>();
        for (String cidr : cidrs) {
            validCidrs.add(CIDR.getInstance(cidr));
        }
        String query = String.format("UPDATE %s.%s SET %s = %s WHERE %s = '%s'", "system_auth", "cidr_groups", "cidrs", CIDRGroupsMappingManager.getCidrTuplesSetString(validCidrs), "cidr_group", cidrGroupName);
        this.process(query, CassandraAuthorizer.authWriteConsistencyLevel());
    }

    @VisibleForTesting
    void dropCidrGroupIfExists(String cidrGroupName) {
        String query = String.format("DELETE FROM %s.%s WHERE cidr_group = '%s'", "system_auth", "cidr_groups", cidrGroupName);
        this.process(query, CassandraAuthorizer.authWriteConsistencyLevel());
    }

    @Override
    public void dropCidrGroup(String cidrGroupName) {
        Set<String> cidrs = this.getCidrsOfCidrGroupAsStrings(cidrGroupName);
        if (cidrs.isEmpty()) {
            throw new RuntimeException("CIDR group '" + cidrGroupName + "' doesn't exists");
        }
        this.dropCidrGroupIfExists(cidrGroupName);
    }

    @Override
    public void recreateCidrGroupsMapping(Map<String, List<String>> cidrGroupsMapping) {
        Set<String> existingMappings = this.getAvailableCidrGroups();
        for (Map.Entry<String, List<String>> cidrGroupMapping : cidrGroupsMapping.entrySet()) {
            String cidrGroupName = cidrGroupMapping.getKey();
            this.updateCidrGroup(cidrGroupName, cidrGroupMapping.getValue());
            existingMappings.remove(cidrGroupName);
        }
        for (String cidrGroupName : existingMappings) {
            this.dropCidrGroupIfExists(cidrGroupName);
        }
    }

    @Override
    public Set<String> getCidrGroupsOfIP(String ipStr) {
        try {
            return DatabaseDescriptor.getCIDRAuthorizer().lookupCidrGroupsForIp(InetAddress.getByName(ipStr));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IP " + ipStr, e);
        }
    }

    @Override
    public void loadCidrGroupsCache() {
        DatabaseDescriptor.getCIDRAuthorizer().loadCidrGroupsCache();
    }
}

