/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import javax.inject.Provider;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.schema.DefaultSchemaUpdateHandlerFactory;
import org.apache.cassandra.schema.SchemaUpdateHandlerFactory;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang3.StringUtils;

public class SchemaUpdateHandlerFactoryProvider
implements Provider<SchemaUpdateHandlerFactory> {
    @Deprecated
    public static final String SUH_FACTORY_CLASS_PROPERTY = "cassandra.schema.update_handler_factory.class";
    public static final SchemaUpdateHandlerFactoryProvider instance = new SchemaUpdateHandlerFactoryProvider();

    public SchemaUpdateHandlerFactory get() {
        String suhFactoryClassName = StringUtils.trimToNull((String)CassandraRelevantProperties.SCHEMA_UPDATE_HANDLER_FACTORY_CLASS.getString());
        if (suhFactoryClassName == null) {
            return DefaultSchemaUpdateHandlerFactory.instance;
        }
        Class suhFactoryClass = FBUtilities.classForName(suhFactoryClassName, "schema update handler factory");
        try {
            return (SchemaUpdateHandlerFactory)suhFactoryClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new ConfigurationException(String.format("Failed to initialize schema update handler factory class %s defined in %s system property.", suhFactoryClassName, CassandraRelevantProperties.SCHEMA_UPDATE_HANDLER_FACTORY_CLASS.getKey()), ex);
        }
    }
}

