/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.collect.Iterables;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;

public interface ReplicaPlan<E extends Endpoints<E>, P extends ReplicaPlan<E, P>> {
    public Keyspace keyspace();

    public AbstractReplicationStrategy replicationStrategy();

    public ConsistencyLevel consistencyLevel();

    public E contacts();

    public Replica lookup(InetAddressAndPort var1);

    public P withContacts(E var1);

    public static SharedForTokenRead shared(ForTokenRead replicaPlan) {
        return new SharedForTokenRead(replicaPlan);
    }

    public static SharedForRangeRead shared(ForRangeRead replicaPlan) {
        return new SharedForRangeRead(replicaPlan);
    }

    public static class SharedForRangeRead
    implements Shared<EndpointsForRange, ForRangeRead> {
        private ForRangeRead replicaPlan;

        SharedForRangeRead(ForRangeRead replicaPlan) {
            this.replicaPlan = replicaPlan;
        }

        @Override
        public void addToContacts(Replica replica) {
            this.replicaPlan = this.replicaPlan.withContacts(Endpoints.append((EndpointsForRange)this.replicaPlan.contacts(), replica));
        }

        @Override
        public ForRangeRead get() {
            return this.replicaPlan;
        }
    }

    public static class SharedForTokenRead
    implements Shared<EndpointsForToken, ForTokenRead> {
        private ForTokenRead replicaPlan;

        SharedForTokenRead(ForTokenRead replicaPlan) {
            this.replicaPlan = replicaPlan;
        }

        @Override
        public void addToContacts(Replica replica) {
            this.replicaPlan = this.replicaPlan.withContacts(Endpoints.append((EndpointsForToken)this.replicaPlan.contacts(), replica));
        }

        @Override
        public ForTokenRead get() {
            return this.replicaPlan;
        }
    }

    public static interface Shared<E extends Endpoints<E>, P extends ReplicaPlan<E, P>>
    extends Supplier<P> {
        public void addToContacts(Replica var1);

        @Override
        public P get();
    }

    public static class ForPaxosWrite
    extends ForWrite {
        final int requiredParticipants;

        ForPaxosWrite(Keyspace keyspace, ConsistencyLevel consistencyLevel, EndpointsForToken pending, EndpointsForToken liveAndDown, EndpointsForToken live, EndpointsForToken contact, int requiredParticipants) {
            super(keyspace, keyspace.getReplicationStrategy(), consistencyLevel, pending, liveAndDown, live, contact);
            this.requiredParticipants = requiredParticipants;
        }

        public int requiredParticipants() {
            return this.requiredParticipants;
        }
    }

    public static class ForWrite
    extends AbstractReplicaPlan<EndpointsForToken, ForWrite> {
        final EndpointsForToken pending;
        final EndpointsForToken liveAndDown;
        final EndpointsForToken live;

        public ForWrite(Keyspace keyspace, AbstractReplicationStrategy replicationStrategy, ConsistencyLevel consistencyLevel, EndpointsForToken pending, EndpointsForToken liveAndDown, EndpointsForToken live, EndpointsForToken contact) {
            super(keyspace, replicationStrategy, consistencyLevel, contact);
            this.pending = pending;
            this.liveAndDown = liveAndDown;
            this.live = live;
        }

        public int writeQuorum() {
            return this.consistencyLevel.blockForWrite(this.replicationStrategy, this.pending());
        }

        public EndpointsForToken pending() {
            return this.pending;
        }

        public EndpointsForToken liveAndDown() {
            return this.liveAndDown;
        }

        public EndpointsForToken live() {
            return this.live;
        }

        public EndpointsForToken liveUncontacted() {
            return (EndpointsForToken)this.live().filter(r -> !((EndpointsForToken)this.contacts()).contains((Replica)r));
        }

        public boolean isAlive(Replica replica) {
            return this.live.endpoints().contains(replica.endpoint());
        }

        @Override
        public Replica lookup(InetAddressAndPort endpoint) {
            return this.liveAndDown().byEndpoint().get(endpoint);
        }

        private ForWrite copy(ConsistencyLevel newConsistencyLevel, EndpointsForToken newContact) {
            return new ForWrite(this.keyspace, this.replicationStrategy, newConsistencyLevel, this.pending(), this.liveAndDown(), this.live(), newContact);
        }

        ForWrite withConsistencyLevel(ConsistencyLevel newConsistencylevel) {
            return this.copy(newConsistencylevel, (EndpointsForToken)this.contacts());
        }

        @Override
        public ForWrite withContacts(EndpointsForToken newContact) {
            return this.copy(this.consistencyLevel, newContact);
        }

        public String toString() {
            return "ReplicaPlan.ForWrite [ CL: " + this.consistencyLevel + " keyspace: " + this.keyspace + " liveAndDown: " + this.liveAndDown + " live: " + this.live + " contacts: " + this.contacts() + " ]";
        }
    }

    public static class ForRangeRead
    extends AbstractForRead<EndpointsForRange, ForRangeRead> {
        final AbstractBounds<PartitionPosition> range;
        final int vnodeCount;

        public ForRangeRead(Keyspace keyspace, AbstractReplicationStrategy replicationStrategy, ConsistencyLevel consistencyLevel, AbstractBounds<PartitionPosition> range, EndpointsForRange candidates, EndpointsForRange contact, int vnodeCount) {
            super(keyspace, replicationStrategy, consistencyLevel, candidates, contact);
            this.range = range;
            this.vnodeCount = vnodeCount;
        }

        public AbstractBounds<PartitionPosition> range() {
            return this.range;
        }

        public int vnodeCount() {
            return this.vnodeCount;
        }

        @Override
        public ForRangeRead withContacts(EndpointsForRange newContact) {
            return new ForRangeRead(this.keyspace, this.replicationStrategy, this.consistencyLevel, this.range, (EndpointsForRange)this.readCandidates(), newContact, this.vnodeCount);
        }
    }

    public static class ForTokenRead
    extends AbstractForRead<EndpointsForToken, ForTokenRead> {
        public ForTokenRead(Keyspace keyspace, AbstractReplicationStrategy replicationStrategy, ConsistencyLevel consistencyLevel, EndpointsForToken candidates, EndpointsForToken contacts) {
            super(keyspace, replicationStrategy, consistencyLevel, candidates, contacts);
        }

        @Override
        public ForTokenRead withContacts(EndpointsForToken newContact) {
            return new ForTokenRead(this.keyspace, this.replicationStrategy, this.consistencyLevel, (EndpointsForToken)this.candidates, newContact);
        }
    }

    public static abstract class AbstractForRead<E extends Endpoints<E>, P extends ForRead<E, P>>
    extends AbstractReplicaPlan<E, P>
    implements ForRead<E, P> {
        final E candidates;

        AbstractForRead(Keyspace keyspace, AbstractReplicationStrategy replicationStrategy, ConsistencyLevel consistencyLevel, E candidates, E contacts) {
            super(keyspace, replicationStrategy, consistencyLevel, contacts);
            this.candidates = candidates;
        }

        @Override
        public int readQuorum() {
            return this.consistencyLevel.blockFor(this.replicationStrategy);
        }

        @Override
        public E readCandidates() {
            return this.candidates;
        }

        @Override
        public Replica firstUncontactedCandidate(Predicate<Replica> extraPredicate) {
            return (Replica)Iterables.tryFind(this.readCandidates(), r -> extraPredicate.test((Replica)r) && !((Endpoints)this.contacts()).contains((Replica)r)).orNull();
        }

        @Override
        public Replica lookup(InetAddressAndPort endpoint) {
            return ((Endpoints)this.readCandidates()).byEndpoint().get(endpoint);
        }

        public String toString() {
            return "ReplicaPlan.ForRead [ CL: " + this.consistencyLevel + " keyspace: " + this.keyspace + " candidates: " + this.candidates + " contacts: " + this.contacts() + " ]";
        }
    }

    public static abstract class AbstractReplicaPlan<E extends Endpoints<E>, P extends ReplicaPlan<E, P>>
    implements ReplicaPlan<E, P> {
        protected final Keyspace keyspace;
        protected final ConsistencyLevel consistencyLevel;
        protected final AbstractReplicationStrategy replicationStrategy;
        private final E contacts;

        AbstractReplicaPlan(Keyspace keyspace, AbstractReplicationStrategy replicationStrategy, ConsistencyLevel consistencyLevel, E contacts) {
            assert (contacts != null);
            this.keyspace = keyspace;
            this.replicationStrategy = replicationStrategy;
            this.consistencyLevel = consistencyLevel;
            this.contacts = contacts;
        }

        @Override
        public E contacts() {
            return this.contacts;
        }

        @Override
        public Keyspace keyspace() {
            return this.keyspace;
        }

        @Override
        public AbstractReplicationStrategy replicationStrategy() {
            return this.replicationStrategy;
        }

        @Override
        public ConsistencyLevel consistencyLevel() {
            return this.consistencyLevel;
        }
    }

    public static interface ForRead<E extends Endpoints<E>, P extends ForRead<E, P>>
    extends ReplicaPlan<E, P> {
        public int readQuorum();

        public E readCandidates();

        default public Replica firstUncontactedCandidate(Predicate<Replica> extraPredicate) {
            return (Replica)Iterables.tryFind(this.readCandidates(), r -> extraPredicate.test((Replica)r) && !((Endpoints)this.contacts()).contains((Replica)r)).orNull();
        }
    }
}

