/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.nio.ByteBuffer;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.AbstractReaderFileProxy;
import org.apache.cassandra.io.util.BufferManagingRebufferer;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.ChunkReader;
import org.apache.cassandra.io.util.Rebufferer;

class SimpleChunkReader
extends AbstractReaderFileProxy
implements ChunkReader {
    private final int bufferSize;
    private final BufferType bufferType;

    SimpleChunkReader(ChannelProxy channel, long fileLength, BufferType bufferType, int bufferSize) {
        super(channel, fileLength);
        this.bufferSize = bufferSize;
        this.bufferType = bufferType;
    }

    @Override
    public void readChunk(long position, ByteBuffer buffer) {
        buffer.clear();
        this.channel.read(buffer, position);
        buffer.flip();
    }

    @Override
    public int chunkSize() {
        return this.bufferSize;
    }

    @Override
    public BufferType preferredBufferType() {
        return this.bufferType;
    }

    @Override
    public Rebufferer instantiateRebufferer() {
        if (Integer.bitCount(this.bufferSize) == 1) {
            return new BufferManagingRebufferer.Aligned(this);
        }
        return new BufferManagingRebufferer.Unaligned(this);
    }

    @Override
    public String toString() {
        return String.format("%s(%s - chunk length %d, data length %d)", this.getClass().getSimpleName(), this.channel.filePath(), this.bufferSize, this.fileLength());
    }
}

