/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.utils;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;

public interface PrimaryKey
extends Comparable<PrimaryKey>,
ByteComparable {
    default public boolean isTokenOnly() {
        return false;
    }

    public Token token();

    @Nullable
    public DecoratedKey partitionKey();

    @Nullable
    public Clustering<?> clustering();

    default public boolean hasEmptyClustering() {
        return this.clustering() == null || this.clustering().isEmpty();
    }

    @Override
    public ByteSource asComparableBytes(ByteComparable.Version var1);

    public static class Factory {
        private final ClusteringComparator clusteringComparator;

        public Factory(ClusteringComparator clusteringComparator) {
            this.clusteringComparator = clusteringComparator;
        }

        public PrimaryKey createTokenOnly(Token token) {
            assert (token != null) : "Cannot create a primary key with a null token";
            return new TokenOnlyPrimaryKey(token);
        }

        public PrimaryKey createPartitionKeyOnly(DecoratedKey partitionKey) {
            assert (partitionKey != null) : "Cannot create a primary key with a null partition key";
            return new ImmutablePrimaryKey(partitionKey, null);
        }

        public PrimaryKey create(DecoratedKey partitionKey, Clustering<?> clustering) {
            assert (partitionKey != null) : "Cannot create a primary key with a null partition key";
            assert (clustering != null) : "Cannot create a primary key with a null clustering";
            return new ImmutablePrimaryKey(partitionKey, clustering);
        }

        public PrimaryKey createDeferred(Token token, Supplier<PrimaryKey> primaryKeySupplier) {
            assert (token != null) : "Cannot create a deferred primary key with a null token";
            assert (primaryKeySupplier != null) : "Cannot create a deferred primary key with a null key supplier";
            return new MutablePrimaryKey(token, primaryKeySupplier);
        }

        class MutablePrimaryKey
        extends AbstractPrimaryKey {
            private final Token token;
            private final Supplier<PrimaryKey> primaryKeySupplier;
            private boolean notLoaded;
            private DecoratedKey partitionKey;
            private Clustering<?> clustering;

            MutablePrimaryKey(Token token, Supplier<PrimaryKey> primaryKeySupplier) {
                this.notLoaded = true;
                this.token = token;
                this.primaryKeySupplier = primaryKeySupplier;
            }

            @Override
            public Token token() {
                return this.token;
            }

            @Override
            public DecoratedKey partitionKey() {
                this.loadDeferred();
                return this.partitionKey;
            }

            @Override
            public Clustering<?> clustering() {
                this.loadDeferred();
                return this.clustering;
            }

            private void loadDeferred() {
                if (this.notLoaded) {
                    PrimaryKey deferredPrimaryKey = this.primaryKeySupplier.get();
                    this.partitionKey = deferredPrimaryKey.partitionKey();
                    this.clustering = deferredPrimaryKey.clustering();
                    this.notLoaded = false;
                }
            }
        }

        class ImmutablePrimaryKey
        extends AbstractPrimaryKey {
            private final Token token;
            private final DecoratedKey partitionKey;
            private final Clustering<?> clustering;

            ImmutablePrimaryKey(DecoratedKey partitionKey, Clustering<?> clustering) {
                this.token = partitionKey.getToken();
                this.partitionKey = partitionKey;
                this.clustering = clustering;
            }

            @Override
            public Token token() {
                return this.token;
            }

            @Override
            public DecoratedKey partitionKey() {
                return this.partitionKey;
            }

            @Override
            public Clustering<?> clustering() {
                return this.clustering;
            }
        }

        class TokenOnlyPrimaryKey
        extends AbstractPrimaryKey {
            private final Token token;

            TokenOnlyPrimaryKey(Token token) {
                this.token = token;
            }

            @Override
            public boolean isTokenOnly() {
                return true;
            }

            @Override
            public Token token() {
                return this.token;
            }

            @Override
            public DecoratedKey partitionKey() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Clustering<?> clustering() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ByteSource asComparableBytes(ByteComparable.Version version) {
                throw new UnsupportedOperationException();
            }
        }

        abstract class AbstractPrimaryKey
        implements PrimaryKey {
            AbstractPrimaryKey() {
            }

            @Override
            public ByteSource asComparableBytes(ByteComparable.Version version) {
                ByteSource keyComparable = ByteSource.of(this.partitionKey().getKey(), version);
                if (Factory.this.clusteringComparator.size() == 0) {
                    return keyComparable;
                }
                ByteSource clusteringComparable = this.clustering() == null || this.clustering().isEmpty() ? null : Factory.this.clusteringComparator.asByteComparable(this.clustering()).asComparableBytes(version);
                return ByteSource.withTerminator(version == ByteComparable.Version.LEGACY ? -1 : 56, keyComparable, clusteringComparable);
            }

            @Override
            public int compareTo(PrimaryKey o) {
                int cmp = this.token().compareTo(o.token());
                if (cmp != 0 || this.isTokenOnly() || o.isTokenOnly()) {
                    return cmp;
                }
                cmp = this.partitionKey().compareTo(o.partitionKey());
                if (cmp != 0 || this.hasEmptyClustering() || o.hasEmptyClustering()) {
                    return cmp;
                }
                return Factory.this.clusteringComparator.compare(this.clustering(), o.clustering());
            }

            public int hashCode() {
                return Objects.hash(this.token(), this.partitionKey(), this.clustering(), Factory.this.clusteringComparator);
            }

            public boolean equals(Object obj) {
                if (obj instanceof PrimaryKey) {
                    return this.compareTo((PrimaryKey)obj) == 0;
                }
                return false;
            }

            public String toString() {
                return this.isTokenOnly() ? String.format("PrimaryKey: { token: %s }", this.token()) : String.format("PrimaryKey: { token: %s, partition: %s, clustering: %s:%s } ", new Object[]{this.token(), this.partitionKey(), this.clustering() == null ? null : this.clustering().kind(), this.clustering() == null ? null : Arrays.stream(this.clustering().getBufferArray()).map(ByteBufferUtil::bytesToHex).collect(Collectors.joining(", "))});
            }
        }
    }
}

