/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.memory;

import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.memory.ByteSliceReader;
import org.apache.cassandra.index.sai.memory.RAMPostingSlices;
import org.apache.cassandra.index.sai.postings.PostingList;
import org.apache.cassandra.index.sai.utils.TermsIterator;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.Counter;

@NotThreadSafe
public class RAMStringIndexer {
    private final BytesRefHash termsHash;
    private final RAMPostingSlices slices;
    private final Counter bytesUsed;
    private int rowCount = 0;
    private int[] lastRowIdPerTerm = new int[1024];

    public RAMStringIndexer() {
        this.bytesUsed = Counter.newCounter();
        ByteBlockPool termsPool = new ByteBlockPool((ByteBlockPool.Allocator)new ByteBlockPool.DirectTrackingAllocator(this.bytesUsed));
        this.termsHash = new BytesRefHash(termsPool);
        this.slices = new RAMPostingSlices(this.bytesUsed);
    }

    public long estimatedBytesUsed() {
        return this.bytesUsed.get();
    }

    public boolean isEmpty() {
        return this.rowCount == 0;
    }

    public TermsIterator getTermsWithPostings() {
        final int[] sortedTermIDs = this.termsHash.sort();
        final int valueCount = this.termsHash.size();
        final ByteSliceReader sliceReader = new ByteSliceReader();
        return new TermsIterator(){
            private int position = 0;
            private final BytesRef br = new BytesRef();

            @Override
            public ByteBuffer getMinTerm() {
                BytesRef term = new BytesRef();
                int minTermID = sortedTermIDs[0];
                RAMStringIndexer.this.termsHash.get(minTermID, term);
                return ByteBuffer.wrap(term.bytes, term.offset, term.length);
            }

            @Override
            public ByteBuffer getMaxTerm() {
                BytesRef term = new BytesRef();
                int maxTermID = sortedTermIDs[valueCount - 1];
                RAMStringIndexer.this.termsHash.get(maxTermID, term);
                return ByteBuffer.wrap(term.bytes, term.offset, term.length);
            }

            @Override
            public void close() {
            }

            @Override
            public PostingList postings() {
                int termID = sortedTermIDs[this.position - 1];
                return RAMStringIndexer.this.slices.postingList(termID, sliceReader);
            }

            @Override
            public boolean hasNext() {
                return this.position < valueCount;
            }

            @Override
            public ByteComparable next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                RAMStringIndexer.this.termsHash.get(sortedTermIDs[this.position], this.br);
                ++this.position;
                return this.asByteComparable(this.br.bytes, this.br.offset, this.br.length);
            }

            private ByteComparable asByteComparable(byte[] bytes, int offset, int length) {
                return v -> ByteSource.fixedLength(bytes, offset, length);
            }
        };
    }

    public long add(BytesRef term, int segmentRowId) {
        long startBytes = this.estimatedBytesUsed();
        int termID = this.termsHash.add(term);
        if (termID >= 0) {
            this.slices.createNewSlice(termID);
        } else {
            termID = -termID - 1;
        }
        if (termID >= this.lastRowIdPerTerm.length - 1) {
            this.lastRowIdPerTerm = ArrayUtil.grow((int[])this.lastRowIdPerTerm, (int)(termID + 1));
        }
        int delta = segmentRowId - this.lastRowIdPerTerm[termID];
        this.lastRowIdPerTerm[termID] = segmentRowId;
        this.slices.writeVInt(termID, delta);
        long allocatedBytes = this.estimatedBytesUsed() - startBytes;
        ++this.rowCount;
        return allocatedBytes;
    }
}

