/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.iterators;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.utils.AbstractGuavaIterator;

public abstract class KeyRangeIterator
extends AbstractGuavaIterator<PrimaryKey>
implements Closeable {
    private final PrimaryKey min;
    private final PrimaryKey max;
    private final long count;
    private PrimaryKey current;

    protected KeyRangeIterator(Builder.Statistics statistics) {
        this(statistics.min, statistics.max, statistics.count);
    }

    public KeyRangeIterator(PrimaryKey min, PrimaryKey max, long count) {
        boolean isComplete = min != null && max != null && count != 0L;
        boolean isEmpty = min == null && max == null && (count == 0L || count == -1L);
        Preconditions.checkArgument((isComplete || isEmpty ? 1 : 0) != 0, (Object)("Range: [" + min + "," + max + "], Count: " + count));
        this.min = min;
        this.current = min;
        this.max = max;
        this.count = count;
    }

    public final PrimaryKey getMinimum() {
        return this.min;
    }

    public final PrimaryKey getCurrent() {
        return this.current;
    }

    public final PrimaryKey getMaximum() {
        return this.max;
    }

    public final long getCount() {
        return this.count;
    }

    public final PrimaryKey skipTo(PrimaryKey nextKey) {
        if (this.min == null || this.max == null) {
            return (PrimaryKey)this.endOfData();
        }
        if (this.current.compareTo(nextKey) >= 0) {
            Object object = this.next = this.next == null ? this.recomputeNext() : (PrimaryKey)this.next;
            if (this.next == null) {
                return (PrimaryKey)this.endOfData();
            }
            if (((PrimaryKey)this.next).compareTo(nextKey) >= 0) {
                return (PrimaryKey)this.next;
            }
        }
        if (this.max.compareTo(nextKey) < 0) {
            return (PrimaryKey)this.endOfData();
        }
        this.performSkipTo(nextKey);
        return this.recomputeNext();
    }

    protected abstract void performSkipTo(PrimaryKey var1);

    private PrimaryKey recomputeNext() {
        return this.tryToComputeNext() ? (PrimaryKey)this.peek() : (PrimaryKey)this.endOfData();
    }

    @Override
    protected final boolean tryToComputeNext() {
        boolean hasNext = super.tryToComputeNext();
        this.current = hasNext ? (PrimaryKey)this.next : this.getMaximum();
        return hasNext;
    }

    public static KeyRangeIterator empty() {
        return EmptyRangeIterator.instance;
    }

    protected static <T extends Comparable<T>> T nullSafeMin(T a, T b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.compareTo(b) > 0 ? b : a;
    }

    protected static <T extends Comparable<T>> T nullSafeMax(T a, T b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.compareTo(b) > 0 ? a : b;
    }

    @VisibleForTesting
    public static abstract class Builder {
        protected final Statistics statistics;

        public Builder(Statistics statistics) {
            this.statistics = statistics;
        }

        public PrimaryKey getMinimum() {
            return this.statistics.min;
        }

        public PrimaryKey getMaximum() {
            return this.statistics.max;
        }

        public long getCount() {
            return this.statistics.count;
        }

        public Builder add(Iterable<KeyRangeIterator> ranges) {
            if (ranges == null || Iterables.isEmpty(ranges)) {
                return this;
            }
            ranges.forEach(this::add);
            return this;
        }

        public final KeyRangeIterator build() {
            if (this.rangeCount() == 0) {
                return KeyRangeIterator.empty();
            }
            return this.buildIterator();
        }

        public abstract Builder add(KeyRangeIterator var1);

        public abstract int rangeCount();

        public abstract void cleanup();

        protected abstract KeyRangeIterator buildIterator();

        public static abstract class Statistics {
            protected PrimaryKey min;
            protected PrimaryKey max;
            protected long count;

            public abstract void update(KeyRangeIterator var1);
        }
    }

    private static class EmptyRangeIterator
    extends KeyRangeIterator {
        static final KeyRangeIterator instance = new EmptyRangeIterator();

        EmptyRangeIterator() {
            super(null, null, 0L);
        }

        @Override
        public PrimaryKey computeNext() {
            return (PrimaryKey)this.endOfData();
        }

        @Override
        protected void performSkipTo(PrimaryKey nextKey) {
        }

        @Override
        public void close() {
        }
    }
}

