/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.format;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.index.sai.IndexContext;
import org.apache.cassandra.index.sai.IndexValidation;
import org.apache.cassandra.index.sai.SSTableContext;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.disk.PerColumnIndexWriter;
import org.apache.cassandra.index.sai.disk.PerSSTableIndexWriter;
import org.apache.cassandra.index.sai.disk.PrimaryKeyMap;
import org.apache.cassandra.index.sai.disk.RowMapping;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.Version;
import org.apache.cassandra.index.sai.disk.io.IndexFileUtils;
import org.apache.cassandra.index.sai.disk.io.IndexOutputWriter;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Throwables;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(IndexDescriptor.class);
    public final Version version;
    public final Descriptor sstableDescriptor;
    public final ClusteringComparator clusteringComparator;
    public final PrimaryKey.Factory primaryKeyFactory;

    private IndexDescriptor(Version version, Descriptor sstableDescriptor, ClusteringComparator clusteringComparator) {
        this.version = version;
        this.sstableDescriptor = sstableDescriptor;
        this.clusteringComparator = clusteringComparator;
        this.primaryKeyFactory = new PrimaryKey.Factory(clusteringComparator);
    }

    public static IndexDescriptor create(Descriptor descriptor, ClusteringComparator clusteringComparator) {
        return new IndexDescriptor(Version.LATEST, descriptor, clusteringComparator);
    }

    public static IndexDescriptor create(SSTableReader sstable) {
        for (Version version : Version.ALL) {
            IndexDescriptor indexDescriptor = new IndexDescriptor(version, sstable.descriptor, sstable.metadata().comparator);
            if (!version.onDiskFormat().isPerSSTableIndexBuildComplete(indexDescriptor)) continue;
            return indexDescriptor;
        }
        return new IndexDescriptor(Version.LATEST, sstable.descriptor, sstable.metadata().comparator);
    }

    public boolean hasClustering() {
        return this.clusteringComparator.size() > 0;
    }

    public String componentName(IndexComponent indexComponent) {
        return this.version.fileNameFormatter().format(indexComponent, null);
    }

    public PrimaryKeyMap.Factory newPrimaryKeyMapFactory(SSTableReader sstable) {
        return this.version.onDiskFormat().newPrimaryKeyMapFactory(this, sstable);
    }

    public SSTableIndex newSSTableIndex(SSTableContext sstableContext, IndexContext indexContext) {
        return this.version.onDiskFormat().newSSTableIndex(sstableContext, indexContext);
    }

    public PerSSTableIndexWriter newPerSSTableIndexWriter() throws IOException {
        return this.version.onDiskFormat().newPerSSTableIndexWriter(this);
    }

    public PerColumnIndexWriter newPerColumnIndexWriter(StorageAttachedIndex index, LifecycleNewTracker tracker, RowMapping rowMapping) {
        return this.version.onDiskFormat().newPerColumnIndexWriter(index, this, tracker, rowMapping);
    }

    public boolean isPerSSTableIndexBuildComplete() {
        return this.version.onDiskFormat().isPerSSTableIndexBuildComplete(this);
    }

    public boolean isPerColumnIndexBuildComplete(IndexContext indexContext) {
        return this.version.onDiskFormat().isPerColumnIndexBuildComplete(this, indexContext);
    }

    public boolean hasComponent(IndexComponent indexComponent) {
        return this.fileFor(indexComponent).exists();
    }

    public boolean hasComponent(IndexComponent indexComponent, IndexContext indexContext) {
        return this.fileFor(indexComponent, indexContext).exists();
    }

    public org.apache.cassandra.io.util.File fileFor(IndexComponent indexComponent) {
        return this.createFile(indexComponent, null);
    }

    public org.apache.cassandra.io.util.File fileFor(IndexComponent indexComponent, IndexContext indexContext) {
        return this.createFile(indexComponent, indexContext);
    }

    public boolean isIndexEmpty(IndexContext indexContext) {
        return this.isPerColumnIndexBuildComplete(indexContext) && this.numberOfPerIndexComponents(indexContext) == 1L;
    }

    public void createComponentOnDisk(IndexComponent component) throws IOException {
        Files.touch((File)this.fileFor(component).toJavaIOFile());
    }

    public void createComponentOnDisk(IndexComponent component, IndexContext indexContext) throws IOException {
        Files.touch((File)this.fileFor(component, indexContext).toJavaIOFile());
    }

    public IndexInput openPerSSTableInput(IndexComponent indexComponent) {
        org.apache.cassandra.io.util.File file = this.fileFor(indexComponent);
        if (logger.isTraceEnabled()) {
            logger.trace(this.logMessage("Opening blocking index input for file {} ({})"), (Object)file, (Object)FBUtilities.prettyPrintMemory(file.length()));
        }
        return IndexFileUtils.instance.openBlockingInput(file);
    }

    public IndexInput openPerIndexInput(IndexComponent indexComponent, IndexContext indexContext) {
        org.apache.cassandra.io.util.File file = this.fileFor(indexComponent, indexContext);
        if (logger.isTraceEnabled()) {
            logger.trace(this.logMessage("Opening blocking index input for file {} ({})"), (Object)file, (Object)FBUtilities.prettyPrintMemory(file.length()));
        }
        return IndexFileUtils.instance.openBlockingInput(file);
    }

    public IndexOutputWriter openPerSSTableOutput(IndexComponent component) throws IOException {
        return this.openPerSSTableOutput(component, false);
    }

    public IndexOutputWriter openPerSSTableOutput(IndexComponent component, boolean append) throws IOException {
        org.apache.cassandra.io.util.File file = this.fileFor(component);
        if (logger.isTraceEnabled()) {
            logger.trace(this.logMessage("Creating SSTable attached index output for component {} on file {}..."), (Object)component, (Object)file);
        }
        IndexOutputWriter writer = IndexFileUtils.instance.openOutput(file);
        if (append) {
            writer.skipBytes(file.length());
        }
        return writer;
    }

    public IndexOutputWriter openPerIndexOutput(IndexComponent indexComponent, IndexContext indexContext) throws IOException {
        return this.openPerIndexOutput(indexComponent, indexContext, false);
    }

    public IndexOutputWriter openPerIndexOutput(IndexComponent component, IndexContext indexContext, boolean append) throws IOException {
        org.apache.cassandra.io.util.File file = this.fileFor(component, indexContext);
        if (logger.isTraceEnabled()) {
            logger.trace(indexContext.logMessage("Creating sstable attached index output for component {} on file {}..."), (Object)component, (Object)file);
        }
        IndexOutputWriter writer = IndexFileUtils.instance.openOutput(file);
        if (append) {
            writer.skipBytes(file.length());
        }
        return writer;
    }

    public FileHandle createPerSSTableFileHandle(IndexComponent indexComponent, Throwables.DiscreteAction<?> cleanup) {
        try {
            org.apache.cassandra.io.util.File file = this.fileFor(indexComponent);
            if (logger.isTraceEnabled()) {
                logger.trace(this.logMessage("Opening {} file handle for {} ({})"), (Object)file, (Object)FBUtilities.prettyPrintMemory(file.length()));
            }
            return new FileHandle.Builder(file).mmapped(true).complete();
        }
        catch (Throwable t) {
            throw this.handleFileHandleCleanup(t, cleanup);
        }
    }

    public FileHandle createPerIndexFileHandle(IndexComponent indexComponent, IndexContext indexContext, Throwables.DiscreteAction<?> cleanup) {
        try {
            org.apache.cassandra.io.util.File file = this.fileFor(indexComponent, indexContext);
            if (logger.isTraceEnabled()) {
                logger.trace(indexContext.logMessage("Opening file handle for {} ({})"), (Object)file, (Object)FBUtilities.prettyPrintMemory(file.length()));
            }
            return new FileHandle.Builder(file).mmapped(true).complete();
        }
        catch (Throwable t) {
            throw this.handleFileHandleCleanup(t, cleanup);
        }
    }

    private RuntimeException handleFileHandleCleanup(Throwable t, Throwables.DiscreteAction<?> cleanup) {
        if (cleanup != null) {
            try {
                cleanup.perform();
            }
            catch (Exception e) {
                return Throwables.unchecked(Throwables.merge(t, e));
            }
        }
        return Throwables.unchecked(t);
    }

    public Set<Component> getLivePerSSTableComponents() {
        return this.version.onDiskFormat().perSSTableIndexComponents(this.hasClustering()).stream().filter(c -> this.fileFor((IndexComponent)((Object)c)).exists()).map(this.version::makePerSSTableComponent).collect(Collectors.toSet());
    }

    public Set<Component> getLivePerIndexComponents(IndexContext indexContext) {
        return this.version.onDiskFormat().perColumnIndexComponents(indexContext).stream().filter(c -> this.fileFor((IndexComponent)((Object)c), indexContext).exists()).map(c -> this.version.makePerIndexComponent((IndexComponent)((Object)c), indexContext)).collect(Collectors.toSet());
    }

    public long sizeOnDiskOfPerSSTableComponents() {
        return this.version.onDiskFormat().perSSTableIndexComponents(this.hasClustering()).stream().map(this::fileFor).filter(org.apache.cassandra.io.util.File::exists).mapToLong(org.apache.cassandra.io.util.File::length).sum();
    }

    public long sizeOnDiskOfPerIndexComponents(IndexContext indexContext) {
        return this.version.onDiskFormat().perColumnIndexComponents(indexContext).stream().map(c -> this.fileFor((IndexComponent)((Object)c), indexContext)).filter(org.apache.cassandra.io.util.File::exists).mapToLong(org.apache.cassandra.io.util.File::length).sum();
    }

    @VisibleForTesting
    public long sizeOnDiskOfPerIndexComponent(IndexComponent indexComponent, IndexContext indexContext) {
        org.apache.cassandra.io.util.File componentFile = this.fileFor(indexComponent, indexContext);
        return componentFile.exists() ? componentFile.length() : 0L;
    }

    public boolean validatePerIndexComponents(IndexContext indexContext, IndexValidation validation) {
        if (validation == IndexValidation.NONE) {
            return true;
        }
        logger.info(indexContext.logMessage("Validating per-column index components using mode " + validation));
        boolean checksum = validation == IndexValidation.CHECKSUM;
        try {
            this.version.onDiskFormat().validatePerColumnIndexComponents(this, indexContext, checksum);
            return true;
        }
        catch (UncheckedIOException e) {
            return false;
        }
    }

    public boolean validatePerSSTableComponents(IndexValidation validation) {
        if (validation == IndexValidation.NONE) {
            return true;
        }
        logger.info(this.logMessage("Validating per-sstable index components using mode " + validation));
        boolean checksum = validation == IndexValidation.CHECKSUM;
        try {
            this.version.onDiskFormat().validatePerSSTableIndexComponents(this, checksum);
            return true;
        }
        catch (UncheckedIOException e) {
            return false;
        }
    }

    public void checksumPerIndexComponents(IndexContext indexContext) {
        this.version.onDiskFormat().validatePerColumnIndexComponents(this, indexContext, true);
    }

    public void checksumPerSSTableComponents() {
        this.version.onDiskFormat().validatePerSSTableIndexComponents(this, true);
    }

    public void deletePerSSTableIndexComponents() {
        this.version.onDiskFormat().perSSTableIndexComponents(this.hasClustering()).stream().map(this::fileFor).filter(org.apache.cassandra.io.util.File::exists).forEach(this::deleteComponent);
    }

    public void deleteColumnIndex(IndexContext indexContext) {
        this.version.onDiskFormat().perColumnIndexComponents(indexContext).stream().map(c -> this.fileFor((IndexComponent)((Object)c), indexContext)).filter(org.apache.cassandra.io.util.File::exists).forEach(this::deleteComponent);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sstableDescriptor, this.version});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexDescriptor other = (IndexDescriptor)o;
        return Objects.equal((Object)this.sstableDescriptor, (Object)other.sstableDescriptor) && Objects.equal((Object)this.version, (Object)other.version);
    }

    public String toString() {
        return this.sstableDescriptor.toString() + "-SAI";
    }

    public String logMessage(String message) {
        return String.format("[%s.%s.*] %s", this.sstableDescriptor.ksname, this.sstableDescriptor.cfname, message);
    }

    private org.apache.cassandra.io.util.File createFile(IndexComponent component, IndexContext indexContext) {
        Component customComponent = this.version.makePerIndexComponent(component, indexContext);
        return this.sstableDescriptor.fileFor(customComponent);
    }

    private long numberOfPerIndexComponents(IndexContext indexContext) {
        return this.version.onDiskFormat().perColumnIndexComponents(indexContext).stream().map(c -> this.fileFor((IndexComponent)((Object)c), indexContext)).filter(org.apache.cassandra.io.util.File::exists).count();
    }

    private void deleteComponent(org.apache.cassandra.io.util.File file) {
        logger.debug(this.logMessage("Deleting storage-attached index component file {}"), (Object)file);
        try {
            IOUtils.deleteFilesIfExist((Path[])new Path[]{file.toPath()});
        }
        catch (IOException e) {
            logger.warn(this.logMessage("Unable to delete storage-attached index component file {} due to {}."), new Object[]{file, e.getMessage(), e});
        }
    }
}

