/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.writers;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.DiskBoundaries;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableRewriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompactionAwareWriter
extends Transactional.AbstractTransactional
implements Transactional {
    protected static final Logger logger = LoggerFactory.getLogger(CompactionAwareWriter.class);
    protected final ColumnFamilyStore cfs;
    protected final Directories directories;
    protected final Set<SSTableReader> nonExpiredSSTables;
    protected final long estimatedTotalKeys;
    protected final long maxAge;
    protected final long minRepairedAt;
    protected final TimeUUID pendingRepair;
    protected final boolean isTransient;
    protected final SSTableRewriter sstableWriter;
    protected final LifecycleTransaction txn;
    private final List<Directories.DataDirectory> locations;
    private final List<PartitionPosition> diskBoundaries;
    private int locationIndex;
    protected Directories.DataDirectory currentDirectory;

    public CompactionAwareWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, boolean keepOriginals) {
        this.cfs = cfs;
        this.directories = directories;
        this.nonExpiredSSTables = nonExpiredSSTables;
        this.txn = txn;
        this.estimatedTotalKeys = SSTableReader.getApproximateKeyCount(nonExpiredSSTables);
        this.maxAge = CompactionTask.getMaxDataAge(nonExpiredSSTables);
        this.sstableWriter = SSTableRewriter.construct(cfs, txn, keepOriginals, this.maxAge);
        this.minRepairedAt = CompactionTask.getMinRepairedAt(nonExpiredSSTables);
        this.pendingRepair = CompactionTask.getPendingRepair(nonExpiredSSTables);
        this.isTransient = CompactionTask.getIsTransient(nonExpiredSSTables);
        DiskBoundaries db = cfs.getDiskBoundaries();
        this.diskBoundaries = db.positions;
        this.locations = db.directories;
        this.locationIndex = -1;
    }

    @Override
    protected Throwable doAbort(Throwable accumulate) {
        return this.sstableWriter.abort(accumulate);
    }

    @Override
    protected Throwable doCommit(Throwable accumulate) {
        return this.sstableWriter.commit(accumulate);
    }

    @Override
    protected void doPrepare() {
        this.sstableWriter.prepareToCommit();
    }

    @Override
    public Collection<SSTableReader> finish() {
        super.finish();
        return this.sstableWriter.finished();
    }

    public long estimatedKeys() {
        return this.estimatedTotalKeys;
    }

    public final boolean append(UnfilteredRowIterator partition) {
        this.maybeSwitchWriter(partition.partitionKey());
        return this.realAppend(partition);
    }

    public final File getSStableDirectory() throws IOException {
        return this.getDirectories().getLocationForDisk(this.currentDirectory);
    }

    @Override
    protected Throwable doPostCleanup(Throwable accumulate) {
        this.sstableWriter.close();
        return super.doPostCleanup(accumulate);
    }

    protected boolean realAppend(UnfilteredRowIterator partition) {
        return this.sstableWriter.append(partition) != null;
    }

    protected void maybeSwitchWriter(DecoratedKey key) {
        if (this.maybeSwitchLocation(key)) {
            return;
        }
        if (this.shouldSwitchWriterInCurrentLocation(key)) {
            this.switchCompactionWriter(this.currentDirectory, key);
        }
    }

    protected boolean maybeSwitchLocation(DecoratedKey key) {
        if (this.diskBoundaries == null) {
            if (this.locationIndex < 0) {
                Directories.DataDirectory defaultLocation = this.getWriteDirectory(this.nonExpiredSSTables, this.getExpectedWriteSize());
                this.switchCompactionWriter(defaultLocation, key);
                this.locationIndex = 0;
                return true;
            }
            return false;
        }
        if (this.locationIndex > -1 && key.compareTo(this.diskBoundaries.get(this.locationIndex)) < 0) {
            return false;
        }
        int prevIdx = this.locationIndex;
        while (this.locationIndex == -1 || key.compareTo(this.diskBoundaries.get(this.locationIndex)) > 0) {
            ++this.locationIndex;
        }
        Directories.DataDirectory newLocation = this.locations.get(this.locationIndex);
        if (prevIdx >= 0) {
            logger.debug("Switching write location from {} to {}", (Object)this.locations.get(prevIdx), (Object)newLocation);
        }
        this.switchCompactionWriter(newLocation, key);
        return true;
    }

    protected abstract boolean shouldSwitchWriterInCurrentLocation(DecoratedKey var1);

    protected void switchCompactionWriter(Directories.DataDirectory directory, DecoratedKey nextKey) {
        this.currentDirectory = directory;
        this.sstableWriter.switchWriter(this.sstableWriter(directory, nextKey));
    }

    protected SSTableWriter sstableWriter(Directories.DataDirectory directory, DecoratedKey nextKey) {
        Descriptor descriptor = this.cfs.newSSTableDescriptor(this.getDirectories().getLocationForDisk(directory));
        MetadataCollector collector = new MetadataCollector(this.txn.originals(), this.cfs.metadata().comparator).sstableLevel(this.sstableLevel());
        SerializationHeader header = SerializationHeader.make(this.cfs.metadata(), this.nonExpiredSSTables);
        return ((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)this.newWriterBuilder(descriptor).setMetadataCollector(collector)).setSerializationHeader(header)).setKeyCount(this.sstableKeyCount())).build(this.txn, this.cfs);
    }

    protected int sstableLevel() {
        return 0;
    }

    protected abstract long sstableKeyCount();

    public Directories getDirectories() {
        return this.directories;
    }

    public Directories.DataDirectory getWriteDirectory(Iterable<SSTableReader> sstables, long estimatedWriteSize) {
        Directories.DataDirectory d;
        Descriptor descriptor = null;
        for (SSTableReader sstable : sstables) {
            if (descriptor == null) {
                descriptor = sstable.descriptor;
            }
            if (descriptor.directory.equals(sstable.descriptor.directory)) continue;
            logger.trace("All sstables not from the same disk - putting results in {}", (Object)descriptor.directory);
            break;
        }
        if ((d = this.getDirectories().getDataDirectoryForFile(descriptor)) != null) {
            long availableSpace = d.getAvailableSpace();
            if (availableSpace < estimatedWriteSize) {
                throw new RuntimeException(String.format("Not enough space to write %s to %s (%s available)", FBUtilities.prettyPrintMemory(estimatedWriteSize), d.location, FBUtilities.prettyPrintMemory(availableSpace)));
            }
            logger.trace("putting compaction results in {}", (Object)descriptor.directory);
            return d;
        }
        d = this.getDirectories().getWriteableLocation(estimatedWriteSize);
        if (d == null) {
            throw new RuntimeException(String.format("Not enough disk space to store %s", FBUtilities.prettyPrintMemory(estimatedWriteSize)));
        }
        return d;
    }

    public CompactionAwareWriter setRepairedAt(long repairedAt) {
        this.sstableWriter.setRepairedAt(repairedAt);
        return this;
    }

    protected long getExpectedWriteSize() {
        return this.cfs.getExpectedCompactedFileSize(this.nonExpiredSSTables, this.txn.opType());
    }

    protected SSTableWriter.Builder<?, ?> newWriterBuilder(Descriptor descriptor) {
        return ((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTableWriter.Builder)((SSTable.Builder)descriptor.getFormat().getWriterFactory().builder(descriptor)).setTableMetadataRef(this.cfs.metadata)).setTransientSSTable(this.isTransient)).setRepairedAt(this.minRepairedAt)).setPendingRepair(this.pendingRepair)).addFlushObserversForSecondaryIndexes(this.cfs.indexManager.listIndexGroups(), this.txn, this.cfs.metadata.get())).addDefaultComponents(this.cfs.indexManager.listIndexGroups());
    }
}

