/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import com.google.common.util.concurrent.FutureCallback;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.apache.cassandra.utils.concurrent.AbstractFuture;
import org.apache.cassandra.utils.concurrent.AsyncFuture;
import org.apache.cassandra.utils.concurrent.Promise;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;

public class AsyncPromise<V>
extends AsyncFuture<V>
implements Promise<V> {
    public AsyncPromise() {
    }

    AsyncPromise(AbstractFuture.FailureHolder initialState) {
        super(initialState);
    }

    public AsyncPromise(GenericFutureListener<? extends Future<? super V>> listener) {
        super(listener);
    }

    AsyncPromise(AbstractFuture.FailureHolder initialState, GenericFutureListener<? extends Future<? super V>> listener) {
        super(initialState, listener);
    }

    public static <V> AsyncPromise<V> withExecutor(Executor executor) {
        return new WithExecutor(executor);
    }

    public static <V> AsyncPromise<V> uncancellable() {
        return new AsyncPromise<V>(UNCANCELLABLE);
    }

    public static <V> AsyncPromise<V> uncancellable(Executor executor) {
        return new WithExecutor(executor, UNCANCELLABLE);
    }

    public static <V> AsyncPromise<V> uncancellable(GenericFutureListener<? extends Future<? super V>> listener) {
        return new AsyncPromise<V>(UNCANCELLABLE, listener);
    }

    @Override
    public Promise<V> setSuccess(V v) {
        if (!this.trySuccess(v)) {
            throw new IllegalStateException("complete already: " + this);
        }
        return this;
    }

    @Override
    public boolean trySuccess(V v) {
        return super.trySuccess(v);
    }

    @Override
    public Promise<V> setFailure(Throwable throwable) {
        if (!this.tryFailure(throwable)) {
            throw new IllegalStateException("complete already: " + this);
        }
        return this;
    }

    @Override
    public boolean tryFailure(Throwable throwable) {
        return super.tryFailure(throwable);
    }

    @Override
    public boolean setUncancellable() {
        return super.setUncancellable();
    }

    @Override
    public boolean setUncancellableExclusive() {
        return super.setUncancellableExclusive();
    }

    @Override
    public boolean isUncancellable() {
        return super.isUncancellable();
    }

    @Override
    public Promise<V> sync() throws InterruptedException {
        super.sync();
        return this;
    }

    @Override
    public Promise<V> syncUninterruptibly() {
        super.syncUninterruptibly();
        return this;
    }

    @Override
    public AsyncPromise<V> addListener(GenericFutureListener<? extends Future<? super V>> listener) {
        super.addListener((GenericFutureListener)listener);
        return this;
    }

    @Override
    public AsyncPromise<V> addListeners(GenericFutureListener<? extends Future<? super V>> ... listeners) {
        super.addListeners((GenericFutureListener[])listeners);
        return this;
    }

    @Override
    public AsyncPromise<V> removeListener(GenericFutureListener<? extends Future<? super V>> listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AsyncPromise<V> removeListeners(GenericFutureListener<? extends Future<? super V>> ... listeners) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AsyncPromise<V> addCallback(FutureCallback<? super V> callback) {
        super.addCallback((FutureCallback)callback);
        return this;
    }

    @Override
    public AsyncPromise<V> addCallback(FutureCallback<? super V> callback, Executor executor) {
        super.addCallback((FutureCallback)callback, executor);
        return this;
    }

    @Override
    public AsyncPromise<V> addCallback(Consumer<? super V> onSuccess, Consumer<? super Throwable> onFailure) {
        super.addCallback((Consumer)onSuccess, (Consumer)onFailure);
        return this;
    }

    @Override
    public AsyncPromise<V> await() throws InterruptedException {
        super.await();
        return this;
    }

    @Override
    public AsyncPromise<V> awaitUninterruptibly() {
        super.awaitUninterruptibly();
        return this;
    }

    @Override
    public AsyncPromise<V> awaitThrowUncheckedOnInterrupt() throws UncheckedInterruptedException {
        super.awaitThrowUncheckedOnInterrupt();
        return this;
    }

    public static class WithExecutor<V>
    extends AsyncPromise<V> {
        final Executor notifyExecutor;

        protected WithExecutor(Executor notifyExecutor) {
            this.notifyExecutor = notifyExecutor;
        }

        protected WithExecutor(Executor notifyExecutor, AbstractFuture.FailureHolder initialState) {
            super(initialState);
            this.notifyExecutor = notifyExecutor;
        }

        protected WithExecutor(Executor notifyExecutor, GenericFutureListener<? extends Future<? super V>> listener) {
            super(listener);
            this.notifyExecutor = notifyExecutor;
        }

        @Override
        public Executor notifyExecutor() {
            return this.notifyExecutor;
        }
    }
}

