/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.cassandra.net.BufferPoolAllocator;
import org.apache.cassandra.net.FrameDecoder;
import org.apache.cassandra.net.ShareableBytes;

abstract class FrameDecoderWith8bHeader
extends FrameDecoder {
    FrameDecoderWith8bHeader(BufferPoolAllocator allocator) {
        super(allocator);
    }

    abstract long readHeader(ByteBuffer var1, int var2);

    abstract FrameDecoder.CorruptFrame verifyHeader(long var1);

    abstract int frameLength(long var1);

    abstract FrameDecoder.Frame unpackFrame(ShareableBytes var1, int var2, int var3, long var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(Collection<FrameDecoder.Frame> into, ShareableBytes newBytes, int headerLength) {
        ByteBuffer in = newBytes.get();
        try {
            int frameLength;
            if (this.stash != null) {
                if (!FrameDecoderWith8bHeader.copyToSize(in, this.stash, headerLength)) {
                    return;
                }
                long header = this.readHeader(this.stash, 0);
                FrameDecoder.CorruptFrame c = this.verifyHeader(header);
                if (c != null) {
                    this.discard();
                    into.add(c);
                    return;
                }
                int frameLength2 = this.frameLength(header);
                this.stash = this.ensureCapacity(this.stash, frameLength2);
                if (!FrameDecoderWith8bHeader.copyToSize(in, this.stash, frameLength2)) {
                    return;
                }
                this.stash.flip();
                ShareableBytes stashed = ShareableBytes.wrap(this.stash);
                this.stash = null;
                try {
                    into.add(this.unpackFrame(stashed, 0, frameLength2, header));
                }
                finally {
                    stashed.release();
                }
            }
            int limit = in.limit();
            for (int begin = in.position(); begin < limit; begin += frameLength) {
                int remaining = limit - begin;
                if (remaining < headerLength) {
                    this.stash(newBytes, headerLength, begin, remaining);
                    return;
                }
                long header = this.readHeader(in, begin);
                FrameDecoder.CorruptFrame c = this.verifyHeader(header);
                if (c != null) {
                    into.add(c);
                    return;
                }
                frameLength = this.frameLength(header);
                if (remaining < frameLength) {
                    this.stash(newBytes, frameLength, begin, remaining);
                    return;
                }
                into.add(this.unpackFrame(newBytes, begin, begin + frameLength, header));
            }
        }
        finally {
            newBytes.release();
        }
    }
}

