/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.obs.OffHeapBitSet;

public final class BloomFilterSerializer {
    private BloomFilterSerializer() {
    }

    public static void serialize(BloomFilter bf, DataOutputPlus out) throws IOException {
        out.writeInt(bf.hashCount);
        bf.bitset.serialize(out);
    }

    public static <I extends InputStream> BloomFilter deserialize(I in, boolean oldBfFormat) throws IOException {
        int hashes = ((DataInput)((Object)in)).readInt();
        OffHeapBitSet bs = OffHeapBitSet.deserialize(in, oldBfFormat);
        return new BloomFilter(hashes, bs);
    }

    public static long serializedSize(BloomFilter bf) {
        int size = TypeSizes.sizeof(bf.hashCount);
        size = (int)((long)size + bf.bitset.serializedSize());
        return size;
    }
}

