/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.IOException;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;

public abstract class AbstractClusteringIndexFilter
implements ClusteringIndexFilter {
    static final ClusteringIndexFilter.Serializer serializer = new FilterSerializer();
    protected final boolean reversed;

    protected AbstractClusteringIndexFilter(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public boolean isEmpty(ClusteringComparator comparator) {
        return false;
    }

    protected abstract void serializeInternal(DataOutputPlus var1, int var2) throws IOException;

    protected abstract long serializedSizeInternal(int var1);

    protected void appendOrderByToCQLString(TableMetadata metadata, StringBuilder sb) {
        if (this.reversed) {
            sb.append(" ORDER BY ");
            int i = 0;
            for (ColumnMetadata column : metadata.clusteringColumns()) {
                sb.append(i++ == 0 ? "" : ", ").append(column.name.toCQLString()).append(column.type instanceof ReversedType ? " ASC" : " DESC");
            }
        }
    }

    private static class FilterSerializer
    implements ClusteringIndexFilter.Serializer {
        private FilterSerializer() {
        }

        @Override
        public void serialize(ClusteringIndexFilter pfilter, DataOutputPlus out, int version) throws IOException {
            AbstractClusteringIndexFilter filter = (AbstractClusteringIndexFilter)pfilter;
            out.writeByte(filter.kind().ordinal());
            out.writeBoolean(filter.isReversed());
            filter.serializeInternal(out, version);
        }

        @Override
        public ClusteringIndexFilter deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            ClusteringIndexFilter.Kind kind = ClusteringIndexFilter.Kind.values()[in.readUnsignedByte()];
            boolean reversed = in.readBoolean();
            return kind.deserializer.deserialize(in, version, metadata, reversed);
        }

        @Override
        public long serializedSize(ClusteringIndexFilter pfilter, int version) {
            AbstractClusteringIndexFilter filter = (AbstractClusteringIndexFilter)pfilter;
            return (long)(1 + TypeSizes.sizeof(filter.isReversed())) + filter.serializedSizeInternal(version);
        }
    }
}

