/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;

public class KeyCacheKey
extends CacheKey {
    public final Descriptor desc;
    private static final long EMPTY_SIZE = ObjectSizes.measure(new KeyCacheKey(TableMetadata.builder("ks", "tab").addPartitionKeyColumn("pk", (AbstractType)UTF8Type.instance).build(), null, ByteBufferUtil.EMPTY_BYTE_BUFFER));
    public final byte[] key;

    public KeyCacheKey(TableMetadata tableMetadata, Descriptor desc, ByteBuffer key) {
        super(tableMetadata);
        this.desc = desc;
        this.key = ByteBufferUtil.getArray(key);
        assert (this.key != null);
    }

    public String toString() {
        return String.format("KeyCacheKey(%s, %s)", this.desc, ByteBufferUtil.bytesToHex(ByteBuffer.wrap(this.key)));
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOfArray(this.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyCacheKey that = (KeyCacheKey)o;
        return this.tableId.equals(that.tableId) && Objects.equals(this.indexName, that.indexName) && this.desc.equals(that.desc) && Arrays.equals(this.key, that.key);
    }

    public int hashCode() {
        int result = this.tableId.hashCode();
        result = 31 * result + Objects.hashCode(this.indexName);
        result = 31 * result + this.desc.hashCode();
        result = 31 * result + Arrays.hashCode(this.key);
        return result;
    }
}

