/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.util.List;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.BytesSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;

public class TupleSerializer
extends BytesSerializer {
    public final List<TypeSerializer<?>> fields;

    public TupleSerializer(List<TypeSerializer<?>> fields) {
        this.fields = fields;
    }

    @Override
    public <V> void validate(V input, ValueAccessor<V> accessor) throws MarshalException {
        int offset = 0;
        for (int i = 0; i < this.fields.size(); ++i) {
            if (accessor.isEmptyFromOffset(input, offset)) {
                return;
            }
            if (accessor.sizeFromOffset(input, offset) < 4) {
                throw new MarshalException(String.format("Not enough bytes to read size of %dth component", i));
            }
            int size = accessor.getInt(input, offset);
            offset += 4;
            if (size < 0) continue;
            if (accessor.sizeFromOffset(input, offset) < size) {
                throw new MarshalException(String.format("Not enough bytes to read %dth component", i));
            }
            V field = accessor.slice(input, offset, size);
            offset += size;
            this.fields.get(i).validate(field, accessor);
        }
        if (!accessor.isEmptyFromOffset(input, offset)) {
            throw new MarshalException("Invalid remaining data after end of tuple value");
        }
    }
}

