/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.state;

import com.google.common.base.Throwables;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.repair.state.Completable;
import org.apache.cassandra.utils.Clock;

public class AbstractCompletable<I>
implements Completable<I> {
    private final long creationTimeMillis = Clock.Global.currentTimeMillis();
    private final long creationTimeNanos = Clock.Global.nanoTime();
    private final AtomicReference<Completable.Result> result = new AtomicReference<Object>(null);
    public final I id;
    protected volatile long lastUpdatedAtNs;

    public AbstractCompletable(I id) {
        this.id = id;
    }

    @Override
    public I getId() {
        return this.id;
    }

    @Override
    public long getInitializedAtMillis() {
        return this.nanosToMillis(this.creationTimeNanos);
    }

    @Override
    public long getInitializedAtNanos() {
        return this.creationTimeNanos;
    }

    @Override
    public long getLastUpdatedAtMillis() {
        return this.nanosToMillis(this.lastUpdatedAtNs);
    }

    @Override
    public long getLastUpdatedAtNanos() {
        return this.lastUpdatedAtNs;
    }

    @Override
    public Completable.Result getResult() {
        return this.result.get();
    }

    public void updated() {
        this.lastUpdatedAtNs = Clock.Global.nanoTime();
    }

    protected boolean tryResult(Completable.Result result) {
        if (!this.result.compareAndSet(null, result)) {
            return false;
        }
        this.onComplete();
        this.lastUpdatedAtNs = Clock.Global.nanoTime();
        return true;
    }

    protected void onComplete() {
    }

    protected long nanosToMillis(long nanos) {
        return this.creationTimeMillis + TimeUnit.NANOSECONDS.toMillis(nanos - this.creationTimeNanos);
    }

    protected class BasePhase {
        protected BasePhase() {
        }

        public void success() {
            AbstractCompletable.this.tryResult(Completable.Result.success());
        }

        public void success(String msg) {
            AbstractCompletable.this.tryResult(Completable.Result.success(msg));
        }

        public void fail(Throwable e) {
            this.fail(e == null ? null : Throwables.getStackTraceAsString((Throwable)e));
        }

        public void fail(String failureCause) {
            AbstractCompletable.this.tryResult(Completable.Result.fail(failureCause));
        }
    }

    protected class BaseSkipPhase
    extends BasePhase {
        protected BaseSkipPhase() {
        }

        public void skip(String msg) {
            AbstractCompletable.this.tryResult(Completable.Result.skip(msg));
        }
    }
}

