/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class TruncateRequest {
    public static final IVersionedSerializer<TruncateRequest> serializer = new Serializer();
    public final String keyspace;
    public final String table;

    public TruncateRequest(String keyspace, String table) {
        this.keyspace = keyspace;
        this.table = table;
    }

    public String toString() {
        return String.format("TruncateRequest(keyspace='%s', table='%s')'", this.keyspace, this.table);
    }

    private static class Serializer
    implements IVersionedSerializer<TruncateRequest> {
        private Serializer() {
        }

        @Override
        public void serialize(TruncateRequest request, DataOutputPlus out, int version) throws IOException {
            out.writeUTF(request.keyspace);
            out.writeUTF(request.table);
        }

        @Override
        public TruncateRequest deserialize(DataInputPlus in, int version) throws IOException {
            String keyspace = in.readUTF();
            String table = in.readUTF();
            return new TruncateRequest(keyspace, table);
        }

        @Override
        public long serializedSize(TruncateRequest request, int version) {
            return TypeSizes.sizeof(request.keyspace) + TypeSizes.sizeof(request.table);
        }
    }
}

