/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import com.google.common.base.Objects;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SimpleSelector;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

abstract class ElementsSelector
extends Selector {
    protected final Selector selected;

    protected ElementsSelector(Selector.Kind kind, Selector selected) {
        super(kind);
        this.selected = selected;
    }

    private static boolean isUnset(ByteBuffer bb) {
        return bb == ByteBufferUtil.UNSET_BYTE_BUFFER;
    }

    private static AbstractType<?> keyType(CollectionType<?> type) {
        return type.nameComparator();
    }

    public static AbstractType<?> valueType(CollectionType<?> type) {
        return type instanceof MapType ? type.valueComparator() : type.nameComparator();
    }

    public static Selector.Factory newElementFactory(String name, Selector.Factory factory, CollectionType<?> type, final Term key) {
        return new AbstractFactory(name, factory, type){

            @Override
            protected AbstractType<?> getReturnType() {
                return ElementsSelector.valueType(this.type);
            }

            @Override
            public Selector newInstance(QueryOptions options) throws InvalidRequestException {
                ByteBuffer keyValue = key.bindAndGet(options);
                if (keyValue == null) {
                    throw new InvalidRequestException("Invalid null value for element selection on " + this.factory.getColumnName());
                }
                if (keyValue == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                    throw new InvalidRequestException("Invalid unset value for element selection on " + this.factory.getColumnName());
                }
                return new ElementSelector(this.factory.newInstance(options), keyValue);
            }

            @Override
            public boolean areAllFetchedColumnsKnown() {
                return this.factory.areAllFetchedColumnsKnown() && (!this.type.isMultiCell() || !this.factory.isSimpleSelectorFactory() || key.isTerminal());
            }

            @Override
            public void addFetchedColumns(ColumnFilter.Builder builder) {
                if (!this.type.isMultiCell() || !this.factory.isSimpleSelectorFactory()) {
                    this.factory.addFetchedColumns(builder);
                    return;
                }
                ColumnMetadata column = ((SimpleSelector.SimpleSelectorFactory)this.factory).getColumn();
                builder.select(column, CellPath.create(((Term.Terminal)key).get(ProtocolVersion.V3)));
            }
        };
    }

    public static Selector.Factory newSliceFactory(String name, Selector.Factory factory, CollectionType<?> type, final Term from, final Term to) {
        return new AbstractFactory(name, factory, type){

            @Override
            protected AbstractType<?> getReturnType() {
                return this.type;
            }

            @Override
            public Selector newInstance(QueryOptions options) throws InvalidRequestException {
                ByteBuffer fromValue = from.bindAndGet(options);
                ByteBuffer toValue = to.bindAndGet(options);
                if (fromValue == null || toValue == null) {
                    throw new InvalidRequestException("Invalid null value for slice selection on " + this.factory.getColumnName());
                }
                return new SliceSelector(this.factory.newInstance(options), from.bindAndGet(options), to.bindAndGet(options));
            }

            @Override
            public boolean areAllFetchedColumnsKnown() {
                return this.factory.areAllFetchedColumnsKnown() && (!this.type.isMultiCell() || !this.factory.isSimpleSelectorFactory() || from.isTerminal() && to.isTerminal());
            }

            @Override
            public void addFetchedColumns(ColumnFilter.Builder builder) {
                if (!this.type.isMultiCell() || !this.factory.isSimpleSelectorFactory()) {
                    this.factory.addFetchedColumns(builder);
                    return;
                }
                ColumnMetadata column = ((SimpleSelector.SimpleSelectorFactory)this.factory).getColumn();
                ByteBuffer fromBB = ((Term.Terminal)from).get(ProtocolVersion.V3);
                ByteBuffer toBB = ((Term.Terminal)to).get(ProtocolVersion.V3);
                builder.slice(column, ElementsSelector.isUnset(fromBB) ? CellPath.BOTTOM : CellPath.create(fromBB), ElementsSelector.isUnset(toBB) ? CellPath.TOP : CellPath.create(toBB));
            }
        };
    }

    @Override
    public ByteBuffer getOutput(ProtocolVersion protocolVersion) {
        ByteBuffer value = this.selected.getOutput(protocolVersion);
        return value == null ? null : this.extractSelection(value);
    }

    protected abstract ByteBuffer extractSelection(ByteBuffer var1);

    @Override
    public void addInput(ProtocolVersion protocolVersion, Selector.InputRow input) {
        this.selected.addInput(protocolVersion, input);
    }

    @Override
    public void reset() {
        this.selected.reset();
    }

    @Override
    public boolean isTerminal() {
        return this.selected.isTerminal();
    }

    static class SliceSelector
    extends ElementsSelector {
        protected static final Selector.SelectorDeserializer deserializer = new Selector.SelectorDeserializer(){

            @Override
            protected Selector deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
                Selector selected = Selector.serializer.deserialize(in, version, metadata);
                boolean isFromUnset = in.readBoolean();
                ByteBuffer from = isFromUnset ? ByteBufferUtil.UNSET_BYTE_BUFFER : ByteBufferUtil.readWithVIntLength(in);
                boolean isToUnset = in.readBoolean();
                ByteBuffer to = isToUnset ? ByteBufferUtil.UNSET_BYTE_BUFFER : ByteBufferUtil.readWithVIntLength(in);
                return new SliceSelector(selected, from, to);
            }
        };
        private final CollectionType<?> type;
        private final ByteBuffer from;
        private final ByteBuffer to;

        private SliceSelector(Selector selected, ByteBuffer from, ByteBuffer to) {
            super(Selector.Kind.SLICE_SELECTOR, selected);
            assert (selected.getType() instanceof MapType || selected.getType() instanceof SetType) : "this shouldn't have passed validation in Selectable";
            assert (from != null && to != null) : "We can have unset buffers, but not nulls";
            this.type = (CollectionType)selected.getType();
            this.from = from;
            this.to = to;
        }

        @Override
        public void addFetchedColumns(ColumnFilter.Builder builder) {
            if (this.type.isMultiCell() && this.selected instanceof SimpleSelector) {
                ColumnMetadata column = ((SimpleSelector)this.selected).column;
                builder.slice(column, ElementsSelector.isUnset(this.from) ? CellPath.BOTTOM : CellPath.create(this.from), ElementsSelector.isUnset(this.to) ? CellPath.TOP : CellPath.create(this.to));
            } else {
                this.selected.addFetchedColumns(builder);
            }
        }

        @Override
        protected ByteBuffer extractSelection(ByteBuffer collection) {
            return ((CollectionSerializer)this.type.getSerializer()).getSliceFromSerialized(collection, this.from, this.to, this.type.nameComparator(), this.type.isFrozenCollection());
        }

        @Override
        public AbstractType<?> getType() {
            return this.type;
        }

        public String toString() {
            boolean fromUnset = ElementsSelector.isUnset(this.from);
            boolean toUnset = ElementsSelector.isUnset(this.to);
            return fromUnset && toUnset ? this.selected.toString() : String.format("%s[%s..%s]", this.selected, fromUnset ? "" : ElementsSelector.keyType(this.type).getString(this.from), toUnset ? "" : ElementsSelector.keyType(this.type).getString(this.to));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SliceSelector)) {
                return false;
            }
            SliceSelector s = (SliceSelector)o;
            return Objects.equal((Object)this.selected, (Object)s.selected) && Objects.equal((Object)this.from, (Object)s.from) && Objects.equal((Object)this.to, (Object)s.to);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.selected, this.from, this.to});
        }

        @Override
        protected int serializedSize(int version) {
            int size = serializer.serializedSize(this.selected, version) + 2;
            if (!ElementsSelector.isUnset(this.from)) {
                size += TypeSizes.sizeofWithVIntLength(this.from);
            }
            if (!ElementsSelector.isUnset(this.to)) {
                size += TypeSizes.sizeofWithVIntLength(this.to);
            }
            return size;
        }

        @Override
        protected void serialize(DataOutputPlus out, int version) throws IOException {
            serializer.serialize(this.selected, out, version);
            boolean isFromUnset = ElementsSelector.isUnset(this.from);
            out.writeBoolean(isFromUnset);
            if (!isFromUnset) {
                ByteBufferUtil.serializedSizeWithVIntLength(this.from);
            }
            boolean isToUnset = ElementsSelector.isUnset(this.to);
            out.writeBoolean(isToUnset);
            if (!isToUnset) {
                ByteBufferUtil.serializedSizeWithVIntLength(this.to);
            }
        }
    }

    static class ElementSelector
    extends ElementsSelector {
        protected static final Selector.SelectorDeserializer deserializer = new Selector.SelectorDeserializer(){

            @Override
            protected Selector deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
                Selector selected = Selector.serializer.deserialize(in, version, metadata);
                ByteBuffer key = ByteBufferUtil.readWithVIntLength(in);
                return new ElementSelector(selected, key);
            }
        };
        private final CollectionType<?> type;
        private final ByteBuffer key;

        private ElementSelector(Selector selected, ByteBuffer key) {
            super(Selector.Kind.ELEMENT_SELECTOR, selected);
            assert (selected.getType() instanceof MapType || selected.getType() instanceof SetType) : "this shouldn't have passed validation in Selectable";
            this.type = (CollectionType)selected.getType();
            this.key = key;
        }

        @Override
        public void addFetchedColumns(ColumnFilter.Builder builder) {
            if (this.type.isMultiCell() && this.selected instanceof SimpleSelector) {
                ColumnMetadata column = ((SimpleSelector)this.selected).column;
                builder.select(column, CellPath.create(this.key));
            } else {
                this.selected.addFetchedColumns(builder);
            }
        }

        @Override
        protected ByteBuffer extractSelection(ByteBuffer collection) {
            return ((CollectionSerializer)this.type.getSerializer()).getSerializedValue(collection, this.key, ElementsSelector.keyType(this.type));
        }

        @Override
        public AbstractType<?> getType() {
            return ElementSelector.valueType(this.type);
        }

        public String toString() {
            return String.format("%s[%s]", this.selected, ElementsSelector.keyType(this.type).getString(this.key));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementSelector)) {
                return false;
            }
            ElementSelector s = (ElementSelector)o;
            return Objects.equal((Object)this.selected, (Object)s.selected) && Objects.equal((Object)this.key, (Object)s.key);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.selected, this.key});
        }

        @Override
        protected int serializedSize(int version) {
            return TypeSizes.sizeofWithVIntLength(this.key) + serializer.serializedSize(this.selected, version);
        }

        @Override
        protected void serialize(DataOutputPlus out, int version) throws IOException {
            serializer.serialize(this.selected, out, version);
            ByteBufferUtil.serializedSizeWithVIntLength(this.key);
        }
    }

    private static abstract class AbstractFactory
    extends Selector.Factory {
        protected final String name;
        protected final Selector.Factory factory;
        protected final CollectionType<?> type;

        protected AbstractFactory(String name, Selector.Factory factory, CollectionType<?> type) {
            this.name = name;
            this.factory = factory;
            this.type = type;
        }

        @Override
        protected String getColumnName() {
            return this.name;
        }

        @Override
        protected void addColumnMapping(SelectionColumnMapping mapping, ColumnSpecification resultsColumn) {
            this.factory.addColumnMapping(mapping, resultsColumn);
        }

        @Override
        public boolean isAggregateSelectorFactory() {
            return this.factory.isAggregateSelectorFactory();
        }
    }
}

