/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.memtable;

import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.memtable.ShardBoundaries;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.UnfilteredSource;
import org.apache.cassandra.index.transactions.UpdateTransaction;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.OpOrder;

public interface Memtable
extends Comparable<Memtable>,
UnfilteredSource {
    public long put(PartitionUpdate var1, UpdateTransaction var2, OpOrder.Group var3);

    public long partitionCount();

    public long getLiveDataSize();

    public long operationCount();

    public TableMetadata metadata();

    public void addMemoryUsageTo(MemoryUsage var1);

    public static MemoryUsage newMemoryUsage() {
        return new MemoryUsage();
    }

    public static MemoryUsage getMemoryUsage(Memtable memtable) {
        MemoryUsage usage = Memtable.newMemoryUsage();
        memtable.addMemoryUsageTo(usage);
        return usage;
    }

    public void markExtraOnHeapUsed(long var1, OpOrder.Group var3);

    public void markExtraOffHeapUsed(long var1, OpOrder.Group var3);

    public FlushablePartitionSet<?> getFlushSet(PartitionPosition var1, PartitionPosition var2);

    public void switchOut(OpOrder.Barrier var1, AtomicReference<CommitLogPosition> var2);

    public void discard();

    public boolean accepts(OpOrder.Group var1, CommitLogPosition var2);

    public CommitLogPosition getApproximateCommitLogLowerBound();

    public CommitLogPosition getCommitLogLowerBound();

    public LastCommitLogPosition getFinalCommitLogUpperBound();

    public boolean mayContainDataBefore(CommitLogPosition var1);

    public boolean isClean();

    @Override
    default public int compareTo(Memtable that) {
        return this.getApproximateCommitLogLowerBound().compareTo(that.getApproximateCommitLogLowerBound());
    }

    public boolean shouldSwitch(ColumnFamilyStore.FlushReason var1);

    public void metadataUpdated();

    public void localRangesUpdated();

    public void performSnapshot(String var1);

    public static final class LastCommitLogPosition
    extends CommitLogPosition {
        public LastCommitLogPosition(CommitLogPosition copy) {
            super(copy.segmentId, copy.position);
        }
    }

    public static interface FlushablePartitionSet<P extends Partition>
    extends Iterable<P>,
    SSTableWriter.SSTableSizeParameters {
        public Memtable memtable();

        public PartitionPosition from();

        public PartitionPosition to();

        public CommitLogPosition commitLogLowerBound();

        public CommitLogPosition commitLogUpperBound();

        public RegularAndStaticColumns columns();

        public EncodingStats encodingStats();

        default public TableMetadata metadata() {
            return this.memtable().metadata();
        }

        default public boolean isEmpty() {
            return this.partitionCount() > 0L;
        }
    }

    @NotThreadSafe
    public static class MemoryUsage {
        public long ownsOnHeap = 0L;
        public long ownsOffHeap = 0L;
        public float ownershipRatioOnHeap = 0.0f;
        public float ownershipRatioOffHeap = 0.0f;

        public String toString() {
            return String.format("%s (%.0f%%) on-heap, %s (%.0f%%) off-heap", FBUtilities.prettyPrintMemory(this.ownsOnHeap), Float.valueOf(this.ownershipRatioOnHeap * 100.0f), FBUtilities.prettyPrintMemory(this.ownsOffHeap), Float.valueOf(this.ownershipRatioOffHeap * 100.0f));
        }
    }

    public static interface Owner {
        public Future<CommitLogPosition> signalFlushRequired(Memtable var1, ColumnFamilyStore.FlushReason var2);

        public Memtable getCurrentMemtable();

        public Iterable<Memtable> getIndexMemtables();

        public ShardBoundaries localRangeSplits(int var1);
    }

    public static interface Factory {
        public Memtable create(AtomicReference<CommitLogPosition> var1, TableMetadataRef var2, Owner var3);

        default public boolean writesShouldSkipCommitLog() {
            return false;
        }

        default public boolean writesAreDurable() {
            return false;
        }

        default public boolean streamToMemtable() {
            return false;
        }

        default public boolean streamFromMemtable() {
            return false;
        }

        default public TableMetrics.ReleasableMetric createMemtableMetrics(TableMetadataRef metadataRef) {
            return null;
        }
    }
}

