/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import java.nio.ByteBuffer;
import org.apache.cassandra.utils.Shared;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.EnsureOnHeap;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.apache.cassandra.utils.memory.MemtableBufferAllocator;
import org.apache.cassandra.utils.memory.MemtableCleaner;
import org.apache.cassandra.utils.memory.MemtablePool;

public class HeapPool
extends MemtablePool {
    private static final EnsureOnHeap ENSURE_NOOP = new EnsureOnHeap.NoOp();

    public HeapPool(long maxOnHeapMemory, float cleanupThreshold, MemtableCleaner cleaner) {
        super(maxOnHeapMemory, 0L, cleanupThreshold, cleaner);
    }

    @Override
    public MemtableAllocator newAllocator(String table) {
        return new Allocator(this);
    }

    public static class Logged
    extends MemtablePool {
        private static Listener onAllocated = (i, table) -> {};

        public Logged(long maxOnHeapMemory, float cleanupThreshold, MemtableCleaner cleaner) {
            super(maxOnHeapMemory, 0L, cleanupThreshold, cleaner);
        }

        @Override
        public MemtableAllocator newAllocator(String table) {
            return new Allocator(this, table);
        }

        @Override
        MemtablePool.SubPool getSubPool(long limit, float cleanThreshold) {
            return new LoggedSubPool(limit, cleanThreshold);
        }

        public static void setListener(Listener listener) {
            onAllocated = listener;
        }

        private static class Allocator
        extends MemtableBufferAllocator {
            Allocator(Logged pool, String table) {
                super(((LoggedSubPool)pool.onHeap).newAllocator(table), ((LoggedSubPool)pool.offHeap).newAllocator(table));
            }

            @Override
            public ByteBuffer allocate(int size, OpOrder.Group opGroup) {
                super.onHeap().allocate(size, opGroup);
                return ByteBuffer.allocate(size);
            }

            @Override
            public EnsureOnHeap ensureOnHeap() {
                return ENSURE_NOOP;
            }
        }

        class LoggedSubPool
        extends MemtablePool.SubPool {
            public LoggedSubPool(long limit, float cleanThreshold) {
                super(Logged.this, limit, cleanThreshold);
            }

            public MemtableAllocator.SubAllocator newAllocator(final String table) {
                return new MemtableAllocator.SubAllocator(this){

                    @Override
                    public void allocate(long size, OpOrder.Group opGroup) {
                        onAllocated.accept(size, table);
                        super.allocate(size, opGroup);
                    }
                };
            }
        }

        @Shared(scope={Shared.Scope.SIMULATION})
        public static interface Listener {
            public void accept(long var1, String var3);
        }
    }

    private static class Allocator
    extends MemtableBufferAllocator {
        Allocator(HeapPool pool) {
            super(pool.onHeap.newAllocator(), pool.offHeap.newAllocator());
        }

        @Override
        public ByteBuffer allocate(int size, OpOrder.Group opGroup) {
            super.onHeap().allocate(size, opGroup);
            return ByteBuffer.allocate(size);
        }

        @Override
        public EnsureOnHeap ensureOnHeap() {
            return ENSURE_NOOP;
        }
    }
}

