/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.marshal.ValueComparators;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SetSerializer<T>
extends CollectionSerializer<Set<T>> {
    private static final ConcurrentMap<TypeSerializer<?>, SetSerializer> instances = new ConcurrentHashMap();
    public final TypeSerializer<T> elements;
    private final ValueComparators comparators;

    public static <T> SetSerializer<T> getInstance(TypeSerializer<T> elements, ValueComparators comparators) {
        SetSerializer t = (SetSerializer)instances.get(elements);
        if (t == null) {
            t = instances.computeIfAbsent(elements, k -> new SetSerializer(k, comparators));
        }
        return t;
    }

    public SetSerializer(TypeSerializer<T> elements, ValueComparators comparators) {
        this.elements = elements;
        this.comparators = comparators;
    }

    @Override
    public List<ByteBuffer> serializeValues(Set<T> values) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(values.size());
        for (T value : values) {
            buffers.add(this.elements.serialize(value));
        }
        Collections.sort(buffers, this.comparators.buffer);
        return buffers;
    }

    @Override
    public int getElementCount(Set<T> value) {
        return value.size();
    }

    @Override
    public <V> void validateForNativeProtocol(V input, ValueAccessor<V> accessor, ProtocolVersion version) {
        try {
            if (accessor.isEmpty(input)) {
                return;
            }
            int n = SetSerializer.readCollectionSize(input, accessor, version);
            int offset = SetSerializer.sizeOfCollectionSize(n, version);
            for (int i = 0; i < n; ++i) {
                V value = SetSerializer.readValue(input, accessor, offset, version);
                offset += SetSerializer.sizeOfValue(value, accessor, version);
                this.elements.validate(value, accessor);
            }
            if (!accessor.isEmptyFromOffset(input, offset)) {
                throw new MarshalException("Unexpected extraneous bytes after set value");
            }
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a set");
        }
    }

    @Override
    public <V> Set<T> deserializeForNativeProtocol(V input, ValueAccessor<V> accessor, ProtocolVersion version) {
        try {
            int n = SetSerializer.readCollectionSize(input, accessor, version);
            int offset = SetSerializer.sizeOfCollectionSize(n, version);
            if (n < 0) {
                throw new MarshalException("The data cannot be deserialized as a set");
            }
            LinkedHashSet<T> l = new LinkedHashSet<T>(Math.min(n, 256));
            for (int i = 0; i < n; ++i) {
                V value = SetSerializer.readValue(input, accessor, offset, version);
                offset += SetSerializer.sizeOfValue(value, accessor, version);
                this.elements.validate(value, accessor);
                l.add(this.elements.deserialize(value, accessor));
            }
            if (!accessor.isEmptyFromOffset(input, offset)) {
                throw new MarshalException("Unexpected extraneous bytes after set value");
            }
            return l;
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a set");
        }
    }

    @Override
    public String toString(Set<T> value) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean isFirst = true;
        for (T element : value) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.elements.toString(element));
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Class<Set<T>> getType() {
        return Set.class;
    }

    @Override
    public ByteBuffer getSerializedValue(ByteBuffer input, ByteBuffer key, AbstractType<?> comparator) {
        try {
            int n = SetSerializer.readCollectionSize(input, ProtocolVersion.V3);
            int offset = SetSerializer.sizeOfCollectionSize(n, ProtocolVersion.V3);
            for (int i = 0; i < n; ++i) {
                ByteBuffer value = SetSerializer.readValue(input, ByteBufferAccessor.instance, offset, ProtocolVersion.V3);
                offset += SetSerializer.sizeOfValue(value, ByteBufferAccessor.instance, ProtocolVersion.V3);
                int comparison = comparator.compareForCQL(value, key);
                if (comparison == 0) {
                    return value;
                }
                if (comparison <= 0) continue;
                return null;
            }
            return null;
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a set");
        }
    }

    @Override
    public ByteBuffer getSliceFromSerialized(ByteBuffer collection, ByteBuffer from, ByteBuffer to, AbstractType<?> comparator, boolean frozen) {
        if (from == ByteBufferUtil.UNSET_BYTE_BUFFER && to == ByteBufferUtil.UNSET_BYTE_BUFFER) {
            return collection;
        }
        try {
            ByteBuffer input = collection.duplicate();
            int n = SetSerializer.readCollectionSize(input, ProtocolVersion.V3);
            input.position(input.position() + SetSerializer.sizeOfCollectionSize(n, ProtocolVersion.V3));
            int startPos = input.position();
            int count = 0;
            boolean inSlice = from == ByteBufferUtil.UNSET_BYTE_BUFFER;
            for (int i = 0; i < n; ++i) {
                int comparison;
                int pos = input.position();
                ByteBuffer value = SetSerializer.readValue(input, ByteBufferAccessor.instance, 0, ProtocolVersion.V3);
                input.position(input.position() + SetSerializer.sizeOfValue(value, ByteBufferAccessor.instance, ProtocolVersion.V3));
                if (!inSlice) {
                    comparison = comparator.compareForCQL(from, value);
                    if (comparison > 0) continue;
                    inSlice = true;
                    startPos = pos;
                }
                int n2 = comparison = to == ByteBufferUtil.UNSET_BYTE_BUFFER ? -1 : comparator.compareForCQL(value, to);
                if (comparison > 0) {
                    input.position(pos);
                    break;
                }
                ++count;
                if (comparison == 0) break;
            }
            if (count == 0 && !frozen) {
                return null;
            }
            return this.copyAsNewCollection(collection, count, startPos, input.position(), ProtocolVersion.V3);
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a set");
        }
    }
}

