/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.BufferDecoratedKey;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.ByteArrayAccessor;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.memory.Cloner;

public abstract class ByteBufferCloner
implements Cloner {
    public abstract ByteBuffer allocate(int var1);

    @Override
    public DecoratedKey clone(DecoratedKey key) {
        return new BufferDecoratedKey(key.getToken(), this.clone(key.getKey()));
    }

    @Override
    public Clustering<?> clone(Clustering<?> clustering) {
        return clustering.clone(this);
    }

    @Override
    public Cell<?> clone(Cell<?> cell) {
        return cell.clone(this);
    }

    public final ByteBuffer clone(ByteBuffer buffer) {
        return this.clone(buffer, ByteBufferAccessor.instance);
    }

    public final ByteBuffer clone(byte[] bytes) {
        return this.clone(bytes, ByteArrayAccessor.instance);
    }

    public final <V> ByteBuffer clone(V value, ValueAccessor<V> accessor) {
        assert (value != null);
        int size = accessor.size(value);
        if (size == 0) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        ByteBuffer cloned = this.allocate(size);
        cloned.mark();
        accessor.write(value, cloned);
        cloned.reset();
        return cloned;
    }
}

