/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import org.apache.cassandra.metrics.Sampler;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.formatter.TableBuilder;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang3.StringUtils;

@Command(name="profileload", description="Low footprint profiling of activity for a period of time")
public class ProfileLoad
extends NodeTool.NodeToolCmd {
    @Arguments(usage="<keyspace> <cfname> <duration>", description="The keyspace, column family name, and duration in milliseconds")
    private List<String> args = new ArrayList<String>();
    @Option(name={"-s"}, description="Capacity of the sampler, higher for more accuracy (Default: 256)")
    private int capacity = 256;
    @Option(name={"-k"}, description="Number of the top samples to list (Default: 10)")
    private int topCount = 10;
    @Option(name={"-a"}, description="Comma separated list of samplers to use (Default: all)")
    private String samplers = StringUtils.join((Object[])Sampler.SamplerType.values(), (char)',');

    @Override
    public void execute(NodeProbe probe) {
        Map<String, List<CompositeData>> results;
        Preconditions.checkArgument((this.args.size() == 3 || this.args.size() == 1 || this.args.size() == 0 ? 1 : 0) != 0, (Object)"Invalid arguments, either [keyspace table duration] or [duration] or no args");
        Preconditions.checkArgument((this.topCount < this.capacity ? 1 : 0) != 0, (Object)"TopK count (-k) option must be smaller then the summary capacity (-s)");
        String keyspace = null;
        String table = null;
        Integer durationMillis = 10000;
        if (this.args.size() == 3) {
            keyspace = this.args.get(0);
            table = this.args.get(1);
            durationMillis = Integer.valueOf(this.args.get(2));
        } else if (this.args.size() == 1) {
            durationMillis = Integer.valueOf(this.args.get(0));
        }
        ArrayList targets = Lists.newArrayList();
        List available = Arrays.stream(Sampler.SamplerType.values()).map(Enum::toString).collect(Collectors.toList());
        for (String s : this.samplers.split(",")) {
            String sampler = s.trim().toUpperCase();
            Preconditions.checkArgument((boolean)available.contains(sampler), (Object)String.format("'%s' sampler is not available from: %s", s, Arrays.toString((Object[])Sampler.SamplerType.values())));
            targets.add(sampler);
        }
        try {
            results = keyspace == null ? probe.getPartitionSample(this.capacity, durationMillis, this.topCount, targets) : probe.getPartitionSample(keyspace, table, this.capacity, durationMillis, this.topCount, targets);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
        AtomicBoolean first = new AtomicBoolean(true);
        ResultBuilder rb = new ResultBuilder(first, results, targets);
        for (String sampler : Lists.newArrayList((Object[])new String[]{"READS", "WRITES", "CAS_CONTENTIONS"})) {
            rb.forType(Sampler.SamplerType.valueOf(sampler), "Frequency of " + sampler.toLowerCase().replaceAll("_", " ") + " by partition").addColumn("Table", "table").addColumn("Partition", "value").addColumn("Count", "count").addColumn("+/-", "error").print(probe.output().out);
        }
        rb.forType(Sampler.SamplerType.WRITE_SIZE, "Max mutation size by partition").addColumn("Table", "table").addColumn("Partition", "value").addColumn("Bytes", "count").print(probe.output().out);
        rb.forType(Sampler.SamplerType.LOCAL_READ_TIME, "Longest read query times").addColumn("Query", "value").addColumn("Microseconds", "count").print(probe.output().out);
    }

    private class ResultBuilder {
        private Sampler.SamplerType type;
        private String description;
        private AtomicBoolean first;
        private Map<String, List<CompositeData>> results;
        private List<String> targets;
        private List<Pair<String, String>> dataKeys;

        public ResultBuilder(AtomicBoolean first, Map<String, List<CompositeData>> results, List<String> targets) {
            this.first = first;
            this.results = results;
            this.targets = targets;
            this.dataKeys = new ArrayList<Pair<String, String>>();
            this.dataKeys.add(Pair.create("  ", "  "));
        }

        public ResultBuilder forType(Sampler.SamplerType type, String description) {
            ResultBuilder rb = new ResultBuilder(this.first, this.results, this.targets);
            rb.type = type;
            rb.description = description;
            return rb;
        }

        public ResultBuilder addColumn(String title, String key) {
            this.dataKeys.add(Pair.create(title, key));
            return this;
        }

        private String get(CompositeData cd, String key) {
            if (cd.containsKey(key)) {
                return cd.get(key).toString();
            }
            return key;
        }

        public void print(PrintStream outStream) {
            if (this.targets.contains(this.type.toString())) {
                if (!this.first.get()) {
                    outStream.println();
                }
                this.first.set(false);
                outStream.println(this.description + ':');
                TableBuilder out = new TableBuilder();
                out.add(this.dataKeys.stream().map(p -> (String)p.left).collect(Collectors.toList()).toArray(new String[0]));
                List<CompositeData> topk = this.results.get(this.type.toString());
                for (CompositeData cd : topk) {
                    out.add(this.dataKeys.stream().map(p -> this.get(cd, (String)p.right)).collect(Collectors.toList()).toArray(new String[0]));
                }
                if (topk.size() == 0) {
                    outStream.println("   Nothing recorded during sampling period...");
                } else {
                    out.printTo(outStream);
                }
            }
        }
    }
}

