/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.db.BufferClusteringBound;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ValueAccessor;

public abstract class CBuilder {
    public static CBuilder STATIC_BUILDER = new CBuilder(){

        @Override
        public int count() {
            return 0;
        }

        @Override
        public int remainingCount() {
            return 0;
        }

        @Override
        public ClusteringComparator comparator() {
            throw new UnsupportedOperationException();
        }

        public <T> CBuilder add(T value, ValueAccessor<T> accessor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CBuilder add(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Clustering<?> build() {
            return Clustering.STATIC_CLUSTERING;
        }

        @Override
        public ClusteringBound<?> buildBound(boolean isStart, boolean isInclusive) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Clustering<?> buildWith(List<ByteBuffer> newValues) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ClusteringBound<?> buildBoundWith(List<ByteBuffer> newValues, boolean isStart, boolean isInclusive) {
            throw new UnsupportedOperationException();
        }
    };

    public static CBuilder create(ClusteringComparator comparator) {
        return new ArrayBackedBuilder(comparator);
    }

    public abstract int count();

    public abstract int remainingCount();

    public abstract ClusteringComparator comparator();

    public final CBuilder add(ByteBuffer value) {
        return this.add(value, ByteBufferAccessor.instance);
    }

    public final <V> CBuilder add(ClusteringPrefix<V> prefix, int i) {
        return this.add(prefix.get(i), prefix.accessor());
    }

    public abstract <V> CBuilder add(V var1, ValueAccessor<V> var2);

    public abstract CBuilder add(Object var1);

    public abstract Clustering<?> build();

    public abstract ClusteringBound<?> buildBound(boolean var1, boolean var2);

    public abstract Clustering<?> buildWith(List<ByteBuffer> var1);

    public abstract ClusteringBound<?> buildBoundWith(List<ByteBuffer> var1, boolean var2, boolean var3);

    private static class ArrayBackedBuilder
    extends CBuilder {
        private final ClusteringComparator type;
        private final ByteBuffer[] values;
        private int size;
        private boolean built;

        public ArrayBackedBuilder(ClusteringComparator type) {
            this.type = type;
            this.values = new ByteBuffer[type.size()];
        }

        @Override
        public int count() {
            return this.size;
        }

        @Override
        public int remainingCount() {
            return this.values.length - this.size;
        }

        @Override
        public ClusteringComparator comparator() {
            return this.type;
        }

        @Override
        public <V> CBuilder add(V value, ValueAccessor<V> accessor) {
            if (this.isDone()) {
                throw new IllegalStateException();
            }
            this.values[this.size++] = accessor.toBuffer(value);
            return this;
        }

        @Override
        public CBuilder add(Object value) {
            return this.add(this.type.subtype(this.size).decompose(value));
        }

        private boolean isDone() {
            return this.remainingCount() == 0 || this.built;
        }

        @Override
        public Clustering<?> build() {
            this.built = true;
            return this.size == 0 ? Clustering.EMPTY : Clustering.make(this.values);
        }

        @Override
        public ClusteringBound<?> buildBound(boolean isStart, boolean isInclusive) {
            this.built = true;
            if (this.size == 0) {
                return isStart ? BufferClusteringBound.BOTTOM : BufferClusteringBound.TOP;
            }
            return BufferClusteringBound.create(ClusteringBound.boundKind(isStart, isInclusive), this.size == this.values.length ? this.values : Arrays.copyOfRange(this.values, 0, this.size));
        }

        @Override
        public Clustering<?> buildWith(List<ByteBuffer> newValues) {
            assert (this.size + newValues.size() <= this.type.size());
            ByteBuffer[] buffers = Arrays.copyOf(this.values, this.type.size());
            int newSize = this.size;
            for (ByteBuffer value : newValues) {
                buffers[newSize++] = value;
            }
            return Clustering.make(buffers);
        }

        @Override
        public ClusteringBound<?> buildBoundWith(List<ByteBuffer> newValues, boolean isStart, boolean isInclusive) {
            ByteBuffer[] buffers = Arrays.copyOf(this.values, this.size + newValues.size());
            int newSize = this.size;
            for (ByteBuffer value : newValues) {
                buffers[newSize++] = value;
            }
            return BufferClusteringBound.create(ClusteringBound.boundKind(isStart, isInclusive), buffers);
        }
    }
}

