/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.dht.Datacenters;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaCollection;
import org.apache.cassandra.locator.ReplicationFactor;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkTopologyStrategy
extends AbstractReplicationStrategy {
    public static final String REPLICATION_FACTOR = "replication_factor";
    private final Map<String, ReplicationFactor> datacenters;
    private final ReplicationFactor aggregateRf;
    private static final Logger logger = LoggerFactory.getLogger(NetworkTopologyStrategy.class);

    public NetworkTopologyStrategy(String keyspaceName, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> configOptions) throws ConfigurationException {
        super(keyspaceName, tokenMetadata, snitch, configOptions);
        int replicas = 0;
        int trans = 0;
        HashMap<String, ReplicationFactor> newDatacenters = new HashMap<String, ReplicationFactor>();
        if (configOptions != null) {
            for (Map.Entry<String, String> entry : configOptions.entrySet()) {
                String dc = entry.getKey();
                if (dc.equalsIgnoreCase(REPLICATION_FACTOR)) {
                    throw new ConfigurationException("replication_factor should not appear as an option at construction time for NetworkTopologyStrategy");
                }
                ReplicationFactor rf = ReplicationFactor.fromString(entry.getValue());
                replicas += rf.allReplicas;
                trans += rf.transientReplicas();
                newDatacenters.put(dc, rf);
            }
        }
        this.datacenters = Collections.unmodifiableMap(newDatacenters);
        this.aggregateRf = ReplicationFactor.withTransient(replicas, trans);
        logger.info("Configured datacenter replicas are {}", (Object)FBUtilities.toString(this.datacenters));
    }

    @Override
    public EndpointsForRange calculateNaturalReplicas(Token searchToken, TokenMetadata tokenMetadata) {
        ArrayList<Token> sortedTokens = tokenMetadata.sortedTokens();
        Token replicaEnd = TokenMetadata.firstToken(sortedTokens, searchToken);
        Token replicaStart = tokenMetadata.getPredecessor(replicaEnd);
        Range<Token> replicatedRange = new Range<Token>(replicaStart, replicaEnd);
        EndpointsForRange.Builder builder = new EndpointsForRange.Builder(replicatedRange);
        HashSet<Pair<String, String>> seenRacks = new HashSet<Pair<String, String>>();
        TokenMetadata.Topology topology = tokenMetadata.getTopology();
        Multimap<String, InetAddressAndPort> allEndpoints = topology.getDatacenterEndpoints();
        ImmutableMap<String, ImmutableMultimap<String, InetAddressAndPort>> racks = topology.getDatacenterRacks();
        assert (!allEndpoints.isEmpty() && !racks.isEmpty()) : "not aware of any cluster members";
        int dcsToFill = 0;
        HashMap<String, DatacenterEndpoints> dcs = new HashMap<String, DatacenterEndpoints>(this.datacenters.size() * 2);
        for (Map.Entry<String, ReplicationFactor> en : this.datacenters.entrySet()) {
            String dc = en.getKey();
            ReplicationFactor rf = en.getValue();
            int nodeCount = this.sizeOrZero(allEndpoints.get((Object)dc));
            if (rf.allReplicas <= 0 || nodeCount <= 0) continue;
            DatacenterEndpoints dcEndpoints = new DatacenterEndpoints(rf, this.sizeOrZero((Multimap)racks.get(dc)), nodeCount, builder, seenRacks);
            dcs.put(dc, dcEndpoints);
            ++dcsToFill;
        }
        Iterator<Token> tokenIter = TokenMetadata.ringIterator(sortedTokens, searchToken, false);
        while (dcsToFill > 0 && tokenIter.hasNext()) {
            Token next = tokenIter.next();
            InetAddressAndPort ep = tokenMetadata.getEndpoint(next);
            Pair<String, String> location = topology.getLocation(ep);
            DatacenterEndpoints dcEndpoints = (DatacenterEndpoints)dcs.get(location.left);
            if (dcEndpoints == null || !dcEndpoints.addEndpointAndCheckIfDone(ep, location, replicatedRange)) continue;
            --dcsToFill;
        }
        return builder.build();
    }

    private int sizeOrZero(Multimap<?, ?> collection) {
        return collection != null ? collection.asMap().size() : 0;
    }

    private int sizeOrZero(Collection<?> collection) {
        return collection != null ? collection.size() : 0;
    }

    @Override
    public ReplicationFactor getReplicationFactor() {
        return this.aggregateRf;
    }

    public ReplicationFactor getReplicationFactor(String dc) {
        ReplicationFactor replicas = this.datacenters.get(dc);
        return replicas == null ? ReplicationFactor.ZERO : replicas;
    }

    public Set<String> getDatacenters() {
        return this.datacenters.keySet();
    }

    @Override
    public Collection<String> recognizedOptions() {
        return Datacenters.getValidDatacenters();
    }

    protected static void prepareOptions(Map<String, String> options, Map<String, String> previousOptions) {
        String replication = options.remove(REPLICATION_FACTOR);
        if (replication == null && options.size() == 0) {
            replication = previousOptions.get(REPLICATION_FACTOR);
        } else if (replication != null) {
            previousOptions.entrySet().stream().filter(e -> !((String)e.getKey()).equals(REPLICATION_FACTOR)).forEach(e -> {
                String cfr_ignored_0 = (String)options.putIfAbsent((String)e.getKey(), (String)e.getValue());
            });
        }
        if (replication != null) {
            ReplicationFactor defaultReplicas = ReplicationFactor.fromString(replication);
            Datacenters.getValidDatacenters().forEach(dc -> options.putIfAbsent((String)dc, defaultReplicas.toParseableString()));
        }
        options.values().removeAll(Collections.singleton("0"));
    }

    @Override
    protected void validateExpectedOptions() throws ConfigurationException {
        if (this.configOptions.isEmpty()) {
            throw new ConfigurationException("Configuration for at least one datacenter must be present");
        }
        super.validateExpectedOptions();
    }

    @Override
    public void validateOptions() throws ConfigurationException {
        for (Map.Entry e : this.configOptions.entrySet()) {
            if (((String)e.getKey()).equalsIgnoreCase(REPLICATION_FACTOR)) {
                throw new ConfigurationException("replication_factor should not appear as an option to NetworkTopologyStrategy");
            }
            this.validateReplicationFactor((String)e.getValue());
        }
    }

    @Override
    public void maybeWarnOnOptions() {
        if (!SchemaConstants.isSystemKeyspace(this.keyspaceName)) {
            ImmutableMultimap<String, InetAddressAndPort> dcsNodes = StorageService.instance.getTokenMetadata().getDC2AllEndpoints(this.snitch);
            for (Map.Entry e : this.configOptions.entrySet()) {
                String dc = (String)e.getKey();
                ReplicationFactor rf = this.getReplicationFactor(dc);
                int nodeCount = dcsNodes.get((Object)dc).size();
                if (rf.fullReplicas <= nodeCount || nodeCount == 0) continue;
                String msg = "Your replication factor " + rf.fullReplicas + " for keyspace " + this.keyspaceName + " is higher than the number of nodes " + nodeCount + " for datacenter " + dc;
                ClientWarn.instance.warn(msg);
                logger.warn(msg);
            }
        }
    }

    @Override
    public boolean hasSameSettings(AbstractReplicationStrategy other) {
        return super.hasSameSettings(other) && ((NetworkTopologyStrategy)other).datacenters.equals(this.datacenters);
    }

    private static final class DatacenterEndpoints {
        EndpointsForRange.Builder replicas;
        Set<Pair<String, String>> racks;
        int rfLeft;
        int acceptableRackRepeats;
        int transients;

        DatacenterEndpoints(ReplicationFactor rf, int rackCount, int nodeCount, EndpointsForRange.Builder replicas, Set<Pair<String, String>> racks) {
            this.replicas = replicas;
            this.racks = racks;
            this.rfLeft = Math.min(rf.allReplicas, nodeCount);
            this.acceptableRackRepeats = rf.allReplicas - rackCount;
            int reduceTransients = rf.allReplicas - this.rfLeft;
            this.transients = Math.max(rf.transientReplicas() - reduceTransients, 0);
            ReplicationFactor.validate(this.rfLeft, this.transients);
        }

        boolean addEndpointAndCheckIfDone(InetAddressAndPort ep, Pair<String, String> location, Range<Token> replicatedRange) {
            if (this.done()) {
                return false;
            }
            if (this.replicas.endpoints().contains(ep)) {
                return false;
            }
            Replica replica = new Replica(ep, replicatedRange, this.rfLeft > this.transients);
            if (this.racks.add(location)) {
                --this.rfLeft;
                this.replicas.add(replica, ReplicaCollection.Builder.Conflict.NONE);
                return this.done();
            }
            if (this.acceptableRackRepeats <= 0) {
                return false;
            }
            this.replicas.add(replica, ReplicaCollection.Builder.Conflict.NONE);
            --this.acceptableRackRepeats;
            --this.rfLeft;
            return this.done();
        }

        boolean done() {
            assert (this.rfLeft >= 0);
            return this.rfLeft == 0;
        }
    }
}

