/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import io.netty.channel.Channel;
import java.io.IOException;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.net.OutboundConnectionSettings;
import org.apache.cassandra.streaming.DefaultConnectionFactory;
import org.apache.cassandra.streaming.StreamConnectionFactory;

public class BulkLoadConnectionFactory
extends DefaultConnectionFactory
implements StreamConnectionFactory {
    private final boolean outboundBindAny;
    private final int secureStoragePort;
    private final EncryptionOptions.ServerEncryptionOptions encryptionOptions;

    public BulkLoadConnectionFactory(int secureStoragePort, EncryptionOptions.ServerEncryptionOptions encryptionOptions, boolean outboundBindAny) {
        this.secureStoragePort = secureStoragePort;
        this.encryptionOptions = encryptionOptions;
        this.outboundBindAny = outboundBindAny;
    }

    @Override
    public Channel createConnection(OutboundConnectionSettings template, int messagingVersion) throws IOException {
        if (this.encryptionOptions != null && this.encryptionOptions.internode_encryption != EncryptionOptions.ServerEncryptionOptions.InternodeEncryption.none) {
            template = template.withConnectTo(template.to.withPort(this.secureStoragePort)).withEncryption(this.encryptionOptions);
        }
        return super.createConnection(template, messagingVersion);
    }
}

