/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.concurrent.DebuggableScheduledThreadPoolExecutor;
import org.apache.cassandra.concurrent.JMXEnabledSingleThreadExecutor;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestSyn;
import org.apache.cassandra.gms.GossiperDiagnostics;
import org.apache.cassandra.gms.GossiperMBean;
import org.apache.cassandra.gms.HeartBeatState;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.IFailureDetectionEventListener;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.NoPayload;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.CassandraVersion;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.ExpiringMemoizingSupplier;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.MBeanWrapper;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.RecomputingSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gossiper
implements IFailureDetectionEventListener,
GossiperMBean {
    public static final String MBEAN_NAME = "org.apache.cassandra.net:type=Gossiper";
    private static final DebuggableScheduledThreadPoolExecutor executor = new DebuggableScheduledThreadPoolExecutor("GossipTasks");
    static final ApplicationState[] STATES = ApplicationState.values();
    static final List<String> DEAD_STATES = Arrays.asList("removing", "removed", "LEFT", "hibernate");
    static ArrayList<String> SILENT_SHUTDOWN_STATES = new ArrayList();
    private static final List<String> ADMINISTRATIVELY_INACTIVE_STATES;
    private volatile ScheduledFuture<?> scheduledGossipTask;
    private static final ReentrantLock taskLock;
    public static final int intervalInMillis = 1000;
    public static final int QUARANTINE_DELAY;
    private static final Logger logger;
    private static final NoSpamLogger noSpamLogger;
    public static final Gossiper instance;
    volatile long firstSynSendAt = 0L;
    public static final long aVeryLongTime;
    static final int MAX_GENERATION_DIFFERENCE = 31536000;
    private static final long FAT_CLIENT_TIMEOUT;
    private static final long FAILED_BOOTSTRAP_TIMEOUT;
    private final Random random = new Random();
    private final List<IEndpointStateChangeSubscriber> subscribers = new CopyOnWriteArrayList<IEndpointStateChangeSubscriber>();
    @VisibleForTesting
    final Set<InetAddressAndPort> liveEndpoints = new ConcurrentSkipListSet<InetAddressAndPort>();
    private final Map<InetAddressAndPort, Long> unreachableEndpoints = new ConcurrentHashMap<InetAddressAndPort, Long>();
    @VisibleForTesting
    final Set<InetAddressAndPort> seeds = new ConcurrentSkipListSet<InetAddressAndPort>();
    final ConcurrentMap<InetAddressAndPort, EndpointState> endpointStateMap = new ConcurrentHashMap<InetAddressAndPort, EndpointState>();
    private final Map<InetAddressAndPort, Long> justRemovedEndpoints = new ConcurrentHashMap<InetAddressAndPort, Long>();
    private final Map<InetAddressAndPort, Long> expireTimeEndpointMap = new ConcurrentHashMap<InetAddressAndPort, Long>();
    private volatile boolean inShadowRound = false;
    private final Set<InetAddressAndPort> seedsInShadowRound = new ConcurrentSkipListSet<InetAddressAndPort>();
    private final Map<InetAddressAndPort, EndpointState> endpointShadowStateMap = new ConcurrentHashMap<InetAddressAndPort, EndpointState>();
    private volatile long lastProcessedMessageAt = System.currentTimeMillis();
    private volatile boolean upgradeInProgressPossible = true;
    private volatile boolean hasNodeWithUnknownVersion = false;
    final Supplier<ExpiringMemoizingSupplier.ReturnValue<CassandraVersion>> upgradeFromVersionSupplier = () -> {
        if (!this.upgradeInProgressPossible) {
            return new ExpiringMemoizingSupplier.Memoized<Object>(null);
        }
        CassandraVersion minVersion = SystemKeyspace.CURRENT_VERSION;
        if (!this.isEnabled() || Gossiper.isLoneNode(this.endpointStateMap)) {
            return new ExpiringMemoizingSupplier.NotMemoized<CassandraVersion>(minVersion);
        }
        this.hasNodeWithUnknownVersion = false;
        for (Map.Entry entry : this.endpointStateMap.entrySet()) {
            CassandraVersion version = this.getReleaseVersion((InetAddressAndPort)entry.getKey());
            if (this.isDeadState((EndpointState)entry.getValue())) continue;
            if (version == null) {
                this.hasNodeWithUnknownVersion = true;
                continue;
            }
            if (version.compareTo(minVersion) >= 0) continue;
            minVersion = version;
        }
        if (minVersion.compareTo(SystemKeyspace.CURRENT_VERSION) < 0) {
            return new ExpiringMemoizingSupplier.Memoized<CassandraVersion>(minVersion);
        }
        if (this.hasNodeWithUnknownVersion) {
            return new ExpiringMemoizingSupplier.NotMemoized<CassandraVersion>(minVersion);
        }
        this.upgradeInProgressPossible = false;
        return new ExpiringMemoizingSupplier.Memoized<Object>(null);
    };
    private final Supplier<CassandraVersion> upgradeFromVersionMemoized = ExpiringMemoizingSupplier.memoizeWithExpiration(this.upgradeFromVersionSupplier, 1L, TimeUnit.MINUTES);
    private static final boolean disableThreadValidation;
    private final RecomputingSupplier<CassandraVersion> minVersionSupplier = new RecomputingSupplier<CassandraVersion>(this::computeMinVersion, executor);

    public void clearUnsafe() {
        this.unreachableEndpoints.clear();
        this.liveEndpoints.clear();
        this.justRemovedEndpoints.clear();
        this.expireTimeEndpointMap.clear();
        this.endpointStateMap.clear();
        this.endpointShadowStateMap.clear();
        this.seedsInShadowRound.clear();
    }

    private static boolean isLoneNode(Map<InetAddressAndPort, EndpointState> epStates) {
        return epStates.isEmpty() || epStates.keySet().equals(Collections.singleton(FBUtilities.getBroadcastAddressAndPort()));
    }

    @VisibleForTesting
    public void expireUpgradeFromVersion() {
        this.upgradeInProgressPossible = true;
        ((ExpiringMemoizingSupplier)this.upgradeFromVersionMemoized).expire();
    }

    private static long getVeryLongTime() {
        String newVLT = System.getProperty("cassandra.very_long_time_ms");
        if (newVLT != null) {
            logger.info("Overriding aVeryLongTime to {}ms", (Object)newVLT);
            return Long.parseLong(newVLT);
        }
        return 259200000L;
    }

    private static long getFailedBootstrapTimeout() {
        String newtimeout = CassandraRelevantProperties.FAILED_BOOTSTRAP_TIMEOUT.getString();
        if (newtimeout != null) {
            long longValue = Long.parseLong(newtimeout);
            if (longValue == -1L) {
                longValue = Long.MAX_VALUE;
            }
            logger.info("Overriding FAILED_BOOTSTRAP_TIMEOUT to {}ms", (Object)longValue);
            return longValue;
        }
        return FAT_CLIENT_TIMEOUT * 2L;
    }

    private static boolean isInGossipStage() {
        return ((JMXEnabledSingleThreadExecutor)Stage.GOSSIP.executor()).isExecutedBy(Thread.currentThread());
    }

    private static void checkProperThreadForStateMutation() {
        if (disableThreadValidation || Gossiper.isInGossipStage()) {
            return;
        }
        IllegalStateException e = new IllegalStateException("Attempting gossip state mutation from illegal thread: " + Thread.currentThread().getName());
        if (DatabaseDescriptor.strictRuntimeChecks()) {
            throw e;
        }
        noSpamLogger.getStatement(Throwables.getStackTraceAsString((Throwable)e)).error(e.getMessage(), e);
    }

    @VisibleForTesting
    public Gossiper(boolean registerJmx) {
        FailureDetector.instance.registerFailureDetectionEventListener(this);
        if (registerJmx) {
            MBeanWrapper.instance.registerMBean((Object)this, MBEAN_NAME);
        }
        this.subscribers.add(new IEndpointStateChangeSubscriber(){

            @Override
            public void onJoin(InetAddressAndPort endpoint, EndpointState state) {
                this.maybeRecompute(state);
            }

            @Override
            public void onAlive(InetAddressAndPort endpoint, EndpointState state) {
                this.maybeRecompute(state);
            }

            private void maybeRecompute(EndpointState state) {
                if (state.getApplicationState(ApplicationState.RELEASE_VERSION) != null) {
                    Gossiper.this.minVersionSupplier.recompute();
                }
            }

            @Override
            public void onChange(InetAddressAndPort endpoint, ApplicationState state, VersionedValue value) {
                if (state == ApplicationState.RELEASE_VERSION) {
                    Gossiper.this.minVersionSupplier.recompute();
                }
            }
        });
    }

    public void setLastProcessedMessageAt(long timeInMillis) {
        this.lastProcessedMessageAt = timeInMillis;
    }

    public boolean seenAnySeed() {
        for (Map.Entry entry : this.endpointStateMap.entrySet()) {
            if (this.seeds.contains(entry.getKey())) {
                return true;
            }
            try {
                VersionedValue internalIp = ((EndpointState)entry.getValue()).getApplicationState(ApplicationState.INTERNAL_IP);
                VersionedValue internalIpAndPort = ((EndpointState)entry.getValue()).getApplicationState(ApplicationState.INTERNAL_ADDRESS_AND_PORT);
                InetAddressAndPort endpoint = null;
                if (internalIpAndPort != null) {
                    endpoint = InetAddressAndPort.getByName(internalIpAndPort.value);
                } else if (internalIp != null) {
                    endpoint = InetAddressAndPort.getByName(internalIp.value);
                }
                if (endpoint == null || !this.seeds.contains(endpoint)) continue;
                return true;
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public void register(IEndpointStateChangeSubscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    public void unregister(IEndpointStateChangeSubscriber subscriber) {
        this.subscribers.remove(subscriber);
    }

    public Set<InetAddressAndPort> getLiveMembers() {
        HashSet<InetAddressAndPort> liveMembers = new HashSet<InetAddressAndPort>(this.liveEndpoints);
        if (!liveMembers.contains(FBUtilities.getBroadcastAddressAndPort())) {
            liveMembers.add(FBUtilities.getBroadcastAddressAndPort());
        }
        return liveMembers;
    }

    public Set<InetAddressAndPort> getLiveTokenOwners() {
        return StorageService.instance.getLiveRingMembers(true);
    }

    public Set<InetAddressAndPort> getUnreachableMembers() {
        return this.unreachableEndpoints.keySet();
    }

    public Set<InetAddressAndPort> getUnreachableTokenOwners() {
        HashSet<InetAddressAndPort> tokenOwners = new HashSet<InetAddressAndPort>();
        for (InetAddressAndPort endpoint : this.unreachableEndpoints.keySet()) {
            if (!StorageService.instance.getTokenMetadata().isMember(endpoint)) continue;
            tokenOwners.add(endpoint);
        }
        return tokenOwners;
    }

    public long getEndpointDowntime(InetAddressAndPort ep) {
        Long downtime = this.unreachableEndpoints.get(ep);
        if (downtime != null) {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - downtime);
        }
        return 0L;
    }

    private boolean isShutdown(InetAddressAndPort endpoint) {
        EndpointState epState = (EndpointState)this.endpointStateMap.get(endpoint);
        if (epState == null) {
            return false;
        }
        VersionedValue versionedValue = epState.getApplicationState(ApplicationState.STATUS_WITH_PORT);
        if (versionedValue == null && (versionedValue = epState.getApplicationState(ApplicationState.STATUS)) == null) {
            return false;
        }
        String value = versionedValue.value;
        String[] pieces = value.split(VersionedValue.DELIMITER_STR, -1);
        assert (pieces.length > 0);
        String state = pieces[0];
        return state.equals("shutdown");
    }

    public static void runInGossipStageBlocking(Runnable runnable) {
        if (Gossiper.isInGossipStage()) {
            runnable.run();
            return;
        }
        ListenableFutureTask task = ListenableFutureTask.create((Runnable)runnable, null);
        Stage.GOSSIP.execute((Runnable)task);
        try {
            task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void convict(InetAddressAndPort endpoint, double phi) {
        Gossiper.runInGossipStageBlocking(() -> {
            EndpointState epState = (EndpointState)this.endpointStateMap.get(endpoint);
            if (epState == null) {
                return;
            }
            if (!epState.isAlive()) {
                return;
            }
            logger.debug("Convicting {} with status {} - alive {}", new Object[]{endpoint, Gossiper.getGossipStatus(epState), epState.isAlive()});
            if (this.isShutdown(endpoint)) {
                this.markAsShutdown(endpoint);
            } else {
                this.markDead(endpoint, epState);
            }
            GossiperDiagnostics.convicted(this, endpoint, phi);
        });
    }

    protected void markAsShutdown(InetAddressAndPort endpoint) {
        Gossiper.checkProperThreadForStateMutation();
        EndpointState epState = (EndpointState)this.endpointStateMap.get(endpoint);
        if (epState == null || epState.isStateEmpty()) {
            return;
        }
        VersionedValue shutdown = StorageService.instance.valueFactory.shutdown(true);
        epState.addApplicationState(ApplicationState.STATUS_WITH_PORT, shutdown);
        epState.addApplicationState(ApplicationState.STATUS, StorageService.instance.valueFactory.shutdown(true));
        epState.addApplicationState(ApplicationState.RPC_READY, StorageService.instance.valueFactory.rpcReady(false));
        epState.forceHighestPossibleVersionUnsafe();
        this.markDead(endpoint, epState);
        FailureDetector.instance.forceConviction(endpoint);
        GossiperDiagnostics.markedAsShutdown(this, endpoint);
        for (IEndpointStateChangeSubscriber subscriber : this.subscribers) {
            subscriber.onChange(endpoint, ApplicationState.STATUS_WITH_PORT, shutdown);
        }
        logger.debug("Marked {} as shutdown", (Object)endpoint);
    }

    int getMaxEndpointStateVersion(EndpointState epState) {
        int maxVersion = epState.getHeartBeatState().getHeartBeatVersion();
        for (Map.Entry<ApplicationState, VersionedValue> state : epState.states()) {
            maxVersion = Math.max(maxVersion, state.getValue().version);
        }
        return maxVersion;
    }

    private void evictFromMembership(InetAddressAndPort endpoint) {
        Gossiper.checkProperThreadForStateMutation();
        this.unreachableEndpoints.remove(endpoint);
        this.endpointStateMap.remove(endpoint);
        this.expireTimeEndpointMap.remove(endpoint);
        FailureDetector.instance.remove(endpoint);
        this.quarantineEndpoint(endpoint);
        if (logger.isDebugEnabled()) {
            logger.debug("evicting {} from gossip", (Object)endpoint);
        }
        GossiperDiagnostics.evictedFromMembership(this, endpoint);
    }

    public void removeEndpoint(InetAddressAndPort endpoint) {
        Gossiper.checkProperThreadForStateMutation();
        for (IEndpointStateChangeSubscriber subscriber : this.subscribers) {
            subscriber.onRemove(endpoint);
        }
        if (this.seeds.contains(endpoint)) {
            this.buildSeedsList();
            this.seeds.remove(endpoint);
            logger.info("removed {} from seeds, updated seeds list = {}", (Object)endpoint, this.seeds);
            if (this.seeds.isEmpty()) {
                logger.warn("Seeds list is now empty!");
            }
        }
        this.liveEndpoints.remove(endpoint);
        this.unreachableEndpoints.remove(endpoint);
        MessagingService.instance().versions.reset(endpoint);
        this.quarantineEndpoint(endpoint);
        MessagingService.instance().closeOutbound(endpoint);
        MessagingService.instance().removeInbound(endpoint);
        logger.debug("removing endpoint {}", (Object)endpoint);
        GossiperDiagnostics.removedEndpoint(this, endpoint);
    }

    private void quarantineEndpoint(InetAddressAndPort endpoint) {
        this.quarantineEndpoint(endpoint, System.currentTimeMillis());
    }

    private void quarantineEndpoint(InetAddressAndPort endpoint, long quarantineExpiration) {
        this.justRemovedEndpoints.put(endpoint, quarantineExpiration);
        GossiperDiagnostics.quarantinedEndpoint(this, endpoint, quarantineExpiration);
    }

    public void replacementQuarantine(InetAddressAndPort endpoint) {
        logger.debug("");
        this.quarantineEndpoint(endpoint, System.currentTimeMillis() + (long)QUARANTINE_DELAY);
        GossiperDiagnostics.replacementQuarantine(this, endpoint);
    }

    public void replacedEndpoint(InetAddressAndPort endpoint) {
        Gossiper.checkProperThreadForStateMutation();
        this.removeEndpoint(endpoint);
        this.evictFromMembership(endpoint);
        this.replacementQuarantine(endpoint);
        GossiperDiagnostics.replacedEndpoint(this, endpoint);
    }

    private void makeGossipDigest(List<GossipDigest> gDigests) {
        for (Map.Entry entry : this.endpointStateMap.entrySet()) {
            int maxVersion;
            int generation;
            EndpointState epState = (EndpointState)entry.getValue();
            if (epState != null) {
                generation = epState.getHeartBeatState().getGeneration();
                maxVersion = this.getMaxEndpointStateVersion(epState);
            } else {
                generation = 0;
                maxVersion = 0;
            }
            gDigests.add(new GossipDigest((InetAddressAndPort)entry.getKey(), generation, maxVersion));
        }
        if (logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (GossipDigest gDigest : gDigests) {
                sb.append(gDigest);
                sb.append(' ');
            }
            logger.trace("Gossip Digests are : {}", (Object)sb);
        }
    }

    public void advertiseRemoving(InetAddressAndPort endpoint, UUID hostId, UUID localHostId) {
        EndpointState epState = (EndpointState)this.endpointStateMap.get(endpoint);
        int generation = epState.getHeartBeatState().getGeneration();
        logger.info("Removing host: {}", (Object)hostId);
        logger.info("Sleeping for {}ms to ensure {} does not change", (Object)StorageService.RING_DELAY, (Object)endpoint);
        Uninterruptibles.sleepUninterruptibly((long)StorageService.RING_DELAY, (TimeUnit)TimeUnit.MILLISECONDS);
        epState = (EndpointState)this.endpointStateMap.get(endpoint);
        if (epState.getHeartBeatState().getGeneration() != generation) {
            throw new RuntimeException("Endpoint " + endpoint + " generation changed while trying to remove it");
        }
        logger.info("Advertising removal for {}", (Object)endpoint);
        epState.updateTimestamp();
        epState.forceNewerGenerationUnsafe();
        EnumMap<ApplicationState, VersionedValue> states = new EnumMap<ApplicationState, VersionedValue>(ApplicationState.class);
        states.put(ApplicationState.STATUS_WITH_PORT, StorageService.instance.valueFactory.removingNonlocal(hostId));
        states.put(ApplicationState.STATUS, StorageService.instance.valueFactory.removingNonlocal(hostId));
        states.put(ApplicationState.REMOVAL_COORDINATOR, StorageService.instance.valueFactory.removalCoordinator(localHostId));
        epState.addApplicationStates(states);
        this.endpointStateMap.put(endpoint, epState);
    }

    public void advertiseTokenRemoved(InetAddressAndPort endpoint, UUID hostId) {
        EndpointState epState = (EndpointState)this.endpointStateMap.get(endpoint);
        epState.updateTimestamp();
        epState.forceNewerGenerationUnsafe();
        long expireTime = Gossiper.computeExpireTime();
        epState.addApplicationState(ApplicationState.STATUS_WITH_PORT, StorageService.instance.valueFactory.removedNonlocal(hostId, expireTime));
        epState.addApplicationState(ApplicationState.STATUS, StorageService.instance.valueFactory.removedNonlocal(hostId, expireTime));
        logger.info("Completing removal of {}", (Object)endpoint);
        this.addExpireTimeForEndpoint(endpoint, expireTime);
        this.endpointStateMap.put(endpoint, epState);
        Uninterruptibles.sleepUninterruptibly((long)2000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Override
    public void unsafeAssassinateEndpoint(String address) throws UnknownHostException {
        logger.warn("Gossiper.unsafeAssassinateEndpoint is deprecated and will be removed in the next release; use assassinateEndpoint instead");
        this.assassinateEndpoint(address);
    }

    @Override
    public void assassinateEndpoint(String address) throws UnknownHostException {
        InetAddressAndPort endpoint = InetAddressAndPort.getByName(address);
        Gossiper.runInGossipStageBlocking(() -> {
            EndpointState epState = (EndpointState)this.endpointStateMap.get(endpoint);
            logger.warn("Assassinating {} via gossip", (Object)endpoint);
            if (epState == null) {
                epState = new EndpointState(new HeartBeatState((int)((System.currentTimeMillis() + 60000L) / 1000L), 9999));
            } else {
                int generation = epState.getHeartBeatState().getGeneration();
                int heartbeat = epState.getHeartBeatState().getHeartBeatVersion();
                logger.info("Sleeping for {}ms to ensure {} does not change", (Object)StorageService.RING_DELAY, (Object)endpoint);
                Uninterruptibles.sleepUninterruptibly((long)StorageService.RING_DELAY, (TimeUnit)TimeUnit.MILLISECONDS);
                EndpointState newState = (EndpointState)this.endpointStateMap.get(endpoint);
                if (newState == null) {
                    logger.warn("Endpoint {} disappeared while trying to assassinate, continuing anyway", (Object)endpoint);
                } else {
                    if (newState.getHeartBeatState().getGeneration() != generation) {
                        throw new RuntimeException("Endpoint still alive: " + endpoint + " generation changed while trying to assassinate it");
                    }
                    if (newState.getHeartBeatState().getHeartBeatVersion() != heartbeat) {
                        throw new RuntimeException("Endpoint still alive: " + endpoint + " heartbeat changed while trying to assassinate it");
                    }
                }
                epState.updateTimestamp();
                epState.forceNewerGenerationUnsafe();
            }
            Collection<Token> tokens = null;
            try {
                tokens = StorageService.instance.getTokenMetadata().getTokens(endpoint);
            }
            catch (Throwable th) {
                JVMStabilityInspector.inspectThrowable(th);
            }
            if (tokens == null || tokens.isEmpty()) {
                logger.warn("Trying to assassinate an endpoint {} that does not have any tokens assigned. This should not have happened, trying to continue with a random token.", (Object)address);
                tokens = Collections.singletonList(StorageService.instance.getTokenMetadata().partitioner.getRandomToken());
            }
            long expireTime = Gossiper.computeExpireTime();
            epState.addApplicationState(ApplicationState.STATUS_WITH_PORT, StorageService.instance.valueFactory.left(tokens, expireTime));
            epState.addApplicationState(ApplicationState.STATUS, StorageService.instance.valueFactory.left(tokens, Gossiper.computeExpireTime()));
            this.handleMajorStateChange(endpoint, epState);
            Uninterruptibles.sleepUninterruptibly((long)4000L, (TimeUnit)TimeUnit.MILLISECONDS);
            logger.warn("Finished assassinating {}", (Object)endpoint);
        });
    }

    public boolean isKnownEndpoint(InetAddressAndPort endpoint) {
        return this.endpointStateMap.containsKey(endpoint);
    }

    public int getCurrentGenerationNumber(InetAddressAndPort endpoint) {
        return ((EndpointState)this.endpointStateMap.get(endpoint)).getHeartBeatState().getGeneration();
    }

    private boolean sendGossip(Message<GossipDigestSyn> message, Set<InetAddressAndPort> epSet) {
        ImmutableList endpoints = ImmutableList.copyOf(epSet);
        int size = endpoints.size();
        if (size < 1) {
            return false;
        }
        int index = size == 1 ? 0 : this.random.nextInt(size);
        InetAddressAndPort to = (InetAddressAndPort)endpoints.get(index);
        if (logger.isTraceEnabled()) {
            logger.trace("Sending a GossipDigestSyn to {} ...", (Object)to);
        }
        if (this.firstSynSendAt == 0L) {
            this.firstSynSendAt = System.nanoTime();
        }
        MessagingService.instance().send(message, to);
        boolean isSeed = this.seeds.contains(to);
        GossiperDiagnostics.sendGossipDigestSyn(this, to);
        return isSeed;
    }

    private boolean doGossipToLiveMember(Message<GossipDigestSyn> message) {
        int size = this.liveEndpoints.size();
        if (size == 0) {
            return false;
        }
        return this.sendGossip(message, this.liveEndpoints);
    }

    private void maybeGossipToUnreachableMember(Message<GossipDigestSyn> message) {
        double liveEndpointCount = this.liveEndpoints.size();
        double unreachableEndpointCount = this.unreachableEndpoints.size();
        if (unreachableEndpointCount > 0.0) {
            double prob = unreachableEndpointCount / (liveEndpointCount + 1.0);
            double randDbl = this.random.nextDouble();
            if (randDbl < prob) {
                this.sendGossip(message, Sets.filter(this.unreachableEndpoints.keySet(), ep -> !this.isDeadState(this.getEndpointStateMap().get(ep))));
            }
        }
    }

    private void maybeGossipToSeed(Message<GossipDigestSyn> prod) {
        int size = this.seeds.size();
        if (size > 0) {
            if (size == 1 && this.seeds.contains(FBUtilities.getBroadcastAddressAndPort())) {
                return;
            }
            if (this.liveEndpoints.size() == 0) {
                this.sendGossip(prod, this.seeds);
            } else {
                double probability = (double)this.seeds.size() / (double)(this.liveEndpoints.size() + this.unreachableEndpoints.size());
                double randDbl = this.random.nextDouble();
                if (randDbl <= probability) {
                    this.sendGossip(prod, this.seeds);
                }
            }
        }
    }

    public boolean isGossipOnlyMember(InetAddressAndPort endpoint) {
        EndpointState epState = (EndpointState)this.endpointStateMap.get(endpoint);
        if (epState == null) {
            return false;
        }
        return !this.isDeadState(epState) && !StorageService.instance.getTokenMetadata().isMember(endpoint);
    }

    public boolean isSafeForStartup(InetAddressAndPort endpoint, UUID localHostUUID, boolean isBootstrapping, Map<InetAddressAndPort, EndpointState> epStates) {
        EndpointState epState = epStates.get(endpoint);
        if (epState == null) {
            return true;
        }
        String status = Gossiper.getGossipStatus(epState);
        if (status.equals("hibernate") && !SystemKeyspace.bootstrapComplete()) {
            logger.warn("A node with the same IP in hibernate status was detected. Was a replacement already attempted?");
            return false;
        }
        if (this.isDeadState(epState)) {
            return true;
        }
        if (isBootstrapping) {
            ArrayList<String> unsafeStatuses = new ArrayList<String>(){
                {
                    this.add("");
                    this.add("NORMAL");
                    this.add("shutdown");
                }
            };
            return !unsafeStatuses.contains(status);
        }
        VersionedValue previous = epState.getApplicationState(ApplicationState.HOST_ID);
        return UUID.fromString(previous.value).equals(localHostUUID);
    }

    @VisibleForTesting
    void doStatusCheck() {
        if (logger.isTraceEnabled()) {
            logger.trace("Performing status check ...");
        }
        long now = System.currentTimeMillis();
        long nowNano = System.nanoTime();
        long pending = ((Integer)((JMXEnabledThreadPoolExecutor)Stage.GOSSIP.executor()).metrics.pendingTasks.getValue()).intValue();
        if (pending > 0L && this.lastProcessedMessageAt < now - 1000L) {
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            if (this.lastProcessedMessageAt < now - 1000L) {
                logger.warn("Gossip stage has {} pending tasks; skipping status check (no nodes will be marked down)", (Object)pending);
                return;
            }
        }
        Set eps = this.endpointStateMap.keySet();
        for (InetAddressAndPort inetAddressAndPort : eps) {
            if (inetAddressAndPort.equals(FBUtilities.getBroadcastAddressAndPort())) continue;
            FailureDetector.instance.interpret(inetAddressAndPort);
            EndpointState epState = (EndpointState)this.endpointStateMap.get(inetAddressAndPort);
            if (epState == null) continue;
            long fatClientTimeout = Gossiper.getFatClientTimeoutForEndpoint(epState);
            if (this.isGossipOnlyMember(inetAddressAndPort) && !this.justRemovedEndpoints.containsKey(inetAddressAndPort) && TimeUnit.NANOSECONDS.toMillis(nowNano - epState.getUpdateTimestamp()) > fatClientTimeout) {
                logger.info("FatClient {} has been silent for {}ms, removing from gossip", (Object)inetAddressAndPort, (Object)fatClientTimeout);
                Gossiper.runInGossipStageBlocking(() -> {
                    if (!this.isGossipOnlyMember(endpoint)) {
                        logger.info("Race condition marking {} as a FatClient; ignoring", (Object)endpoint);
                        return;
                    }
                    this.removeEndpoint(endpoint);
                    this.evictFromMembership(endpoint);
                });
            }
            long expireTime = this.getExpireTimeForEndpoint(inetAddressAndPort);
            if (epState.isAlive() || now <= expireTime || StorageService.instance.getTokenMetadata().isMember(inetAddressAndPort)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("time is expiring for endpoint : {} ({})", (Object)inetAddressAndPort, (Object)expireTime);
            }
            Gossiper.runInGossipStageBlocking(() -> this.evictFromMembership(endpoint));
        }
        if (!this.justRemovedEndpoints.isEmpty()) {
            for (Map.Entry entry : this.justRemovedEndpoints.entrySet()) {
                if (now - (Long)entry.getValue() <= (long)QUARANTINE_DELAY) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("{} elapsed, {} gossip quarantine over", (Object)QUARANTINE_DELAY, entry.getKey());
                }
                this.justRemovedEndpoints.remove(entry.getKey());
            }
        }
    }

    private static long getFatClientTimeoutForEndpoint(EndpointState epState) {
        return Gossiper.isBootstrappingState(epState) ? FAILED_BOOTSTRAP_TIMEOUT : FAT_CLIENT_TIMEOUT;
    }

    private static boolean isBootstrappingState(EndpointState epState) {
        String status = Gossiper.getGossipStatus(epState);
        if (status.isEmpty()) {
            return false;
        }
        return VersionedValue.BOOTSTRAPPING_STATUS.contains(status);
    }

    protected long getExpireTimeForEndpoint(InetAddressAndPort endpoint) {
        Long storedTime = this.expireTimeEndpointMap.get(endpoint);
        return storedTime == null ? Gossiper.computeExpireTime() : storedTime;
    }

    @VisibleForTesting
    public boolean inJustRemovedEndpoints(InetAddressAndPort ep) {
        return this.justRemovedEndpoints.containsKey(ep);
    }

    public EndpointState getEndpointStateForEndpoint(InetAddressAndPort ep) {
        return (EndpointState)this.endpointStateMap.get(ep);
    }

    public ImmutableSet<InetAddressAndPort> getEndpoints() {
        return ImmutableSet.copyOf(this.endpointStateMap.keySet());
    }

    public int getEndpointCount() {
        return this.endpointStateMap.size();
    }

    Map<InetAddressAndPort, EndpointState> getEndpointStateMap() {
        return ImmutableMap.copyOf(this.endpointStateMap);
    }

    Map<InetAddressAndPort, Long> getJustRemovedEndpoints() {
        return ImmutableMap.copyOf(this.justRemovedEndpoints);
    }

    Map<InetAddressAndPort, Long> getUnreachableEndpoints() {
        return ImmutableMap.copyOf(this.unreachableEndpoints);
    }

    Set<InetAddressAndPort> getSeedsInShadowRound() {
        return ImmutableSet.copyOf(this.seedsInShadowRound);
    }

    long getLastProcessedMessageAt() {
        return this.lastProcessedMessageAt;
    }

    public UUID getHostId(InetAddressAndPort endpoint) {
        return this.getHostId(endpoint, this.endpointStateMap);
    }

    public UUID getHostId(InetAddressAndPort endpoint, Map<InetAddressAndPort, EndpointState> epStates) {
        return UUID.fromString(epStates.get((Object)endpoint).getApplicationState((ApplicationState)ApplicationState.HOST_ID).value);
    }

    public String getApplicationState(InetAddressAndPort endpoint, ApplicationState state) {
        EndpointState epState = (EndpointState)this.endpointStateMap.get(endpoint);
        if (epState == null) {
            return null;
        }
        VersionedValue value = epState.getApplicationState(state);
        return value == null ? null : value.value;
    }

    EndpointState getStateForVersionBiggerThan(InetAddressAndPort forEndpoint, int version) {
        EndpointState epState = (EndpointState)this.endpointStateMap.get(forEndpoint);
        EndpointState reqdEndpointState = null;
        if (epState != null) {
            HeartBeatState heartBeatState = epState.getHeartBeatState();
            int localHbGeneration = heartBeatState.getGeneration();
            int localHbVersion = heartBeatState.getHeartBeatVersion();
            if (localHbVersion > version) {
                reqdEndpointState = new EndpointState(new HeartBeatState(localHbGeneration, localHbVersion));
                if (logger.isTraceEnabled()) {
                    logger.trace("local heartbeat version {} greater than {} for {}", new Object[]{localHbVersion, version, forEndpoint});
                }
            }
            EnumMap<ApplicationState, VersionedValue> states = new EnumMap<ApplicationState, VersionedValue>(ApplicationState.class);
            for (Map.Entry<ApplicationState, VersionedValue> entry : epState.states()) {
                VersionedValue value = entry.getValue();
                if (value.version <= version) continue;
                if (reqdEndpointState == null) {
                    reqdEndpointState = new EndpointState(new HeartBeatState(localHbGeneration, localHbVersion));
                }
                ApplicationState key = entry.getKey();
                if (logger.isTraceEnabled()) {
                    logger.trace("Adding state {}: {}", (Object)key, (Object)value.value);
                }
                states.put(key, value);
            }
            if (reqdEndpointState != null) {
                reqdEndpointState.addApplicationStates(states);
            }
        }
        return reqdEndpointState;
    }

    public int compareEndpointStartup(InetAddressAndPort addr1, InetAddressAndPort addr2) {
        EndpointState ep1 = this.getEndpointStateForEndpoint(addr1);
        EndpointState ep2 = this.getEndpointStateForEndpoint(addr2);
        assert (ep1 != null && ep2 != null);
        return ep1.getHeartBeatState().getGeneration() - ep2.getHeartBeatState().getGeneration();
    }

    void notifyFailureDetector(Map<InetAddressAndPort, EndpointState> remoteEpStateMap) {
        for (Map.Entry<InetAddressAndPort, EndpointState> entry : remoteEpStateMap.entrySet()) {
            this.notifyFailureDetector(entry.getKey(), entry.getValue());
        }
    }

    void notifyFailureDetector(InetAddressAndPort endpoint, EndpointState remoteEndpointState) {
        EndpointState localEndpointState = (EndpointState)this.endpointStateMap.get(endpoint);
        if (localEndpointState != null) {
            IFailureDetector fd = FailureDetector.instance;
            int localGeneration = localEndpointState.getHeartBeatState().getGeneration();
            int remoteGeneration = remoteEndpointState.getHeartBeatState().getGeneration();
            if (remoteGeneration > localGeneration) {
                localEndpointState.updateTimestamp();
                if (!localEndpointState.isAlive()) {
                    logger.debug("Clearing interval times for {} due to generation change", (Object)endpoint);
                    fd.remove(endpoint);
                }
                fd.report(endpoint);
                return;
            }
            if (remoteGeneration == localGeneration) {
                int localVersion = this.getMaxEndpointStateVersion(localEndpointState);
                int remoteVersion = remoteEndpointState.getHeartBeatState().getHeartBeatVersion();
                if (remoteVersion > localVersion) {
                    localEndpointState.updateTimestamp();
                    fd.report(endpoint);
                }
            }
        }
    }

    private void markAlive(InetAddressAndPort addr, EndpointState localState) {
        localState.markDead();
        Message<NoPayload> echoMessage = Message.out(Verb.ECHO_REQ, NoPayload.noPayload);
        logger.trace("Sending ECHO_REQ to {}", (Object)addr);
        RequestCallback echoHandler = msg -> Gossiper.runInGossipStageBlocking(() -> this.realMarkAlive(addr, localState));
        MessagingService.instance().sendWithCallback(echoMessage, addr, echoHandler);
        GossiperDiagnostics.markedAlive(this, addr, localState);
    }

    @VisibleForTesting
    public void realMarkAlive(InetAddressAndPort addr, EndpointState localState) {
        Gossiper.checkProperThreadForStateMutation();
        if (logger.isTraceEnabled()) {
            logger.trace("marking as alive {}", (Object)addr);
        }
        localState.markAlive();
        localState.updateTimestamp();
        this.liveEndpoints.add(addr);
        this.unreachableEndpoints.remove(addr);
        this.expireTimeEndpointMap.remove(addr);
        logger.debug("removing expire time for endpoint : {}", (Object)addr);
        logger.info("InetAddress {} is now UP", (Object)addr);
        for (IEndpointStateChangeSubscriber subscriber : this.subscribers) {
            subscriber.onAlive(addr, localState);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Notified {}", this.subscribers);
        }
        GossiperDiagnostics.realMarkedAlive(this, addr, localState);
    }

    @VisibleForTesting
    public void markDead(InetAddressAndPort addr, EndpointState localState) {
        Gossiper.checkProperThreadForStateMutation();
        if (logger.isTraceEnabled()) {
            logger.trace("marking as down {}", (Object)addr);
        }
        this.silentlyMarkDead(addr, localState);
        logger.info("InetAddress {} is now DOWN", (Object)addr);
        for (IEndpointStateChangeSubscriber subscriber : this.subscribers) {
            subscriber.onDead(addr, localState);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Notified {}", this.subscribers);
        }
        GossiperDiagnostics.markedDead(this, addr, localState);
    }

    private void silentlyMarkDead(InetAddressAndPort addr, EndpointState localState) {
        localState.markDead();
        this.liveEndpoints.remove(addr);
        this.unreachableEndpoints.put(addr, System.nanoTime());
    }

    private void handleMajorStateChange(InetAddressAndPort ep, EndpointState epState) {
        Gossiper.checkProperThreadForStateMutation();
        EndpointState localEpState = (EndpointState)this.endpointStateMap.get(ep);
        if (!this.isDeadState(epState)) {
            if (localEpState != null) {
                logger.info("Node {} has restarted, now UP", (Object)ep);
            } else {
                logger.info("Node {} is now part of the cluster", (Object)ep);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Adding endpoint state for {}", (Object)ep);
        }
        this.endpointStateMap.put(ep, epState);
        if (localEpState != null) {
            for (IEndpointStateChangeSubscriber subscriber : this.subscribers) {
                subscriber.onRestart(ep, localEpState);
            }
        }
        if (!this.isDeadState(epState)) {
            this.markAlive(ep, epState);
        } else {
            logger.debug("Not marking {} alive due to dead state", (Object)ep);
            this.markDead(ep, epState);
        }
        for (IEndpointStateChangeSubscriber subscriber : this.subscribers) {
            subscriber.onJoin(ep, epState);
        }
        if (this.isShutdown(ep)) {
            this.markAsShutdown(ep);
        }
        GossiperDiagnostics.majorStateChangeHandled(this, ep, epState);
    }

    public boolean isAlive(InetAddressAndPort endpoint) {
        EndpointState epState = this.getEndpointStateForEndpoint(endpoint);
        if (epState == null) {
            return false;
        }
        return epState.isAlive() && !this.isDeadState(epState);
    }

    public boolean isDeadState(EndpointState epState) {
        String status = Gossiper.getGossipStatus(epState);
        if (status.isEmpty()) {
            return false;
        }
        return DEAD_STATES.contains(status);
    }

    public boolean isSilentShutdownState(EndpointState epState) {
        String status = Gossiper.getGossipStatus(epState);
        if (status.isEmpty()) {
            return false;
        }
        return SILENT_SHUTDOWN_STATES.contains(status);
    }

    public boolean isAdministrativelyInactiveState(EndpointState epState) {
        String status = Gossiper.getGossipStatus(epState);
        if (status.isEmpty()) {
            return false;
        }
        return ADMINISTRATIVELY_INACTIVE_STATES.contains(status);
    }

    public boolean isAdministrativelyInactiveState(InetAddressAndPort endpoint) {
        EndpointState epState = this.getEndpointStateForEndpoint(endpoint);
        if (epState == null) {
            return true;
        }
        return this.isAdministrativelyInactiveState(epState);
    }

    private static String getGossipStatus(EndpointState epState) {
        if (epState == null) {
            return "";
        }
        VersionedValue versionedValue = epState.getApplicationState(ApplicationState.STATUS_WITH_PORT);
        if (versionedValue == null && (versionedValue = epState.getApplicationState(ApplicationState.STATUS)) == null) {
            return "";
        }
        String value = versionedValue.value;
        String[] pieces = value.split(VersionedValue.DELIMITER_STR, -1);
        assert (pieces.length > 0);
        return pieces[0];
    }

    @VisibleForTesting
    public void applyStateLocally(Map<InetAddressAndPort, EndpointState> epStateMap) {
        Gossiper.checkProperThreadForStateMutation();
        for (Map.Entry<InetAddressAndPort, EndpointState> entry : epStateMap.entrySet()) {
            InetAddressAndPort ep = entry.getKey();
            if (ep.equals(FBUtilities.getBroadcastAddressAndPort()) && !this.isInShadowRound()) continue;
            if (this.justRemovedEndpoints.containsKey(ep)) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Ignoring gossip for {} because it is quarantined", (Object)ep);
                continue;
            }
            EndpointState localEpStatePtr = (EndpointState)this.endpointStateMap.get(ep);
            EndpointState remoteState = entry.getValue();
            if (!this.hasMajorVersion3OrUnknownNodes()) {
                remoteState.removeMajorVersion3LegacyApplicationStates();
            }
            if (localEpStatePtr != null) {
                int localGeneration = localEpStatePtr.getHeartBeatState().getGeneration();
                int remoteGeneration = remoteState.getHeartBeatState().getGeneration();
                long localTime = System.currentTimeMillis() / 1000L;
                if (logger.isTraceEnabled()) {
                    logger.trace("{} local generation {}, remote generation {}", new Object[]{ep, localGeneration, remoteGeneration});
                }
                if ((long)remoteGeneration > localTime + 31536000L) {
                    logger.warn("received an invalid gossip generation for peer {}; local time = {}, received generation = {}", new Object[]{ep, localTime, remoteGeneration});
                    continue;
                }
                if (remoteGeneration > localGeneration) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Updating heartbeat state generation to {} from {} for {}", new Object[]{remoteGeneration, localGeneration, ep});
                    }
                    this.handleMajorStateChange(ep, remoteState);
                    continue;
                }
                if (remoteGeneration == localGeneration) {
                    int localMaxVersion = this.getMaxEndpointStateVersion(localEpStatePtr);
                    int remoteMaxVersion = this.getMaxEndpointStateVersion(remoteState);
                    if (remoteMaxVersion > localMaxVersion) {
                        this.applyNewStates(ep, localEpStatePtr, remoteState);
                    } else if (logger.isTraceEnabled()) {
                        logger.trace("Ignoring remote version {} <= {} for {}", new Object[]{remoteMaxVersion, localMaxVersion, ep});
                    }
                    if (localEpStatePtr.isAlive() || this.isDeadState(localEpStatePtr)) continue;
                    this.markAlive(ep, localEpStatePtr);
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Ignoring remote generation {} < {}", (Object)remoteGeneration, (Object)localGeneration);
                continue;
            }
            FailureDetector.instance.report(ep);
            this.handleMajorStateChange(ep, remoteState);
        }
    }

    private void applyNewStates(InetAddressAndPort addr, EndpointState localState, EndpointState remoteState) {
        int oldVersion = localState.getHeartBeatState().getHeartBeatVersion();
        Set<Map.Entry<ApplicationState, VersionedValue>> updatedStates = remoteState.states().stream().filter(entry -> {
            VersionedValue local = localState.getApplicationState((ApplicationState)((Object)((Object)((Object)entry.getKey()))));
            return local == null || local.version < ((VersionedValue)entry.getValue()).version;
        }).collect(Collectors.toSet());
        if (logger.isTraceEnabled() && updatedStates.size() > 0) {
            for (Map.Entry entry2 : updatedStates) {
                logger.trace("Updating {} state version to {} for {}", new Object[]{((ApplicationState)((Object)entry2.getKey())).toString(), ((VersionedValue)entry2.getValue()).version, addr});
            }
        }
        localState.addApplicationStates(updatedStates, remoteState.getHeartBeatState());
        if (logger.isTraceEnabled()) {
            logger.trace("Updating heartbeat state version to {} from {} for {} ...", new Object[]{localState.getHeartBeatState().getHeartBeatVersion(), oldVersion, addr});
        }
        if (!this.hasMajorVersion3OrUnknownNodes()) {
            localState.removeMajorVersion3LegacyApplicationStates();
        }
        for (Map.Entry entry3 : updatedStates) {
            if (ApplicationState.INTERNAL_IP == entry3.getKey() && localState.containsApplicationState(ApplicationState.INTERNAL_ADDRESS_AND_PORT) || ApplicationState.STATUS == entry3.getKey() && localState.containsApplicationState(ApplicationState.STATUS_WITH_PORT) || ApplicationState.RPC_ADDRESS == entry3.getKey() && localState.containsApplicationState(ApplicationState.NATIVE_ADDRESS_AND_PORT)) continue;
            this.doOnChangeNotifications(addr, (ApplicationState)((Object)entry3.getKey()), (VersionedValue)entry3.getValue());
        }
    }

    private void doBeforeChangeNotifications(InetAddressAndPort addr, EndpointState epState, ApplicationState apState, VersionedValue newValue) {
        for (IEndpointStateChangeSubscriber subscriber : this.subscribers) {
            subscriber.beforeChange(addr, epState, apState, newValue);
        }
    }

    private void doOnChangeNotifications(InetAddressAndPort addr, ApplicationState state, VersionedValue value) {
        for (IEndpointStateChangeSubscriber subscriber : this.subscribers) {
            subscriber.onChange(addr, state, value);
        }
    }

    private void requestAll(GossipDigest gDigest, List<GossipDigest> deltaGossipDigestList, int remoteGeneration) {
        deltaGossipDigestList.add(new GossipDigest(gDigest.getEndpoint(), remoteGeneration, 0));
        if (logger.isTraceEnabled()) {
            logger.trace("requestAll for {}", (Object)gDigest.getEndpoint());
        }
    }

    private void sendAll(GossipDigest gDigest, Map<InetAddressAndPort, EndpointState> deltaEpStateMap, int maxRemoteVersion) {
        EndpointState localEpStatePtr = this.getStateForVersionBiggerThan(gDigest.getEndpoint(), maxRemoteVersion);
        if (localEpStatePtr != null) {
            deltaEpStateMap.put(gDigest.getEndpoint(), localEpStatePtr);
        }
    }

    Map<InetAddressAndPort, EndpointState> examineShadowState() {
        logger.debug("Shadow request received, adding all states");
        HashMap<InetAddressAndPort, EndpointState> map = new HashMap<InetAddressAndPort, EndpointState>();
        for (Map.Entry e : this.endpointStateMap.entrySet()) {
            InetAddressAndPort endpoint = (InetAddressAndPort)e.getKey();
            EndpointState state = new EndpointState((EndpointState)e.getValue());
            if (state.isEmptyWithoutStatus()) {
                Set tokens;
                UUID hostId = SystemKeyspace.loadHostIds().get(endpoint);
                if (null != hostId) {
                    state.addApplicationState(ApplicationState.HOST_ID, StorageService.instance.valueFactory.hostId(hostId));
                }
                if (null != (tokens = SystemKeyspace.loadTokens().get((Object)endpoint)) && !tokens.isEmpty()) {
                    state.addApplicationState(ApplicationState.TOKENS, StorageService.instance.valueFactory.tokens(tokens));
                }
            }
            map.put(endpoint, state);
        }
        return map;
    }

    void examineGossiper(List<GossipDigest> gDigestList, List<GossipDigest> deltaGossipDigestList, Map<InetAddressAndPort, EndpointState> deltaEpStateMap) {
        assert (!gDigestList.isEmpty()) : "examineGossiper called with empty digest list";
        for (GossipDigest gDigest : gDigestList) {
            int remoteGeneration = gDigest.getGeneration();
            int maxRemoteVersion = gDigest.getMaxVersion();
            EndpointState epStatePtr = (EndpointState)this.endpointStateMap.get(gDigest.getEndpoint());
            if (epStatePtr != null) {
                int localGeneration = epStatePtr.getHeartBeatState().getGeneration();
                int maxLocalVersion = this.getMaxEndpointStateVersion(epStatePtr);
                if (remoteGeneration == localGeneration && maxRemoteVersion == maxLocalVersion) continue;
                if (remoteGeneration > localGeneration) {
                    this.requestAll(gDigest, deltaGossipDigestList, remoteGeneration);
                    continue;
                }
                if (remoteGeneration < localGeneration || FBUtilities.getBroadcastAddressAndPort().equals(gDigest.getEndpoint())) {
                    this.sendAll(gDigest, deltaEpStateMap, -1);
                    continue;
                }
                if (remoteGeneration != localGeneration) continue;
                if (maxRemoteVersion > maxLocalVersion) {
                    deltaGossipDigestList.add(new GossipDigest(gDigest.getEndpoint(), remoteGeneration, maxLocalVersion));
                    continue;
                }
                if (maxRemoteVersion >= maxLocalVersion) continue;
                this.sendAll(gDigest, deltaEpStateMap, maxRemoteVersion);
                continue;
            }
            this.requestAll(gDigest, deltaGossipDigestList, remoteGeneration);
        }
    }

    public void start(int generationNumber) {
        this.start(generationNumber, new EnumMap<ApplicationState, VersionedValue>(ApplicationState.class));
    }

    public void start(int generationNbr, Map<ApplicationState, VersionedValue> preloadLocalStates) {
        this.buildSeedsList();
        this.maybeInitializeLocalState(generationNbr);
        EndpointState localState = (EndpointState)this.endpointStateMap.get(FBUtilities.getBroadcastAddressAndPort());
        localState.addApplicationStates(preloadLocalStates);
        this.minVersionSupplier.recompute();
        DatabaseDescriptor.getEndpointSnitch().gossiperStarting();
        if (logger.isTraceEnabled()) {
            logger.trace("gossip started with generation {}", (Object)localState.getHeartBeatState().getGeneration());
        }
        this.scheduledGossipTask = executor.scheduleWithFixedDelay(new GossipTask(), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public synchronized Map<InetAddressAndPort, EndpointState> doShadowRound() {
        return this.doShadowRound(Collections.EMPTY_SET);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Map<InetAddressAndPort, EndpointState> doShadowRound(Set<InetAddressAndPort> peers) {
        this.buildSeedsList();
        if (this.seeds.isEmpty() && peers.isEmpty()) {
            return this.endpointShadowStateMap;
        }
        boolean isSeed = DatabaseDescriptor.getSeeds().contains(FBUtilities.getBroadcastAddressAndPort());
        int shadowRoundDelay = isSeed ? StorageService.RING_DELAY : StorageService.RING_DELAY * 2;
        this.seedsInShadowRound.clear();
        this.endpointShadowStateMap.clear();
        ArrayList<GossipDigest> gDigests = new ArrayList<GossipDigest>();
        GossipDigestSyn digestSynMessage = new GossipDigestSyn(DatabaseDescriptor.getClusterName(), DatabaseDescriptor.getPartitionerName(), gDigests);
        Message<GossipDigestSyn> message = Message.out(Verb.GOSSIP_DIGEST_SYN, digestSynMessage);
        this.inShadowRound = true;
        boolean includePeers = false;
        int slept = 0;
        try {
            do {
                if (slept % 5000 == 0) {
                    logger.trace("Sending shadow round GOSSIP DIGEST SYN to seeds {}", this.seeds);
                    for (InetAddressAndPort seed : this.seeds) {
                        MessagingService.instance().send(message, seed);
                    }
                    if (includePeers) {
                        logger.trace("Sending shadow round GOSSIP DIGEST SYN to known peers {}", peers);
                        for (InetAddressAndPort peer : peers) {
                            MessagingService.instance().send(message, peer);
                        }
                    }
                    includePeers = true;
                }
                Thread.sleep(1000L);
                if (!this.inShadowRound) return ImmutableMap.copyOf(this.endpointShadowStateMap);
            } while ((slept += 1000) <= shadowRoundDelay);
            if (!isSeed) {
                throw new RuntimeException("Unable to gossip with any peers");
            }
            this.inShadowRound = false;
            return ImmutableMap.copyOf(this.endpointShadowStateMap);
        }
        catch (InterruptedException wtf) {
            throw new RuntimeException(wtf);
        }
    }

    @VisibleForTesting
    void buildSeedsList() {
        for (InetAddressAndPort seed : DatabaseDescriptor.getSeeds()) {
            if (seed.equals(FBUtilities.getBroadcastAddressAndPort())) continue;
            this.seeds.add(seed);
        }
    }

    @Override
    public List<String> reloadSeeds() {
        logger.trace("Triggering reload of seed node list");
        HashSet<InetAddressAndPort> tmp = new HashSet<InetAddressAndPort>();
        try {
            for (InetAddressAndPort seed : DatabaseDescriptor.getSeeds()) {
                if (seed.equals(FBUtilities.getBroadcastAddressAndPort())) continue;
                tmp.add(seed);
            }
        }
        catch (Throwable e) {
            JVMStabilityInspector.inspectThrowable(e);
            logger.warn("Error while getting seed node list: {}", (Object)e.getLocalizedMessage());
            return null;
        }
        if (tmp.size() == 0) {
            logger.trace("New seed node list is empty. Not updating seed list.");
            return this.getSeeds();
        }
        if (tmp.equals(this.seeds)) {
            logger.trace("New seed node list matches the existing list.");
            return this.getSeeds();
        }
        this.seeds.addAll(tmp);
        this.seeds.retainAll(tmp);
        logger.trace("New seed node list after reload {}", this.seeds);
        return this.getSeeds();
    }

    @Override
    public List<String> getSeeds() {
        ArrayList<String> seedList = new ArrayList<String>();
        for (InetAddressAndPort seed : this.seeds) {
            seedList.add(seed.toString());
        }
        return seedList;
    }

    public void maybeInitializeLocalState(int generationNbr) {
        HeartBeatState hbState = new HeartBeatState(generationNbr);
        EndpointState localState = new EndpointState(hbState);
        localState.markAlive();
        this.endpointStateMap.putIfAbsent(FBUtilities.getBroadcastAddressAndPort(), localState);
    }

    public void forceNewerGeneration() {
        EndpointState epstate = (EndpointState)this.endpointStateMap.get(FBUtilities.getBroadcastAddressAndPort());
        epstate.forceNewerGenerationUnsafe();
    }

    public void addSavedEndpoint(InetAddressAndPort ep) {
        Gossiper.checkProperThreadForStateMutation();
        if (ep.equals(FBUtilities.getBroadcastAddressAndPort())) {
            logger.debug("Attempt to add self as saved endpoint");
            return;
        }
        EndpointState epState = (EndpointState)this.endpointStateMap.get(ep);
        if (epState != null) {
            logger.debug("not replacing a previous epState for {}, but reusing it: {}", (Object)ep, (Object)epState);
            epState.unsafeSetEmptyHeartBeatState();
        } else {
            epState = new EndpointState(HeartBeatState.empty());
            logger.info("Adding {} as there was no previous epState; new state is {}", (Object)ep, (Object)epState);
        }
        epState.markDead();
        this.endpointStateMap.put(ep, epState);
        this.silentlyMarkDead(ep, epState);
        if (logger.isTraceEnabled()) {
            logger.trace("Adding saved endpoint {} {}", (Object)ep, (Object)epState.getHeartBeatState().getGeneration());
        }
    }

    private void addLocalApplicationStateInternal(ApplicationState state, VersionedValue value) {
        assert (taskLock.isHeldByCurrentThread());
        InetAddressAndPort epAddr = FBUtilities.getBroadcastAddressAndPort();
        EndpointState epState = (EndpointState)this.endpointStateMap.get(epAddr);
        assert (epState != null) : "Can't find endpoint state for " + epAddr;
        this.doBeforeChangeNotifications(epAddr, epState, state, value);
        value = StorageService.instance.valueFactory.cloneWithHigherVersion(value);
        epState.addApplicationState(state, value);
        this.doOnChangeNotifications(epAddr, state, value);
    }

    public void addLocalApplicationState(ApplicationState applicationState, VersionedValue value) {
        this.addLocalApplicationStates(Arrays.asList(Pair.create(applicationState, value)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalApplicationStates(List<Pair<ApplicationState, VersionedValue>> states) {
        taskLock.lock();
        try {
            for (Pair<ApplicationState, VersionedValue> pair : states) {
                this.addLocalApplicationStateInternal((ApplicationState)((Object)pair.left), (VersionedValue)pair.right);
            }
        }
        finally {
            taskLock.unlock();
        }
    }

    public void stop() {
        EndpointState mystate = (EndpointState)this.endpointStateMap.get(FBUtilities.getBroadcastAddressAndPort());
        if (mystate != null && !this.isSilentShutdownState(mystate) && StorageService.instance.isJoined()) {
            logger.info("Announcing shutdown");
            this.addLocalApplicationState(ApplicationState.STATUS_WITH_PORT, StorageService.instance.valueFactory.shutdown(true));
            this.addLocalApplicationState(ApplicationState.STATUS, StorageService.instance.valueFactory.shutdown(true));
            Message<NoPayload> message = Message.out(Verb.GOSSIP_SHUTDOWN, NoPayload.noPayload);
            for (InetAddressAndPort ep : this.liveEndpoints) {
                MessagingService.instance().send(message, ep);
            }
            Uninterruptibles.sleepUninterruptibly((long)Integer.getInteger("cassandra.shutdown_announce_in_ms", 2000).intValue(), (TimeUnit)TimeUnit.MILLISECONDS);
        } else {
            logger.warn("No local state, state is in silent shutdown, or node hasn't joined, not announcing shutdown");
        }
        if (this.scheduledGossipTask != null) {
            this.scheduledGossipTask.cancel(false);
        }
    }

    public boolean isEnabled() {
        ScheduledFuture<?> scheduledGossipTask = this.scheduledGossipTask;
        return scheduledGossipTask != null && !scheduledGossipTask.isCancelled();
    }

    public boolean sufficientForStartupSafetyCheck(Map<InetAddressAndPort, EndpointState> epStateMap) {
        EndpointState localState = epStateMap.get(FBUtilities.getBroadcastAddressAndPort());
        return localState == null || this.isDeadState(localState) || localState.containsApplicationState(ApplicationState.HOST_ID);
    }

    protected void maybeFinishShadowRound(InetAddressAndPort respondent, boolean isInShadowRound, Map<InetAddressAndPort, EndpointState> epStateMap) {
        if (this.inShadowRound) {
            if (!isInShadowRound) {
                if (!this.sufficientForStartupSafetyCheck(epStateMap)) {
                    logger.debug("Not exiting shadow round because received ACK with insufficient states {} -> {}", (Object)FBUtilities.getBroadcastAddressAndPort(), (Object)epStateMap.get(FBUtilities.getBroadcastAddressAndPort()));
                    return;
                }
                if (!this.seeds.contains(respondent)) {
                    logger.warn("Received an ack from {}, who isn't a seed. Ensure your seed list includes a live node. Exiting shadow round", (Object)respondent);
                }
                logger.debug("Received a regular ack from {}, can now exit shadow round", (Object)respondent);
                this.endpointShadowStateMap.putAll(epStateMap);
                this.inShadowRound = false;
                this.seedsInShadowRound.clear();
            } else {
                logger.debug("Received an ack from {} indicating it is also in shadow round", (Object)respondent);
                this.seedsInShadowRound.add(respondent);
                if (this.seedsInShadowRound.containsAll(this.seeds)) {
                    logger.debug("All seeds are in a shadow round, clearing this node to exit its own");
                    this.inShadowRound = false;
                    this.seedsInShadowRound.clear();
                }
            }
        }
    }

    protected boolean isInShadowRound() {
        return this.inShadowRound;
    }

    public void initializeUnreachableNodeUnsafe(InetAddressAndPort addr) {
        EndpointState state = new EndpointState(HeartBeatState.empty());
        state.markDead();
        EndpointState oldState = this.endpointStateMap.putIfAbsent(addr, state);
        if (null != oldState) {
            throw new RuntimeException("Attempted to initialize endpoint state for unreachable node, but found existing endpoint state for it.");
        }
    }

    @VisibleForTesting
    public void initializeNodeUnsafe(InetAddressAndPort addr, UUID uuid, int generationNbr) {
        this.initializeNodeUnsafe(addr, uuid, 12, generationNbr);
    }

    @VisibleForTesting
    public void initializeNodeUnsafe(InetAddressAndPort addr, UUID uuid, int netVersion, int generationNbr) {
        HeartBeatState hbState = new HeartBeatState(generationNbr);
        EndpointState newState = new EndpointState(hbState);
        newState.markAlive();
        EndpointState oldState = this.endpointStateMap.putIfAbsent(addr, newState);
        EndpointState localState = oldState == null ? newState : oldState;
        EnumMap<ApplicationState, VersionedValue> states = new EnumMap<ApplicationState, VersionedValue>(ApplicationState.class);
        states.put(ApplicationState.NET_VERSION, StorageService.instance.valueFactory.networkVersion(netVersion));
        states.put(ApplicationState.HOST_ID, StorageService.instance.valueFactory.hostId(uuid));
        localState.addApplicationStates(states);
    }

    @VisibleForTesting
    public void injectApplicationState(InetAddressAndPort endpoint, ApplicationState state, VersionedValue value) {
        EndpointState localState = (EndpointState)this.endpointStateMap.get(endpoint);
        localState.addApplicationState(state, value);
    }

    @Override
    public long getEndpointDowntime(String address) throws UnknownHostException {
        return this.getEndpointDowntime(InetAddressAndPort.getByName(address));
    }

    @Override
    public int getCurrentGenerationNumber(String address) throws UnknownHostException {
        return this.getCurrentGenerationNumber(InetAddressAndPort.getByName(address));
    }

    public void addExpireTimeForEndpoint(InetAddressAndPort endpoint, long expireTime) {
        if (logger.isDebugEnabled()) {
            logger.debug("adding expire time for endpoint : {} ({})", (Object)endpoint, (Object)expireTime);
        }
        this.expireTimeEndpointMap.put(endpoint, expireTime);
    }

    public static long computeExpireTime() {
        return System.currentTimeMillis() + aVeryLongTime;
    }

    @Nullable
    public CassandraVersion getReleaseVersion(InetAddressAndPort ep) {
        EndpointState state = this.getEndpointStateForEndpoint(ep);
        return state != null ? state.getReleaseVersion() : null;
    }

    @Override
    public Map<String, List<String>> getReleaseVersionsWithPort() {
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        Iterable allHosts = Iterables.concat(instance.getLiveMembers(), instance.getUnreachableMembers());
        for (InetAddressAndPort host : allHosts) {
            CassandraVersion version = this.getReleaseVersion(host);
            String stringVersion = version == null ? "" : version.toString();
            ArrayList<String> hosts = (ArrayList<String>)results.get(stringVersion);
            if (hosts == null) {
                hosts = new ArrayList<String>();
                results.put(stringVersion, hosts);
            }
            hosts.add(host.getHostAddressAndPort());
        }
        return results;
    }

    @Nullable
    public UUID getSchemaVersion(InetAddressAndPort ep) {
        EndpointState state = this.getEndpointStateForEndpoint(ep);
        return state != null ? state.getSchemaVersion() : null;
    }

    public static void waitToSettle() {
        int forceAfter = Integer.getInteger("cassandra.skip_wait_for_gossip_to_settle", -1);
        if (forceAfter == 0) {
            return;
        }
        int GOSSIP_SETTLE_MIN_WAIT_MS = CassandraRelevantProperties.GOSSIP_SETTLE_MIN_WAIT_MS.getInt();
        int GOSSIP_SETTLE_POLL_INTERVAL_MS = CassandraRelevantProperties.GOSSIP_SETTLE_POLL_INTERVAL_MS.getInt();
        int GOSSIP_SETTLE_POLL_SUCCESSES_REQUIRED = CassandraRelevantProperties.GOSSIP_SETTLE_POLL_SUCCESSES_REQUIRED.getInt();
        logger.info("Waiting for gossip to settle...");
        Uninterruptibles.sleepUninterruptibly((long)GOSSIP_SETTLE_MIN_WAIT_MS, (TimeUnit)TimeUnit.MILLISECONDS);
        int totalPolls = 0;
        int numOkay = 0;
        int epSize = instance.getEndpointCount();
        while (numOkay < GOSSIP_SETTLE_POLL_SUCCESSES_REQUIRED) {
            Uninterruptibles.sleepUninterruptibly((long)GOSSIP_SETTLE_POLL_INTERVAL_MS, (TimeUnit)TimeUnit.MILLISECONDS);
            int currentSize = instance.getEndpointCount();
            ++totalPolls;
            if (currentSize == epSize) {
                logger.debug("Gossip looks settled.");
                ++numOkay;
            } else {
                logger.info("Gossip not settled after {} polls.", (Object)totalPolls);
                numOkay = 0;
            }
            epSize = currentSize;
            if (forceAfter <= 0 || totalPolls <= forceAfter) continue;
            logger.warn("Gossip not settled but startup forced by cassandra.skip_wait_for_gossip_to_settle. Gossip total polls: {}", (Object)totalPolls);
            break;
        }
        if (totalPolls > GOSSIP_SETTLE_POLL_SUCCESSES_REQUIRED) {
            logger.info("Gossip settled after {} extra polls; proceeding", (Object)(totalPolls - GOSSIP_SETTLE_POLL_SUCCESSES_REQUIRED));
        } else {
            logger.info("No gossip backlog; proceeding");
        }
    }

    public boolean waitForSchemaAgreement(long maxWait, TimeUnit unit, BooleanSupplier abortCondition) {
        int waited = 0;
        int toWait = 50;
        Set<InetAddressAndPort> members = this.getLiveTokenOwners();
        while (!this.nodesAgreeOnSchema(members)) {
            if ((long)waited >= unit.toMillis(maxWait) || abortCondition.getAsBoolean()) {
                return false;
            }
            Uninterruptibles.sleepUninterruptibly((long)toWait, (TimeUnit)TimeUnit.MILLISECONDS);
            waited += toWait;
            toWait = Math.min(1000, toWait * 2);
        }
        return true;
    }

    public boolean hasMajorVersion3OrUnknownNodes() {
        return this.isUpgradingFromVersionLowerThan(CassandraVersion.CASSANDRA_4_0) || this.hasNodeWithUnknownVersion;
    }

    public boolean isUpgradingFromVersionLowerThan(CassandraVersion referenceVersion) {
        CassandraVersion v = this.upgradeFromVersionMemoized.get();
        if (SystemKeyspace.NULL_VERSION.equals(v) && this.scheduledGossipTask == null) {
            return false;
        }
        return v != null && v.compareTo(referenceVersion) < 0;
    }

    private boolean nodesAgreeOnSchema(Collection<InetAddressAndPort> nodes) {
        UUID expectedVersion = null;
        for (InetAddressAndPort node : nodes) {
            EndpointState state = this.getEndpointStateForEndpoint(node);
            UUID remoteVersion = state.getSchemaVersion();
            if (null == expectedVersion) {
                expectedVersion = remoteVersion;
            }
            if (null != expectedVersion && expectedVersion.equals(remoteVersion)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public void stopShutdownAndWait(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.stop();
        ExecutorUtils.shutdownAndWait(timeout, unit, executor);
    }

    @Nullable
    public CassandraVersion getMinVersion(long delay, TimeUnit timeUnit) {
        try {
            return this.minVersionSupplier.get(delay, timeUnit);
        }
        catch (TimeoutException e) {
            return null;
        }
        catch (Throwable e) {
            logger.error("Caught an exception while waiting for min version", e);
            return null;
        }
    }

    @Nullable
    private String getReleaseVersionString(InetAddressAndPort ep) {
        EndpointState state = this.getEndpointStateForEndpoint(ep);
        if (state == null) {
            return null;
        }
        VersionedValue value = state.getApplicationState(ApplicationState.RELEASE_VERSION);
        return value == null ? null : value.value;
    }

    private CassandraVersion computeMinVersion() {
        CassandraVersion minVersion = null;
        for (InetAddressAndPort addr : Iterables.concat(instance.getLiveMembers(), instance.getUnreachableMembers())) {
            CassandraVersion version;
            String versionString = this.getReleaseVersionString(addr);
            if (versionString == null) {
                return null;
            }
            try {
                version = new CassandraVersion(versionString);
            }
            catch (Throwable t) {
                JVMStabilityInspector.inspectThrowable(t);
                String message = String.format("Can't parse version string %s", versionString);
                logger.warn(message);
                if (logger.isDebugEnabled()) {
                    logger.debug(message, t);
                }
                return null;
            }
            if (minVersion != null && version.compareTo(minVersion) >= 0) continue;
            minVersion = version;
        }
        return minVersion;
    }

    static {
        SILENT_SHUTDOWN_STATES.addAll(DEAD_STATES);
        SILENT_SHUTDOWN_STATES.add("BOOT");
        SILENT_SHUTDOWN_STATES.add("BOOT_REPLACE");
        ADMINISTRATIVELY_INACTIVE_STATES = Arrays.asList("hibernate", "removed", "LEFT");
        taskLock = new ReentrantLock();
        QUARANTINE_DELAY = CassandraRelevantProperties.GOSSIPER_QUARANTINE_DELAY.getInt(StorageService.RING_DELAY * 2);
        logger = LoggerFactory.getLogger(Gossiper.class);
        noSpamLogger = NoSpamLogger.getLogger(logger, 15L, TimeUnit.MINUTES);
        instance = new Gossiper(true);
        aVeryLongTime = Gossiper.getVeryLongTime();
        FAT_CLIENT_TIMEOUT = QUARANTINE_DELAY / 2;
        FAILED_BOOTSTRAP_TIMEOUT = Gossiper.getFailedBootstrapTimeout();
        disableThreadValidation = Boolean.getBoolean("cassandra.gossip.disable_thread_validation");
    }

    private class GossipTask
    implements Runnable {
        private GossipTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MessagingService.instance().waitUntilListening();
                taskLock.lock();
                ((EndpointState)Gossiper.this.endpointStateMap.get(FBUtilities.getBroadcastAddressAndPort())).updateHeartBeat();
                if (logger.isTraceEnabled()) {
                    logger.trace("My heartbeat is now {}", (Object)((EndpointState)Gossiper.this.endpointStateMap.get(FBUtilities.getBroadcastAddressAndPort())).getHeartBeatState().getHeartBeatVersion());
                }
                ArrayList<GossipDigest> gDigests = new ArrayList<GossipDigest>();
                instance.makeGossipDigest(gDigests);
                if (gDigests.size() > 0) {
                    GossipDigestSyn digestSynMessage = new GossipDigestSyn(DatabaseDescriptor.getClusterName(), DatabaseDescriptor.getPartitionerName(), gDigests);
                    Message<GossipDigestSyn> message = Message.out(Verb.GOSSIP_DIGEST_SYN, digestSynMessage);
                    boolean gossipedToSeed = Gossiper.this.doGossipToLiveMember(message);
                    Gossiper.this.maybeGossipToUnreachableMember(message);
                    if (!gossipedToSeed || Gossiper.this.liveEndpoints.size() < Gossiper.this.seeds.size()) {
                        Gossiper.this.maybeGossipToSeed(message);
                    }
                    Gossiper.this.doStatusCheck();
                }
            }
            catch (Exception e) {
                JVMStabilityInspector.inspectThrowable(e);
                logger.error("Gossip error", (Throwable)e);
            }
            finally {
                taskLock.unlock();
            }
        }
    }

    public static class Props {
        public static final String DISABLE_THREAD_VALIDATION = "cassandra.gossip.disable_thread_validation";
    }
}

