/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.ImmutableSet;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.FunctionResource;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.Resources;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.db.virtual.VirtualSchemaKeyspace;
import org.apache.cassandra.dht.Datacenters;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.SchemaKeyspaceTables;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.MD5Digest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientState {
    private static final Logger logger = LoggerFactory.getLogger(ClientState.class);
    public static final ImmutableSet<IResource> READABLE_SYSTEM_RESOURCES;
    public static final ImmutableSet<IResource> PROTECTED_AUTH_RESOURCES;
    private volatile AuthenticatedUser user;
    private volatile String keyspace;
    private volatile boolean issuedPreparedStatementsUseWarning;
    private static final QueryHandler cqlQueryHandler;
    public final boolean isInternal;
    private final InetSocketAddress remoteAddress;
    private volatile String driverName;
    private volatile String driverVersion;
    private static final AtomicLong lastTimestampMicros;

    private ClientState() {
        this.isInternal = true;
        this.remoteAddress = null;
    }

    protected ClientState(InetSocketAddress remoteAddress) {
        this.isInternal = false;
        this.remoteAddress = remoteAddress;
        if (!DatabaseDescriptor.getAuthenticator().requireAuthentication()) {
            this.user = AuthenticatedUser.ANONYMOUS_USER;
        }
    }

    protected ClientState(ClientState source) {
        this.isInternal = source.isInternal;
        this.remoteAddress = source.remoteAddress;
        this.user = source.user;
        this.keyspace = source.keyspace;
        this.driverName = source.driverName;
        this.driverVersion = source.driverVersion;
    }

    public static ClientState forInternalCalls() {
        return new ClientState();
    }

    public static ClientState forInternalCalls(String keyspace) {
        ClientState state = new ClientState();
        state.setKeyspace(keyspace);
        return state;
    }

    public static ClientState forExternalCalls(SocketAddress remoteAddress) {
        return new ClientState((InetSocketAddress)remoteAddress);
    }

    public ClientState cloneWithKeyspaceIfSet(String keyspace) {
        if (keyspace == null) {
            return this;
        }
        ClientState clientState = new ClientState(this);
        clientState.setKeyspace(keyspace);
        return clientState;
    }

    public static long getTimestamp() {
        long current;
        long tstamp;
        long last;
        do {
            current = System.currentTimeMillis() * 1000L;
        } while (!lastTimestampMicros.compareAndSet(last, tstamp = (last = lastTimestampMicros.get()) >= current ? last + 1L : current));
        return tstamp;
    }

    public long getTimestampForPaxos(long minTimestampToUse) {
        long last;
        long tstamp;
        do {
            long current = Math.max(System.currentTimeMillis() * 1000L, minTimestampToUse);
            last = lastTimestampMicros.get();
            long l = tstamp = last >= current ? last + 1L : current;
        } while (tstamp != minTimestampToUse && !lastTimestampMicros.compareAndSet(last, tstamp));
        return tstamp;
    }

    public Optional<String> getDriverName() {
        return Optional.ofNullable(this.driverName);
    }

    public Optional<String> getDriverVersion() {
        return Optional.ofNullable(this.driverVersion);
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public void setDriverVersion(String driverVersion) {
        this.driverVersion = driverVersion;
    }

    public static QueryHandler getCQLQueryHandler() {
        return cqlQueryHandler;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    InetAddress getClientAddress() {
        return this.isInternal ? null : this.remoteAddress.getAddress();
    }

    public String getRawKeyspace() {
        return this.keyspace;
    }

    public String getKeyspace() throws InvalidRequestException {
        if (this.keyspace == null) {
            throw new InvalidRequestException("No keyspace has been specified. USE a keyspace, or explicitly specify keyspace.tablename");
        }
        return this.keyspace;
    }

    public void setKeyspace(String ks) {
        if (this.user != null && Schema.instance.getKeyspaceMetadata(ks) == null) {
            throw new InvalidRequestException("Keyspace '" + ks + "' does not exist");
        }
        this.keyspace = ks;
    }

    public void login(AuthenticatedUser user) {
        if (!user.isAnonymous() && !this.canLogin(user)) {
            throw new AuthenticationException(String.format("%s is not permitted to log in", user.getName()));
        }
        this.user = user;
    }

    private boolean canLogin(AuthenticatedUser user) {
        try {
            return user.canLogin();
        }
        catch (RequestExecutionException | RequestValidationException e) {
            throw new AuthenticationException("Unable to perform authentication: " + e.getMessage(), e);
        }
    }

    public void ensureAllKeyspacesPermission(Permission perm) {
        if (this.isInternal) {
            return;
        }
        this.validateLogin();
        this.ensurePermission(perm, DataResource.root());
    }

    public void ensureKeyspacePermission(String keyspace, Permission perm) {
        this.ensurePermission(keyspace, perm, DataResource.keyspace(keyspace));
    }

    public void ensureTablePermission(String keyspace, String table, Permission perm) {
        this.ensurePermission(keyspace, perm, DataResource.table(keyspace, table));
    }

    public void ensureTablePermission(TableMetadataRef tableRef, Permission perm) {
        this.ensureTablePermission(tableRef.get(), perm);
    }

    public void ensureTablePermission(TableMetadata table, Permission perm) {
        this.ensurePermission(table.keyspace, perm, table.resource);
    }

    private void ensurePermission(String keyspace, Permission perm, DataResource resource) {
        ClientState.validateKeyspace(keyspace);
        if (this.isInternal) {
            return;
        }
        this.validateLogin();
        this.preventSystemKSSchemaModification(keyspace, resource, perm);
        if (perm == Permission.SELECT && READABLE_SYSTEM_RESOURCES.contains((Object)resource)) {
            return;
        }
        if (PROTECTED_AUTH_RESOURCES.contains((Object)resource) && (perm == Permission.CREATE || perm == Permission.ALTER || perm == Permission.DROP)) {
            throw new UnauthorizedException(String.format("%s schema is protected", resource));
        }
        this.ensurePermission(perm, resource);
    }

    public void ensurePermission(Permission perm, IResource resource) {
        String keyspace;
        DataResource dataResource;
        if (!DatabaseDescriptor.getAuthorizer().requireAuthorization()) {
            return;
        }
        if (resource instanceof FunctionResource && resource.hasParent() && ((FunctionResource)resource).getKeyspace().equals("system")) {
            return;
        }
        if (resource instanceof DataResource && !this.user.isSuper() && !this.user.isSystem() && !(dataResource = (DataResource)resource).isRootLevel() && SchemaConstants.isSystemKeyspace(keyspace = dataResource.getKeyspace())) {
            this.ensurePermissionOnResourceChain(perm, Resources.chain(dataResource, IResource::hasParent));
            return;
        }
        this.ensurePermissionOnResourceChain(perm, resource);
    }

    public void ensurePermission(Permission permission, Function function) {
        if (!DatabaseDescriptor.getAuthorizer().requireAuthorization()) {
            return;
        }
        if (function.isNative()) {
            return;
        }
        this.ensurePermissionOnResourceChain(permission, FunctionResource.function(function.name().keyspace, function.name().name, function.argTypes()));
    }

    private void ensurePermissionOnResourceChain(Permission perm, IResource resource) {
        this.ensurePermissionOnResourceChain(perm, Resources.chain(resource));
    }

    private void ensurePermissionOnResourceChain(Permission perm, List<? extends IResource> resources) {
        IResource resource = resources.get(0);
        for (IResource iResource : resources) {
            if (!this.authorize(iResource).contains((Object)perm)) continue;
            return;
        }
        throw new UnauthorizedException(String.format("User %s has no %s permission on %s or any of its parents", new Object[]{this.user.getName(), perm, resource}));
    }

    private void preventSystemKSSchemaModification(String keyspace, DataResource resource, Permission perm) {
        if (perm != Permission.ALTER && perm != Permission.DROP && perm != Permission.CREATE) {
            return;
        }
        if (SchemaConstants.isLocalSystemKeyspace(keyspace)) {
            throw new UnauthorizedException(keyspace + " keyspace is not user-modifiable.");
        }
        if (SchemaConstants.isReplicatedSystemKeyspace(keyspace)) {
            if (perm == Permission.ALTER && resource.isKeyspaceLevel()) {
                return;
            }
            throw new UnauthorizedException(String.format("Cannot %s %s", new Object[]{perm, resource}));
        }
    }

    public void validateLogin() {
        if (this.user == null) {
            throw new UnauthorizedException("You have not logged in");
        }
        if (!this.user.hasLocalAccess()) {
            throw new UnauthorizedException(String.format("You do not have access to this datacenter (%s)", Datacenters.thisDatacenter()));
        }
    }

    public void ensureNotAnonymous() {
        this.validateLogin();
        if (this.user.isAnonymous()) {
            throw new UnauthorizedException("You have to be logged in and not anonymous to perform this request");
        }
    }

    public void ensureIsSuperuser(String message) {
        if (DatabaseDescriptor.getAuthenticator().requireAuthentication() && (this.user == null || !this.user.isSuper())) {
            throw new UnauthorizedException(message);
        }
    }

    public void warnAboutUseWithPreparedStatements(MD5Digest statementId, String preparedKeyspace) {
        if (!this.issuedPreparedStatementsUseWarning) {
            ClientWarn.instance.warn(String.format("`USE <keyspace>` with prepared statements is considered to be an anti-pattern due to ambiguity in non-qualified table names. Please consider removing instances of `Session#setKeyspace(<keyspace>)`, `Session#execute(\"USE <keyspace>\")` and `cluster.newSession(<keyspace>)` from your code, and always use fully qualified table names (e.g. <keyspace>.<table>). Keyspace used: %s, statement keyspace: %s, statement id: %s", this.getRawKeyspace(), preparedKeyspace, statementId));
            this.issuedPreparedStatementsUseWarning = true;
        }
    }

    private static void validateKeyspace(String keyspace) {
        if (keyspace == null) {
            throw new InvalidRequestException("You have not set a keyspace for this session");
        }
    }

    public AuthenticatedUser getUser() {
        return this.user;
    }

    private Set<Permission> authorize(IResource resource) {
        return this.user.getPermissions(resource);
    }

    static {
        ImmutableSet.Builder readableBuilder = ImmutableSet.builder();
        for (String cf : Arrays.asList("local", "peers", "peers_v2", "size_estimates", "table_estimates")) {
            readableBuilder.add((Object)DataResource.table("system", cf));
        }
        SchemaKeyspaceTables.ALL.forEach(table -> readableBuilder.add((Object)DataResource.table("system_schema", table)));
        readableBuilder.add((Object)DataResource.table("system_traces", "events"));
        readableBuilder.add((Object)DataResource.table("system_traces", "sessions"));
        VirtualSchemaKeyspace.instance.tables().forEach(t -> readableBuilder.add((Object)t.metadata().resource));
        READABLE_SYSTEM_RESOURCES = readableBuilder.build();
        ImmutableSet.Builder protectedBuilder = ImmutableSet.builder();
        if (DatabaseDescriptor.isDaemonInitialized()) {
            protectedBuilder.addAll(DatabaseDescriptor.getAuthenticator().protectedResources());
            protectedBuilder.addAll(DatabaseDescriptor.getAuthorizer().protectedResources());
            protectedBuilder.addAll(DatabaseDescriptor.getRoleManager().protectedResources());
        }
        PROTECTED_AUTH_RESOURCES = protectedBuilder.build();
        QueryHandler handler = QueryProcessor.instance;
        String customHandlerClass = System.getProperty("cassandra.custom_query_handler_class");
        if (customHandlerClass != null) {
            try {
                handler = (QueryHandler)FBUtilities.construct(customHandlerClass, "QueryHandler");
                logger.info("Using {} as query handler for native protocol queries (as requested with -Dcassandra.custom_query_handler_class)", (Object)customHandlerClass);
            }
            catch (Exception e) {
                logger.error("Cannot use class {} as query handler", (Object)customHandlerClass, (Object)e);
                JVMStabilityInspector.killCurrentJVM(e, true);
            }
        }
        cqlQueryHandler = handler;
        lastTimestampMicros = new AtomicLong(0L);
    }
}

