/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.utils.MonotonicClock;

public abstract class Sampler<T> {
    @VisibleForTesting
    MonotonicClock clock = MonotonicClock.approxTime;
    @VisibleForTesting
    public static final ThreadPoolExecutor samplerExecutor = new JMXEnabledThreadPoolExecutor(1, 1L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000), new NamedThreadFactory("Sampler"), "internal");

    public void addSample(T item, int value) {
        if (this.isEnabled()) {
            samplerExecutor.submit(() -> this.insert(item, value));
        }
    }

    protected abstract void insert(T var1, long var2);

    public abstract boolean isEnabled();

    public abstract void beginSampling(int var1, int var2);

    public abstract List<Sample<T>> finishSampling(int var1);

    public abstract String toString(T var1);

    static {
        samplerExecutor.setRejectedExecutionHandler((runnable, executor) -> MessagingService.instance().metrics.recordSelfDroppedMessage(Verb._SAMPLE));
    }

    public static class Sample<S>
    implements Serializable {
        public final S value;
        public final long count;
        public final long error;

        public Sample(S value, long count, long error) {
            this.value = value;
            this.count = count;
            this.error = error;
        }

        public String toString() {
            return "Sample [value=" + this.value + ", count=" + this.count + ", error=" + this.error + "]";
        }
    }

    public static enum SamplerType {
        READS,
        WRITES,
        LOCAL_READ_TIME,
        WRITE_SIZE,
        CAS_CONTENTIONS;

    }
}

