/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.RoleName;
import org.apache.cassandra.cql3.statements.RoleManagementStatement;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class GrantRoleStatement
extends RoleManagementStatement {
    public GrantRoleStatement(RoleName name, RoleName grantee) {
        super(name, grantee);
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestValidationException, RequestExecutionException {
        DatabaseDescriptor.getRoleManager().grantRole(state.getUser(), this.role, this.grantee);
        return null;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.GRANT);
    }
}

