/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiPredicate;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.ConnectionType;
import org.apache.cassandra.net.Message;

public class OutboundSink {
    private volatile Sink sink;
    private static final AtomicReferenceFieldUpdater<OutboundSink, Sink> sinkUpdater = AtomicReferenceFieldUpdater.newUpdater(OutboundSink.class, Sink.class, "sink");

    OutboundSink(Sink sink) {
        this.sink = sink;
    }

    public void accept(Message<?> message, InetAddressAndPort to, ConnectionType connectionType) {
        this.sink.accept(message, to, connectionType);
    }

    public void add(BiPredicate<Message<?>, InetAddressAndPort> allow) {
        sinkUpdater.updateAndGet(this, sink -> new Filtered(allow, (Sink)sink));
    }

    public void remove(BiPredicate<Message<?>, InetAddressAndPort> allow) {
        sinkUpdater.updateAndGet(this, sink -> OutboundSink.without(sink, allow));
    }

    public void clear() {
        sinkUpdater.updateAndGet(this, OutboundSink::clear);
    }

    private static Sink clear(Sink sink) {
        while (sink instanceof Filtered) {
            sink = ((Filtered)sink).next;
        }
        return sink;
    }

    private static Sink without(Sink sink, BiPredicate<Message<?>, InetAddressAndPort> condition) {
        if (!(sink instanceof Filtered)) {
            return sink;
        }
        Filtered filtered = (Filtered)sink;
        Sink next = OutboundSink.without(filtered.next, condition);
        return condition.equals(filtered.condition) ? next : (next == filtered.next ? sink : new Filtered(filtered.condition, next));
    }

    private static class Filtered
    implements Sink {
        final BiPredicate<Message<?>, InetAddressAndPort> condition;
        final Sink next;

        private Filtered(BiPredicate<Message<?>, InetAddressAndPort> condition, Sink next) {
            this.condition = condition;
            this.next = next;
        }

        @Override
        public void accept(Message<?> message, InetAddressAndPort to, ConnectionType connectionType) {
            if (this.condition.test(message, to)) {
                this.next.accept(message, to, connectionType);
            }
        }
    }

    public static interface Sink {
        public void accept(Message<?> var1, InetAddressAndPort var2, ConnectionType var3);
    }
}

