/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.cql3.statements.schema.CreateTableStatement;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.Tables;

public final class AuthKeyspace {
    public static final long GENERATION = 1L;
    public static final String ROLES = "roles";
    public static final String ROLE_MEMBERS = "role_members";
    public static final String ROLE_PERMISSIONS = "role_permissions";
    public static final String RESOURCE_ROLE_INDEX = "resource_role_permissons_index";
    public static final String NETWORK_PERMISSIONS = "network_permissions";
    public static final long SUPERUSER_SETUP_DELAY = Long.getLong("cassandra.superuser_setup_delay_ms", 10000L);
    private static final TableMetadata Roles = AuthKeyspace.parse("roles", "role definitions", "CREATE TABLE %s (role text,is_superuser boolean,can_login boolean,salted_hash text,member_of set<text>,PRIMARY KEY(role))");
    private static final TableMetadata RoleMembers = AuthKeyspace.parse("role_members", "role memberships lookup table", "CREATE TABLE %s (role text,member text,PRIMARY KEY(role, member))");
    private static final TableMetadata RolePermissions = AuthKeyspace.parse("role_permissions", "permissions granted to db roles", "CREATE TABLE %s (role text,resource text,permissions set<text>,PRIMARY KEY(role, resource))");
    private static final TableMetadata ResourceRoleIndex = AuthKeyspace.parse("resource_role_permissons_index", "index of db roles with permissions granted on a resource", "CREATE TABLE %s (resource text,role text,PRIMARY KEY(resource, role))");
    private static final TableMetadata NetworkPermissions = AuthKeyspace.parse("network_permissions", "user network permissions", "CREATE TABLE %s (role text, dcs frozen<set<text>>, PRIMARY KEY(role))");

    private AuthKeyspace() {
    }

    private static TableMetadata parse(String name, String description, String cql) {
        return CreateTableStatement.parse(String.format(cql, name), "system_auth").id(TableId.forSystemTable("system_auth", name)).comment(description).gcGraceSeconds((int)TimeUnit.DAYS.toSeconds(90L)).build();
    }

    public static KeyspaceMetadata metadata() {
        return KeyspaceMetadata.create("system_auth", KeyspaceParams.simple(1), Tables.of(Roles, RoleMembers, RolePermissions, ResourceRoleIndex, NetworkPermissions));
    }
}

