/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import java.util.EnumMap;
import java.util.Map;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.metrics.CASClientRequestMetrics;
import org.apache.cassandra.metrics.CASClientWriteRequestMetrics;
import org.apache.cassandra.metrics.ClientRequestMetrics;
import org.apache.cassandra.metrics.ClientWriteRequestMetrics;
import org.apache.cassandra.metrics.ViewWriteMetrics;

public final class ClientRequestsMetricsHolder {
    public static final ClientRequestMetrics readMetrics = new ClientRequestMetrics("Read");
    public static final ClientWriteRequestMetrics writeMetrics = new ClientWriteRequestMetrics("Write");
    public static final CASClientWriteRequestMetrics casWriteMetrics = new CASClientWriteRequestMetrics("CASWrite");
    public static final CASClientRequestMetrics casReadMetrics = new CASClientRequestMetrics("CASRead");
    public static final ViewWriteMetrics viewWriteMetrics = new ViewWriteMetrics("ViewWrite");
    private static final Map<ConsistencyLevel, ClientRequestMetrics> readMetricsMap = new EnumMap<ConsistencyLevel, ClientRequestMetrics>(ConsistencyLevel.class);
    private static final Map<ConsistencyLevel, ClientWriteRequestMetrics> writeMetricsMap = new EnumMap<ConsistencyLevel, ClientWriteRequestMetrics>(ConsistencyLevel.class);

    public static ClientRequestMetrics readMetricsForLevel(ConsistencyLevel level) {
        return readMetricsMap.get((Object)level);
    }

    public static ClientWriteRequestMetrics writeMetricsForLevel(ConsistencyLevel level) {
        return writeMetricsMap.get((Object)level);
    }

    static {
        for (ConsistencyLevel level : ConsistencyLevel.values()) {
            readMetricsMap.put(level, new ClientRequestMetrics("Read-" + level.name()));
            writeMetricsMap.put(level, new ClientWriteRequestMetrics("Write-" + level.name()));
        }
    }
}

