/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import org.apache.cassandra.db.commitlog.AbstractCommitLogService;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogSegment;

class BatchCommitLogService
extends AbstractCommitLogService {
    private static final int POLL_TIME_MILLIS = 1000;

    public BatchCommitLogService(CommitLog commitLog) {
        super(commitLog, "COMMIT-LOG-WRITER", 1000L);
    }

    @Override
    protected void maybeWaitForSync(CommitLogSegment.Allocation alloc) {
        this.pending.incrementAndGet();
        this.requestExtraSync();
        alloc.awaitDiskSync(this.commitLog.metrics.waitingOnCommit);
        this.pending.decrementAndGet();
    }
}

