/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.selection.ResultSetBuilder;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SimpleSelector;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

abstract class ElementsSelector
extends Selector {
    protected final Selector selected;

    protected ElementsSelector(Selector selected) {
        this.selected = selected;
    }

    private static boolean isUnset(ByteBuffer bb) {
        return bb == ByteBufferUtil.UNSET_BYTE_BUFFER;
    }

    private static AbstractType<?> keyType(CollectionType<?> type) {
        return type.nameComparator();
    }

    public static AbstractType<?> valueType(CollectionType<?> type) {
        return type instanceof MapType ? type.valueComparator() : type.nameComparator();
    }

    private static CollectionType<?> getCollectionType(Selector selected) {
        AbstractType<Object> type = selected.getType();
        if (type instanceof ReversedType) {
            type = ((ReversedType)type).baseType;
        }
        assert (type instanceof MapType || type instanceof SetType) : "this shouldn't have passed validation in Selectable";
        return (CollectionType)type;
    }

    public static Selector.Factory newElementFactory(String name, Selector.Factory factory, CollectionType<?> type, final Term key) {
        return new AbstractFactory(name, factory, type){

            @Override
            protected AbstractType<?> getReturnType() {
                return ElementsSelector.valueType(this.type);
            }

            @Override
            public Selector newInstance(QueryOptions options) throws InvalidRequestException {
                ByteBuffer keyValue = key.bindAndGet(options);
                if (keyValue == null) {
                    throw new InvalidRequestException("Invalid null value for element selection on " + this.factory.getColumnName());
                }
                if (keyValue == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                    throw new InvalidRequestException("Invalid unset value for element selection on " + this.factory.getColumnName());
                }
                return new ElementSelector(this.factory.newInstance(options), keyValue);
            }

            @Override
            public boolean areAllFetchedColumnsKnown() {
                return this.factory.areAllFetchedColumnsKnown() && (!this.type.isMultiCell() || !this.factory.isSimpleSelectorFactory() || key.isTerminal());
            }

            @Override
            public void addFetchedColumns(ColumnFilter.Builder builder) {
                if (!this.type.isMultiCell() || !this.factory.isSimpleSelectorFactory()) {
                    this.factory.addFetchedColumns(builder);
                    return;
                }
                ColumnMetadata column = ((SimpleSelector.SimpleSelectorFactory)this.factory).getColumn();
                builder.select(column, CellPath.create(((Term.Terminal)key).get(ProtocolVersion.V3)));
            }
        };
    }

    public static Selector.Factory newSliceFactory(String name, Selector.Factory factory, CollectionType<?> type, final Term from, final Term to) {
        return new AbstractFactory(name, factory, type){

            @Override
            protected AbstractType<?> getReturnType() {
                return this.type;
            }

            @Override
            public Selector newInstance(QueryOptions options) throws InvalidRequestException {
                ByteBuffer fromValue = from.bindAndGet(options);
                ByteBuffer toValue = to.bindAndGet(options);
                if (fromValue == null || toValue == null) {
                    throw new InvalidRequestException("Invalid null value for slice selection on " + this.factory.getColumnName());
                }
                return new SliceSelector(this.factory.newInstance(options), from.bindAndGet(options), to.bindAndGet(options));
            }

            @Override
            public boolean areAllFetchedColumnsKnown() {
                return this.factory.areAllFetchedColumnsKnown() && (!this.type.isMultiCell() || !this.factory.isSimpleSelectorFactory() || from.isTerminal() && to.isTerminal());
            }

            @Override
            public void addFetchedColumns(ColumnFilter.Builder builder) {
                if (!this.type.isMultiCell() || !this.factory.isSimpleSelectorFactory()) {
                    this.factory.addFetchedColumns(builder);
                    return;
                }
                ColumnMetadata column = ((SimpleSelector.SimpleSelectorFactory)this.factory).getColumn();
                ByteBuffer fromBB = ((Term.Terminal)from).get(ProtocolVersion.V3);
                ByteBuffer toBB = ((Term.Terminal)to).get(ProtocolVersion.V3);
                builder.slice(column, ElementsSelector.isUnset(fromBB) ? CellPath.BOTTOM : CellPath.create(fromBB), ElementsSelector.isUnset(toBB) ? CellPath.TOP : CellPath.create(toBB));
            }
        };
    }

    @Override
    public ByteBuffer getOutput(ProtocolVersion protocolVersion) throws InvalidRequestException {
        ByteBuffer value = this.selected.getOutput(protocolVersion);
        return value == null ? null : this.extractSelection(value);
    }

    protected abstract ByteBuffer extractSelection(ByteBuffer var1);

    @Override
    public void addInput(ProtocolVersion protocolVersion, ResultSetBuilder rs) throws InvalidRequestException {
        this.selected.addInput(protocolVersion, rs);
    }

    @Override
    public void reset() {
        this.selected.reset();
    }

    private static class SliceSelector
    extends ElementsSelector {
        private final CollectionType<?> type;
        private final ByteBuffer from;
        private final ByteBuffer to;

        private SliceSelector(Selector selected, ByteBuffer from, ByteBuffer to) {
            super(selected);
            assert (from != null && to != null) : "We can have unset buffers, but not nulls";
            this.type = ElementsSelector.getCollectionType(selected);
            this.from = from;
            this.to = to;
        }

        @Override
        public void addFetchedColumns(ColumnFilter.Builder builder) {
            if (this.type.isMultiCell() && this.selected instanceof SimpleSelector) {
                ColumnMetadata column = ((SimpleSelector)this.selected).column;
                builder.slice(column, ElementsSelector.isUnset(this.from) ? CellPath.BOTTOM : CellPath.create(this.from), ElementsSelector.isUnset(this.to) ? CellPath.TOP : CellPath.create(this.to));
            } else {
                this.selected.addFetchedColumns(builder);
            }
        }

        @Override
        protected ByteBuffer extractSelection(ByteBuffer collection) {
            return ((CollectionSerializer)this.type.getSerializer()).getSliceFromSerialized(collection, this.from, this.to, this.type.nameComparator(), this.type.isFrozenCollection());
        }

        @Override
        public AbstractType<?> getType() {
            return this.type;
        }

        public String toString() {
            boolean fromUnset = ElementsSelector.isUnset(this.from);
            boolean toUnset = ElementsSelector.isUnset(this.to);
            return fromUnset && toUnset ? this.selected.toString() : String.format("%s[%s..%s]", this.selected, fromUnset ? "" : ElementsSelector.keyType(this.type).getString(this.from), toUnset ? "" : ElementsSelector.keyType(this.type).getString(this.to));
        }
    }

    private static class ElementSelector
    extends ElementsSelector {
        private final CollectionType<?> type;
        private final ByteBuffer key;

        private ElementSelector(Selector selected, ByteBuffer key) {
            super(selected);
            this.type = ElementsSelector.getCollectionType(selected);
            this.key = key;
        }

        @Override
        public void addFetchedColumns(ColumnFilter.Builder builder) {
            if (this.type.isMultiCell() && this.selected instanceof SimpleSelector) {
                ColumnMetadata column = ((SimpleSelector)this.selected).column;
                builder.select(column, CellPath.create(this.key));
            } else {
                this.selected.addFetchedColumns(builder);
            }
        }

        @Override
        protected ByteBuffer extractSelection(ByteBuffer collection) {
            return ((CollectionSerializer)this.type.getSerializer()).getSerializedValue(collection, this.key, ElementsSelector.keyType(this.type));
        }

        @Override
        public AbstractType<?> getType() {
            return ElementSelector.valueType(this.type);
        }

        public String toString() {
            return String.format("%s[%s]", this.selected, ElementsSelector.keyType(this.type).getString(this.key));
        }
    }

    private static abstract class AbstractFactory
    extends Selector.Factory {
        protected final String name;
        protected final Selector.Factory factory;
        protected final CollectionType<?> type;

        protected AbstractFactory(String name, Selector.Factory factory, CollectionType<?> type) {
            this.name = name;
            this.factory = factory;
            this.type = type;
        }

        @Override
        protected String getColumnName() {
            return this.name;
        }

        @Override
        protected void addColumnMapping(SelectionColumnMapping mapping, ColumnSpecification resultsColumn) {
            this.factory.addColumnMapping(mapping, resultsColumn);
        }

        @Override
        public boolean isAggregateSelectorFactory() {
            return this.factory.isAggregateSelectorFactory();
        }
    }
}

