/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.PartitionKeyRestrictions;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.TokenRestriction;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.IndexRegistry;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;

final class TokenFilter
implements PartitionKeyRestrictions {
    private final PartitionKeyRestrictions restrictions;
    private final TokenRestriction tokenRestriction;
    private final IPartitioner partitioner;

    @Override
    public boolean hasIN() {
        return this.isOnToken() ? false : this.restrictions.hasIN();
    }

    @Override
    public boolean hasContains() {
        return this.isOnToken() ? false : this.restrictions.hasContains();
    }

    @Override
    public boolean hasOnlyEqualityRestrictions() {
        return this.isOnToken() ? false : this.restrictions.hasOnlyEqualityRestrictions();
    }

    @Override
    public Set<Restriction> getRestrictions(ColumnMetadata columnDef) {
        HashSet<Restriction> set = new HashSet<Restriction>();
        set.addAll(this.restrictions.getRestrictions(columnDef));
        set.addAll(this.tokenRestriction.getRestrictions(columnDef));
        return set;
    }

    @Override
    public boolean isOnToken() {
        return this.needFiltering(this.tokenRestriction.metadata) || this.restrictions.size() < this.tokenRestriction.size();
    }

    public TokenFilter(PartitionKeyRestrictions restrictions, TokenRestriction tokenRestriction) {
        this.restrictions = restrictions;
        this.tokenRestriction = tokenRestriction;
        this.partitioner = tokenRestriction.metadata.partitioner;
    }

    @Override
    public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
        return this.filter(this.restrictions.values(options), options);
    }

    @Override
    public PartitionKeyRestrictions mergeWith(Restriction restriction) throws InvalidRequestException {
        if (restriction.isOnToken()) {
            return new TokenFilter(this.restrictions, (TokenRestriction)this.tokenRestriction.mergeWith(restriction));
        }
        return new TokenFilter(this.restrictions.mergeWith(restriction), this.tokenRestriction);
    }

    @Override
    public boolean isInclusive(Bound bound) {
        return this.isOnToken() ? this.tokenRestriction.isInclusive(bound) : this.restrictions.isInclusive(bound);
    }

    @Override
    public boolean hasBound(Bound bound) {
        return this.isOnToken() ? this.tokenRestriction.hasBound(bound) : this.restrictions.hasBound(bound);
    }

    @Override
    public List<ByteBuffer> bounds(Bound bound, QueryOptions options) throws InvalidRequestException {
        return this.isOnToken() ? this.tokenRestriction.bounds(bound, options) : this.restrictions.bounds(bound, options);
    }

    private List<ByteBuffer> filter(List<ByteBuffer> values, QueryOptions options) throws InvalidRequestException {
        RangeSet<Token> rangeSet = this.tokenRestriction.hasSlice() ? this.toRangeSet(this.tokenRestriction, options) : this.toRangeSet(this.tokenRestriction.values(options));
        return this.filterWithRangeSet(rangeSet, values);
    }

    private List<ByteBuffer> filterWithRangeSet(RangeSet<Token> tokens, List<ByteBuffer> values) {
        ArrayList<ByteBuffer> remaining = new ArrayList<ByteBuffer>();
        for (ByteBuffer value : values) {
            Token token = this.partitioner.getToken(value);
            if (!tokens.contains((Comparable)token)) continue;
            remaining.add(value);
        }
        return remaining;
    }

    private RangeSet<Token> toRangeSet(List<ByteBuffer> buffers) {
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        for (ByteBuffer buffer : buffers) {
            builder.add(Range.singleton((Comparable)this.deserializeToken(buffer)));
        }
        return builder.build();
    }

    private RangeSet<Token> toRangeSet(TokenRestriction slice, QueryOptions options) throws InvalidRequestException {
        if (slice.hasBound(Bound.START)) {
            Token start = this.deserializeToken(slice.bounds(Bound.START, options).get(0));
            BoundType startBoundType = TokenFilter.toBoundType(slice.isInclusive(Bound.START));
            if (slice.hasBound(Bound.END)) {
                BoundType endBoundType = TokenFilter.toBoundType(slice.isInclusive(Bound.END));
                Token end = this.deserializeToken(slice.bounds(Bound.END, options).get(0));
                if (start.equals(end) && (BoundType.OPEN == startBoundType || BoundType.OPEN == endBoundType)) {
                    return ImmutableRangeSet.of();
                }
                if (start.compareTo(end) <= 0) {
                    return ImmutableRangeSet.of((Range)Range.range((Comparable)start, (BoundType)startBoundType, (Comparable)end, (BoundType)endBoundType));
                }
                return ImmutableRangeSet.builder().add(Range.upTo((Comparable)end, (BoundType)endBoundType)).add(Range.downTo((Comparable)start, (BoundType)startBoundType)).build();
            }
            return ImmutableRangeSet.of((Range)Range.downTo((Comparable)start, (BoundType)startBoundType));
        }
        Token end = this.deserializeToken(slice.bounds(Bound.END, options).get(0));
        return ImmutableRangeSet.of((Range)Range.upTo((Comparable)end, (BoundType)TokenFilter.toBoundType(slice.isInclusive(Bound.END))));
    }

    private Token deserializeToken(ByteBuffer buffer) {
        return this.partitioner.getTokenFactory().fromByteArray(buffer);
    }

    private static BoundType toBoundType(boolean inclusive) {
        return inclusive ? BoundType.CLOSED : BoundType.OPEN;
    }

    @Override
    public ColumnMetadata getFirstColumn() {
        return this.restrictions.getFirstColumn();
    }

    @Override
    public ColumnMetadata getLastColumn() {
        return this.restrictions.getLastColumn();
    }

    @Override
    public List<ColumnMetadata> getColumnDefs() {
        return this.restrictions.getColumnDefs();
    }

    @Override
    public void addFunctionsTo(List<Function> functions) {
        this.restrictions.addFunctionsTo(functions);
    }

    @Override
    public boolean hasSupportingIndex(IndexRegistry indexRegistry) {
        return this.restrictions.hasSupportingIndex(indexRegistry);
    }

    @Override
    public void addRowFilterTo(RowFilter filter, IndexRegistry indexRegistry, QueryOptions options) {
        this.restrictions.addRowFilterTo(filter, indexRegistry, options);
    }

    @Override
    public boolean isEmpty() {
        return this.restrictions.isEmpty();
    }

    @Override
    public int size() {
        return this.restrictions.size();
    }

    @Override
    public boolean needFiltering(TableMetadata table) {
        return this.restrictions.needFiltering(table);
    }

    @Override
    public boolean hasUnrestrictedPartitionKeyComponents(TableMetadata table) {
        return this.restrictions.hasUnrestrictedPartitionKeyComponents(table);
    }

    @Override
    public boolean hasSlice() {
        return this.restrictions.hasSlice();
    }
}

