/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.cache.ChunkCache;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IndexSummary;
import org.apache.cassandra.io.sstable.IndexSummaryBuilder;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.io.util.DiskOptimizationStrategy;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.BloomFilterSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.FilterFactory;
import org.apache.cassandra.utils.IFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSTableReaderBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SSTableReaderBuilder.class);
    protected final SSTableReader.Factory readerFactory;
    protected final Descriptor descriptor;
    protected final TableMetadataRef metadataRef;
    protected final TableMetadata metadata;
    protected final long maxDataAge;
    protected final Set<Component> components;
    protected final StatsMetadata statsMetadata;
    protected final SSTableReader.OpenReason openReason;
    protected final SerializationHeader header;
    protected IndexSummary summary;
    protected DecoratedKey first;
    protected DecoratedKey last;
    protected IFilter bf;
    protected FileHandle ifile;
    protected FileHandle dfile;

    public SSTableReaderBuilder(Descriptor descriptor, TableMetadataRef metadataRef, long maxDataAge, Set<Component> components, StatsMetadata statsMetadata, SSTableReader.OpenReason openReason, SerializationHeader header) {
        this.descriptor = descriptor;
        this.metadataRef = metadataRef;
        this.metadata = metadataRef.get();
        this.maxDataAge = maxDataAge;
        this.components = components;
        this.statsMetadata = statsMetadata;
        this.openReason = openReason;
        this.header = header;
        this.readerFactory = descriptor.getFormat().getReaderFactory();
    }

    public abstract SSTableReader build();

    public SSTableReaderBuilder dfile(FileHandle dfile) {
        this.dfile = dfile;
        return this;
    }

    public SSTableReaderBuilder ifile(FileHandle ifile) {
        this.ifile = ifile;
        return this;
    }

    public SSTableReaderBuilder bf(IFilter bf) {
        this.bf = bf;
        return this;
    }

    public SSTableReaderBuilder summary(IndexSummary summary) {
        this.summary = summary;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadSummary() {
        File summariesFile = new File(this.descriptor.filenameFor(Component.SUMMARY));
        if (!summariesFile.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug("SSTable Summary File {} does not exist", (Object)summariesFile.getAbsolutePath());
            }
            return;
        }
        DataInputStream iStream = null;
        try {
            iStream = new DataInputStream(Files.newInputStream(summariesFile.toPath(), new OpenOption[0]));
            this.summary = IndexSummary.serializer.deserialize(iStream, this.metadata.partitioner, this.metadata.params.minIndexInterval, this.metadata.params.maxIndexInterval);
            this.first = this.metadata.partitioner.decorateKey(ByteBufferUtil.readWithLength(iStream));
            this.last = this.metadata.partitioner.decorateKey(ByteBufferUtil.readWithLength(iStream));
        }
        catch (IOException e) {
            try {
                if (this.summary != null) {
                    this.summary.close();
                }
                logger.trace("Cannot deserialize SSTable Summary File {}: {}", (Object)summariesFile.getPath(), (Object)e.getMessage());
                FileUtils.closeQuietly(iStream);
                FileUtils.deleteWithConfirm(summariesFile);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(iStream);
                throw throwable;
            }
            FileUtils.closeQuietly(iStream);
        }
        FileUtils.closeQuietly(iStream);
    }

    void buildSummaryAndBloomFilter(boolean recreateBloomFilter, boolean summaryLoaded, Set<Component> components, StatsMetadata statsMetadata) throws IOException {
        if (!components.contains(Component.PRIMARY_INDEX)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Attempting to build summary for {}", (Object)this.descriptor);
        }
        try (RandomAccessReader primaryIndex = RandomAccessReader.open(new File(this.descriptor.filenameFor(Component.PRIMARY_INDEX)));){
            long estimatedKeys;
            long indexSize = primaryIndex.length();
            long histogramCount = statsMetadata.estimatedPartitionSize.count();
            long l = estimatedKeys = histogramCount > 0L && !statsMetadata.estimatedPartitionSize.isOverflowed() ? histogramCount : SSTable.estimateRowsFromIndex(primaryIndex, this.descriptor);
            if (recreateBloomFilter) {
                this.bf = FilterFactory.getFilter(estimatedKeys, this.metadata.params.bloomFilterFpChance);
            }
            try (IndexSummaryBuilder summaryBuilder = summaryLoaded ? null : new IndexSummaryBuilder(estimatedKeys, this.metadata.params.minIndexInterval, 128);){
                long indexPosition;
                while ((indexPosition = primaryIndex.getFilePointer()) != indexSize) {
                    ByteBuffer key = ByteBufferUtil.readWithShortLength(primaryIndex);
                    RowIndexEntry.Serializer.skip(primaryIndex, this.descriptor.version);
                    DecoratedKey decoratedKey = this.metadata.partitioner.decorateKey(key);
                    if (!summaryLoaded) {
                        if (this.first == null) {
                            this.first = decoratedKey;
                        }
                        this.last = decoratedKey;
                    }
                    if (recreateBloomFilter) {
                        this.bf.add(decoratedKey);
                    }
                    if (summaryLoaded) continue;
                    summaryBuilder.maybeAddEntry(decoratedKey, indexPosition);
                }
                if (!summaryLoaded) {
                    this.summary = summaryBuilder.build(this.metadata.partitioner);
                }
            }
        }
        if (!summaryLoaded) {
            this.first = SSTable.getMinimalKey(this.first);
            this.last = SSTable.getMinimalKey(this.last);
        }
    }

    IFilter loadBloomFilter() throws IOException {
        try (DataInputStream stream = new DataInputStream(new BufferedInputStream(Files.newInputStream(Paths.get(this.descriptor.filenameFor(Component.FILTER), new String[0]), new OpenOption[0])));){
            BloomFilter bloomFilter = BloomFilterSerializer.deserialize(stream, this.descriptor.version.hasOldBfFormat());
            return bloomFilter;
        }
    }

    public static class ForRead
    extends SSTableReaderBuilder {
        private final ValidationMetadata validationMetadata;
        private final boolean isOffline;

        public ForRead(Descriptor descriptor, TableMetadataRef metadataRef, ValidationMetadata validationMetadata, boolean isOffline, Set<Component> components, StatsMetadata statsMetadata, SerializationHeader header) {
            super(descriptor, metadataRef, System.currentTimeMillis(), components, statsMetadata, SSTableReader.OpenReason.NORMAL, header);
            this.validationMetadata = validationMetadata;
            this.isOffline = isOffline;
        }

        @Override
        public SSTableReader build() {
            String dataFilePath = this.descriptor.filenameFor(Component.DATA);
            long fileLength = new File(dataFilePath).length();
            logger.info("Opening {} ({})", (Object)this.descriptor, (Object)FBUtilities.prettyPrintMemory(fileLength));
            try {
                long start = System.nanoTime();
                this.load(this.validationMetadata, this.isOffline, this.components, DatabaseDescriptor.getDiskOptimizationStrategy(), this.statsMetadata);
                logger.trace("INDEX LOAD TIME for {}: {} ms.", (Object)this.descriptor, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
            }
            catch (IOException t) {
                throw new CorruptSSTableException((Throwable)t, dataFilePath);
            }
            SSTableReader sstable = this.readerFactory.open(this);
            sstable.first = this.first;
            sstable.last = this.last;
            sstable.setup(!this.isOffline);
            return sstable;
        }

        private void load(ValidationMetadata validation, boolean isOffline, Set<Component> components, DiskOptimizationStrategy optimizationStrategy, StatsMetadata statsMetadata) throws IOException {
            if (this.metadata.params.bloomFilterFpChance == 1.0) {
                this.load(false, !isOffline, optimizationStrategy, statsMetadata, components);
                this.bf = FilterFactory.AlwaysPresent;
            } else if (!components.contains(Component.PRIMARY_INDEX)) {
                this.load(false, !isOffline, optimizationStrategy, statsMetadata, components);
            } else if (!components.contains(Component.FILTER) || validation == null) {
                this.load(!isOffline, !isOffline, optimizationStrategy, statsMetadata, components);
                if (isOffline) {
                    this.bf = FilterFactory.AlwaysPresent;
                }
            } else {
                this.load(false, !isOffline, optimizationStrategy, statsMetadata, components);
                this.bf = this.loadBloomFilter();
            }
        }

        void load(boolean recreateBloomFilter, boolean saveSummaryIfCreated, DiskOptimizationStrategy optimizationStrategy, StatsMetadata statsMetadata, Set<Component> components) throws IOException {
            try (FileHandle.Builder ibuilder = new FileHandle.Builder(this.descriptor.filenameFor(Component.PRIMARY_INDEX)).mmapped(DatabaseDescriptor.getIndexAccessMode() == Config.DiskAccessMode.mmap).withChunkCache(ChunkCache.instance);
                 FileHandle.Builder dbuilder = new FileHandle.Builder(this.descriptor.filenameFor(Component.DATA)).compressed(components.contains(Component.COMPRESSION_INFO)).mmapped(DatabaseDescriptor.getDiskAccessMode() == Config.DiskAccessMode.mmap).withChunkCache(ChunkCache.instance);){
                boolean buildSummary;
                this.loadSummary();
                boolean bl = buildSummary = this.summary == null || recreateBloomFilter;
                if (buildSummary) {
                    this.buildSummaryAndBloomFilter(recreateBloomFilter, this.summary != null, components, statsMetadata);
                }
                int dataBufferSize = optimizationStrategy.bufferSize(statsMetadata.estimatedPartitionSize.percentile(DatabaseDescriptor.getDiskOptimizationEstimatePercentile()));
                if (components.contains(Component.PRIMARY_INDEX)) {
                    long indexFileLength = new File(this.descriptor.filenameFor(Component.PRIMARY_INDEX)).length();
                    int indexBufferSize = optimizationStrategy.bufferSize(indexFileLength / (long)this.summary.size());
                    this.ifile = ibuilder.bufferSize(indexBufferSize).complete();
                }
                this.dfile = dbuilder.bufferSize(dataBufferSize).complete();
                if (buildSummary) {
                    if (saveSummaryIfCreated) {
                        SSTableReader.saveSummary(this.descriptor, this.first, this.last, this.summary);
                    }
                    if (recreateBloomFilter) {
                        SSTableReader.saveBloomFilter(this.descriptor, this.bf);
                    }
                }
            }
            catch (Throwable t) {
                if (this.ifile != null) {
                    this.ifile.close();
                }
                if (this.dfile != null) {
                    this.dfile.close();
                }
                if (this.summary != null) {
                    this.summary.close();
                }
                throw t;
            }
        }
    }

    public static class ForBatch
    extends SSTableReaderBuilder {
        public ForBatch(Descriptor descriptor, TableMetadataRef metadataRef, Set<Component> components, StatsMetadata statsMetadata, SerializationHeader header) {
            super(descriptor, metadataRef, System.currentTimeMillis(), components, statsMetadata, SSTableReader.OpenReason.NORMAL, header);
        }

        /*
         * Exception decompiling
         */
        @Override
        public SSTableReader build() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        void initSummary(String dataFilePath, Set<Component> components, StatsMetadata statsMetadata) {
            this.loadSummary();
            if (this.summary == null) {
                try {
                    this.buildSummaryAndBloomFilter(false, false, components, statsMetadata);
                }
                catch (IOException e) {
                    throw new CorruptSSTableException((Throwable)e, dataFilePath);
                }
            }
        }
    }

    public static class ForWriter
    extends SSTableReaderBuilder {
        public ForWriter(Descriptor descriptor, TableMetadataRef metadataRef, long maxDataAge, Set<Component> components, StatsMetadata statsMetadata, SSTableReader.OpenReason openReason, SerializationHeader header) {
            super(descriptor, metadataRef, maxDataAge, components, statsMetadata, openReason, header);
        }

        @Override
        public SSTableReader build() {
            SSTableReader reader = this.readerFactory.open(this);
            reader.setup(true);
            return reader;
        }
    }
}

