/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicaCollection;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaCollection;

public class RangesAtEndpoint
extends AbstractReplicaCollection<RangesAtEndpoint> {
    private static final AbstractReplicaCollection.ReplicaMap<Range<Token>> EMPTY_MAP = RangesAtEndpoint.rangeMap(EMPTY_LIST);
    private final InetAddressAndPort endpoint;
    private AbstractReplicaCollection.ReplicaMap<Range<Token>> byRange;
    private RangesAtEndpoint onlyFull;
    private RangesAtEndpoint onlyTransient;

    private static AbstractReplicaCollection.ReplicaMap<Range<Token>> rangeMap(AbstractReplicaCollection.ReplicaList list) {
        return new AbstractReplicaCollection.ReplicaMap<Range<Token>>(list, Replica::range);
    }

    private RangesAtEndpoint(InetAddressAndPort endpoint, AbstractReplicaCollection.ReplicaList list, AbstractReplicaCollection.ReplicaMap<Range<Token>> byRange) {
        super(list);
        this.endpoint = endpoint;
        this.byRange = byRange;
        assert (endpoint != null);
    }

    public InetAddressAndPort endpoint() {
        return this.endpoint;
    }

    @Override
    public Set<InetAddressAndPort> endpoints() {
        return Collections.unmodifiableSet(this.list.isEmpty() ? Collections.emptySet() : Collections.singleton(this.endpoint));
    }

    public Set<Range<Token>> ranges() {
        return this.byRange().keySet();
    }

    public Map<Range<Token>, Replica> byRange() {
        AbstractReplicaCollection.ReplicaMap<Range<Token>> map = this.byRange;
        if (map == null) {
            this.byRange = map = RangesAtEndpoint.rangeMap(this.list);
        }
        return map;
    }

    @Override
    protected RangesAtEndpoint snapshot(AbstractReplicaCollection.ReplicaList newList) {
        if (newList.isEmpty()) {
            return RangesAtEndpoint.empty(this.endpoint);
        }
        AbstractReplicaCollection.ReplicaMap<Range<Token>> byRange = null;
        if (this.byRange != null && this.list.isSubList(newList)) {
            byRange = this.byRange.forSubList(newList);
        }
        return new RangesAtEndpoint(this.endpoint, newList, byRange);
    }

    @Override
    public RangesAtEndpoint snapshot() {
        return this;
    }

    @Override
    public ReplicaCollection.Builder<RangesAtEndpoint> newBuilder(int initialCapacity) {
        return new Builder(this.endpoint, initialCapacity);
    }

    @Override
    public boolean contains(Replica replica) {
        return replica != null && Objects.equals(this.byRange().get(replica.range()), replica);
    }

    public RangesAtEndpoint onlyFull() {
        RangesAtEndpoint result = this.onlyFull;
        if (this.onlyFull == null) {
            this.onlyFull = result = (RangesAtEndpoint)this.filter(Replica::isFull);
        }
        return result;
    }

    public RangesAtEndpoint onlyTransient() {
        RangesAtEndpoint result = this.onlyTransient;
        if (this.onlyTransient == null) {
            this.onlyTransient = result = (RangesAtEndpoint)this.filter(Replica::isTransient);
        }
        return result;
    }

    public boolean contains(Range<Token> range, boolean isFull) {
        Replica replica = this.byRange().get(range);
        return replica != null && replica.isFull() == isFull;
    }

    public RangesAtEndpoint unwrap() {
        int wrapAroundCount = 0;
        for (Replica replica : this) {
            if (!replica.range().isWrapAround()) continue;
            ++wrapAroundCount;
        }
        assert (wrapAroundCount <= 1);
        if (wrapAroundCount == 0) {
            return this.snapshot();
        }
        Builder builder = RangesAtEndpoint.builder(this.endpoint, this.size() + wrapAroundCount);
        for (Replica replica : this) {
            if (!replica.range().isWrapAround()) {
                builder.add(replica);
                continue;
            }
            for (Range<Token> range : replica.range().unwrap()) {
                builder.add(replica.decorateSubrange(range));
            }
        }
        return builder.build();
    }

    public static Collector<Replica, Builder, RangesAtEndpoint> collector(InetAddressAndPort endpoint) {
        return RangesAtEndpoint.collector((Set<Collector.Characteristics>)ImmutableSet.of(), () -> new Builder(endpoint));
    }

    public static Builder builder(InetAddressAndPort endpoint) {
        return new Builder(endpoint);
    }

    public static Builder builder(InetAddressAndPort endpoint, int capacity) {
        return new Builder(endpoint, capacity);
    }

    public static RangesAtEndpoint empty(InetAddressAndPort endpoint) {
        return new RangesAtEndpoint(endpoint, EMPTY_LIST, EMPTY_MAP);
    }

    public static RangesAtEndpoint of(Replica replica) {
        AbstractReplicaCollection.ReplicaList one = new AbstractReplicaCollection.ReplicaList(1);
        one.add(replica);
        return new RangesAtEndpoint(replica.endpoint(), one, RangesAtEndpoint.rangeMap(one));
    }

    public static RangesAtEndpoint of(Replica ... replicas) {
        return RangesAtEndpoint.copyOf(Arrays.asList(replicas));
    }

    public static RangesAtEndpoint copyOf(List<Replica> replicas) {
        if (replicas.isEmpty()) {
            throw new IllegalArgumentException("Must specify a non-empty collection of replicas");
        }
        return (RangesAtEndpoint)RangesAtEndpoint.builder(replicas.get(0).endpoint(), replicas.size()).addAll(replicas).build();
    }

    @VisibleForTesting
    public static RangesAtEndpoint toDummyList(Collection<Range<Token>> ranges) {
        InetAddressAndPort dummy;
        try {
            dummy = InetAddressAndPort.getByNameOverrideDefaults("0.0.0.0", 0);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        return ranges.stream().map(range -> new Replica(dummy, (Range<Token>)range, true)).collect(RangesAtEndpoint.collector(dummy));
    }

    public static boolean isDummyList(RangesAtEndpoint ranges) {
        return Iterables.all((Iterable)ranges, range -> range.endpoint().getHostAddress(true).equals("0.0.0.0:0"));
    }

    public static RangesAtEndpoint concat(RangesAtEndpoint replicas, RangesAtEndpoint extraReplicas) {
        return AbstractReplicaCollection.concat(replicas, extraReplicas, ReplicaCollection.Builder.Conflict.NONE);
    }

    public static class Builder
    extends RangesAtEndpoint
    implements ReplicaCollection.Builder<RangesAtEndpoint> {
        boolean built;

        public Builder(InetAddressAndPort endpoint) {
            this(endpoint, 0);
        }

        public Builder(InetAddressAndPort endpoint, int capacity) {
            this(endpoint, new AbstractReplicaCollection.ReplicaList(capacity));
        }

        private Builder(InetAddressAndPort endpoint, AbstractReplicaCollection.ReplicaList list) {
            super(endpoint, list, RangesAtEndpoint.rangeMap(list));
        }

        public Builder add(Replica replica) {
            return this.add(replica, ReplicaCollection.Builder.Conflict.DUPLICATE);
        }

        public Builder add(Replica replica, ReplicaCollection.Builder.Conflict ignoreConflict) {
            if (this.built) {
                throw new IllegalStateException();
            }
            Preconditions.checkNotNull((Object)replica);
            if (!Objects.equals(((RangesAtEndpoint)this).endpoint, replica.endpoint())) {
                throw new IllegalArgumentException("Replica " + replica + " has incorrect endpoint (expected " + ((RangesAtEndpoint)this).endpoint + ")");
            }
            if (!((RangesAtEndpoint)this).byRange.internalPutIfAbsent(replica, this.list.size())) {
                switch (ignoreConflict) {
                    case DUPLICATE: {
                        if (this.byRange().get(replica.range()).equals(replica)) break;
                    }
                    case NONE: {
                        throw new IllegalArgumentException("Conflicting replica added (expected unique ranges): " + replica + "; existing: " + this.byRange().get(replica.range()));
                    }
                }
                return this;
            }
            this.list.add(replica);
            return this;
        }

        @Override
        public RangesAtEndpoint snapshot() {
            return this.snapshot(this.list.subList(0, this.list.size()));
        }

        @Override
        public RangesAtEndpoint build() {
            this.built = true;
            return new RangesAtEndpoint(((RangesAtEndpoint)this).endpoint, this.list, ((RangesAtEndpoint)this).byRange);
        }
    }
}

