/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import org.apache.cassandra.exceptions.ConfigurationException;

public enum CassandraRelevantProperties {
    JAVA_HOME("java.home"),
    CASSANDRA_PID_FILE("cassandra-pidfile"),
    JAVA_IO_TMPDIR("java.io.tmpdir"),
    JAVA_LIBRARY_PATH("java.library.path"),
    JAVA_SECURITY_EGD("java.security.egd"),
    JAVA_VERSION("java.version"),
    JAVA_VM_NAME("java.vm.name"),
    LINE_SEPARATOR("line.separator"),
    JAVA_CLASS_PATH("java.class.path"),
    OS_ARCH("os.arch"),
    OS_NAME("os.name"),
    USER_HOME("user.home"),
    SUN_ARCH_DATA_MODEL("sun.arch.data.model"),
    JAVA_RMI_SERVER_HOSTNAME("java.rmi.server.hostname"),
    JAVA_RMI_SERVER_RANDOM_ID("java.rmi.server.randomIDs"),
    COM_SUN_MANAGEMENT_JMXREMOTE_AUTHENTICATE("com.sun.management.jmxremote.authenticate"),
    COM_SUN_MANAGEMENT_JMXREMOTE_RMI_PORT("com.sun.management.jmxremote.rmi.port", "0"),
    CASSANDRA_JMX_REMOTE_PORT("cassandra.jmx.remote.port"),
    COM_SUN_MANAGEMENT_JMXREMOTE_SSL("com.sun.management.jmxremote.ssl"),
    COM_SUN_MANAGEMENT_JMXREMOTE_SSL_NEED_CLIENT_AUTH("com.sun.management.jmxremote.ssl.need.client.auth"),
    COM_SUN_MANAGEMENT_JMXREMOTE_ACCESS_FILE("com.sun.management.jmxremote.access.file"),
    COM_SUN_MANAGEMENT_JMXREMOTE_PASSWORD_FILE("com.sun.management.jmxremote.password.file"),
    COM_SUN_MANAGEMENT_JMXREMOTE_PORT("com.sun.management.jmxremote.port"),
    COM_SUN_MANAGEMENT_JMXREMOTE_SSL_ENABLED_PROTOCOLS("com.sun.management.jmxremote.ssl.enabled.protocols"),
    COM_SUN_MANAGEMENT_JMXREMOTE_SSL_ENABLED_CIPHER_SUITES("com.sun.management.jmxremote.ssl.enabled.cipher.suites"),
    MX4JADDRESS("mx4jaddress"),
    MX4JPORT("mx4jport"),
    BOOTSTRAP_SKIP_SCHEMA_CHECK("cassandra.skip_schema_check"),
    BOOTSTRAP_SCHEMA_DELAY_MS("cassandra.schema_delay_ms"),
    GOSSIPER_QUARANTINE_DELAY("cassandra.gossip_quarantine_delay_ms"),
    REPLACEMENT_ALLOW_EMPTY("cassandra.allow_empty_replace_address", "true"),
    CASSANDRA_FOREGROUND("cassandra-foreground"),
    DEFAULT_PROVIDE_OVERLAPPING_TOMBSTONES("default.provide.overlapping.tombstones"),
    ORG_APACHE_CASSANDRA_DISABLE_MBEAN_REGISTRATION("org.apache.cassandra.disable_mbean_registration"),
    ORG_APACHE_CASSANDRA_CONF_CASSANDRA_RELEVANT_PROPERTIES_TEST("org.apache.cassandra.conf.CassandraRelevantPropertiesTest"),
    ORG_APACHE_CASSANDRA_DB_VIRTUAL_SYSTEM_PROPERTIES_TABLE_TEST("org.apache.cassandra.db.virtual.SystemPropertiesTableTest"),
    IS_DISABLED_MBEAN_REGISTRATION("org.apache.cassandra.disable_mbean_registration"),
    MBEAN_REGISTRATION_CLASS("org.apache.cassandra.mbean_registration_class");

    private final String key;
    private final String defaultVal;
    private static final PropertyConverter<String> STRING_CONVERTER;
    private static final PropertyConverter<Boolean> BOOLEAN_CONVERTER;
    private static final PropertyConverter<Integer> INTEGER_CONVERTER;

    private CassandraRelevantProperties(String key, String defaultVal) {
        this.key = key;
        this.defaultVal = defaultVal;
    }

    private CassandraRelevantProperties(String key) {
        this.key = key;
        this.defaultVal = null;
    }

    public String getKey() {
        return this.key;
    }

    public String getString() {
        String value = System.getProperty(this.key);
        return value == null ? this.defaultVal : STRING_CONVERTER.convert(value);
    }

    public String getString(String overrideDefaultValue) {
        String value = System.getProperty(this.key);
        if (value == null) {
            return overrideDefaultValue;
        }
        return STRING_CONVERTER.convert(value);
    }

    public void setString(String value) {
        System.setProperty(this.key, value);
    }

    public boolean getBoolean() {
        String value = System.getProperty(this.key);
        return BOOLEAN_CONVERTER.convert(value == null ? this.defaultVal : value);
    }

    public boolean getBoolean(boolean overrideDefaultValue) {
        String value = System.getProperty(this.key);
        if (value == null) {
            return overrideDefaultValue;
        }
        return BOOLEAN_CONVERTER.convert(value);
    }

    public void setBoolean(boolean value) {
        System.setProperty(this.key, Boolean.toString(value));
    }

    public int getInt() {
        String value = System.getProperty(this.key);
        return INTEGER_CONVERTER.convert(value == null ? this.defaultVal : value);
    }

    public int getInt(int overrideDefaultValue) {
        String value = System.getProperty(this.key);
        if (value == null) {
            return overrideDefaultValue;
        }
        return INTEGER_CONVERTER.convert(value);
    }

    public void setInt(int value) {
        System.setProperty(this.key, Integer.toString(value));
    }

    public boolean isPresent() {
        return System.getProperties().containsKey(this.key);
    }

    static {
        STRING_CONVERTER = value -> value;
        BOOLEAN_CONVERTER = Boolean::parseBoolean;
        INTEGER_CONVERTER = value -> {
            try {
                return Integer.decode(value);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(String.format("Invalid value for system property: expected integer value but got '%s'", value));
            }
        };
    }

    private static interface PropertyConverter<T> {
        public T convert(String var1);
    }
}

