/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import org.apache.cassandra.cql3.QueryEvents;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.JVMStabilityInspector;

public class PrepareMessage
extends Message.Request {
    public static final Message.Codec<PrepareMessage> codec = new Message.Codec<PrepareMessage>(){

        @Override
        public PrepareMessage decode(ByteBuf body, ProtocolVersion version) {
            int flags;
            String query = CBUtil.readLongString(body);
            String keyspace = null;
            if (version.isGreaterOrEqualTo(ProtocolVersion.V5) && ((flags = (int)body.readUnsignedInt()) & 1) == 1) {
                keyspace = CBUtil.readString(body);
            }
            return new PrepareMessage(query, keyspace);
        }

        @Override
        public void encode(PrepareMessage msg, ByteBuf dest, ProtocolVersion version) {
            CBUtil.writeLongString(msg.query, dest);
            if (version.isGreaterOrEqualTo(ProtocolVersion.V5)) {
                if (msg.keyspace == null) {
                    dest.writeInt(0);
                } else {
                    dest.writeInt(1);
                    CBUtil.writeAsciiString(msg.keyspace, dest);
                }
            }
        }

        @Override
        public int encodedSize(PrepareMessage msg, ProtocolVersion version) {
            int size = CBUtil.sizeOfLongString(msg.query);
            if (version.isGreaterOrEqualTo(ProtocolVersion.V5)) {
                size += 4;
                size += msg.keyspace == null ? 0 : CBUtil.sizeOfAsciiString(msg.keyspace);
            }
            return size;
        }
    };
    private final String query;
    private final String keyspace;

    public PrepareMessage(String query, String keyspace) {
        super(Message.Type.PREPARE);
        this.query = query;
        this.keyspace = keyspace;
    }

    @Override
    protected boolean isTraceable() {
        return true;
    }

    @Override
    protected Message.Response execute(QueryState state, long queryStartNanoTime, boolean traceRequest) {
        try {
            if (traceRequest) {
                Tracing.instance.begin("Preparing CQL3 query", state.getClientAddress(), (Map<String, String>)ImmutableMap.of((Object)"query", (Object)this.query));
            }
            ClientState clientState = state.getClientState().cloneWithKeyspaceIfSet(this.keyspace);
            QueryHandler queryHandler = ClientState.getCQLQueryHandler();
            long queryTime = System.currentTimeMillis();
            ResultMessage.Prepared response = queryHandler.prepare(this.query, clientState, this.getCustomPayload());
            QueryEvents.instance.notifyPrepareSuccess(() -> queryHandler.getPrepared(response.statementId), this.query, state, queryTime, response);
            return response;
        }
        catch (Exception e) {
            QueryEvents.instance.notifyPrepareFailure(null, this.query, state, e);
            JVMStabilityInspector.inspectThrowable(e);
            return ErrorMessage.fromException(e);
        }
    }

    public String toString() {
        return "PREPARE " + this.query;
    }
}

