/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.io.IVersionedAsymmetricSerializer;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.ForwardingInfo;
import org.apache.cassandra.net.LegacyFlag;
import org.apache.cassandra.net.MessageFlag;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.NoPayload;
import org.apache.cassandra.net.ParamType;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MonotonicClock;
import org.apache.cassandra.utils.MonotonicClockTranslation;
import org.apache.cassandra.utils.vint.VIntCoding;

public class Message<T> {
    public final Header header;
    public final T payload;
    private static final EnumMap<ParamType, Object> NO_PARAMS = new EnumMap(ParamType.class);
    private static final long NO_ID = 0L;
    private static final AtomicInteger nextId = new AtomicInteger(0);
    static final int PROTOCOL_MAGIC = -900387334;
    public static final Serializer serializer = new Serializer();
    private int serializedSize30;
    private int serializedSize3014;
    private int serializedSize40;
    private int payloadSize30 = -1;
    private int payloadSize3014 = -1;
    private int payloadSize40 = -1;

    private Message(Header header, T payload) {
        this.header = header;
        this.payload = payload;
    }

    public InetAddressAndPort from() {
        return this.header.from;
    }

    public boolean isCrossNode() {
        return !this.from().equals(FBUtilities.getBroadcastAddressAndPort());
    }

    public long id() {
        return this.header.id;
    }

    public Verb verb() {
        return this.header.verb;
    }

    boolean isFailureResponse() {
        return this.verb() == Verb.FAILURE_RSP;
    }

    public long createdAtNanos() {
        return this.header.createdAtNanos;
    }

    public long expiresAtNanos() {
        return this.header.expiresAtNanos;
    }

    public long elapsedSinceCreated(TimeUnit units) {
        return units.convert(MonotonicClock.approxTime.now() - this.createdAtNanos(), TimeUnit.NANOSECONDS);
    }

    public long creationTimeMillis() {
        return MonotonicClock.approxTime.translate().toMillisSinceEpoch(this.createdAtNanos());
    }

    boolean callBackOnFailure() {
        return this.header.callBackOnFailure();
    }

    public boolean trackRepairedData() {
        return this.header.trackRepairedData();
    }

    @Nullable
    public ForwardingInfo forwardTo() {
        return this.header.forwardTo();
    }

    @Nullable
    public InetAddressAndPort respondTo() {
        return this.header.respondTo();
    }

    @Nullable
    public UUID traceSession() {
        return this.header.traceSession();
    }

    @Nullable
    public Tracing.TraceType traceType() {
        return this.header.traceType();
    }

    public static <T> Message<T> out(Verb verb, T payload) {
        assert (!verb.isResponse());
        return Message.outWithParam(Message.nextId(), verb, payload, null, null);
    }

    public static <T> Message<T> out(Verb verb, T payload, long expiresAtNanos) {
        return Message.outWithParam(Message.nextId(), verb, expiresAtNanos, payload, 0, null, null);
    }

    public static <T> Message<T> outWithFlag(Verb verb, T payload, MessageFlag flag) {
        assert (!verb.isResponse());
        return Message.outWithParam(Message.nextId(), verb, 0L, payload, flag.addTo(0), null, null);
    }

    public static <T> Message<T> outWithFlags(Verb verb, T payload, MessageFlag flag1, MessageFlag flag2) {
        assert (!verb.isResponse());
        return Message.outWithParam(Message.nextId(), verb, 0L, payload, flag2.addTo(flag1.addTo(0)), null, null);
    }

    static <T> Message<T> outWithParam(long id, Verb verb, T payload, ParamType paramType, Object paramValue) {
        return Message.outWithParam(id, verb, 0L, payload, paramType, paramValue);
    }

    private static <T> Message<T> outWithParam(long id, Verb verb, long expiresAtNanos, T payload, ParamType paramType, Object paramValue) {
        return Message.outWithParam(id, verb, expiresAtNanos, payload, 0, paramType, paramValue);
    }

    private static <T> Message<T> outWithParam(long id, Verb verb, long expiresAtNanos, T payload, int flags, ParamType paramType, Object paramValue) {
        if (payload == null) {
            throw new IllegalArgumentException();
        }
        InetAddressAndPort from = FBUtilities.getBroadcastAddressAndPort();
        long createdAtNanos = MonotonicClock.approxTime.now();
        if (expiresAtNanos == 0L) {
            expiresAtNanos = verb.expiresAtNanos(createdAtNanos);
        }
        return new Message<T>(new Header(id, verb, from, createdAtNanos, expiresAtNanos, flags, Message.buildParams(paramType, paramValue)), payload);
    }

    public static <T> Message<T> internalResponse(Verb verb, T payload) {
        assert (verb.isResponse());
        return Message.outWithParam(0L, verb, payload, null, null);
    }

    public <T> Message<T> responseWith(T payload) {
        return Message.outWithParam(this.id(), this.verb().responseVerb, this.expiresAtNanos(), payload, null, null);
    }

    public Message<NoPayload> emptyResponse() {
        return this.responseWith(NoPayload.noPayload);
    }

    public Message<RequestFailureReason> failureResponse(RequestFailureReason reason) {
        return Message.failureResponse(this.id(), this.expiresAtNanos(), reason);
    }

    static Message<RequestFailureReason> failureResponse(long id, long expiresAtNanos, RequestFailureReason reason) {
        return Message.outWithParam(id, Verb.FAILURE_RSP, expiresAtNanos, reason, null, null);
    }

    Message<T> withCallBackOnFailure() {
        return new Message<T>(this.header.withFlag(MessageFlag.CALL_BACK_ON_FAILURE), this.payload);
    }

    public Message<T> withForwardTo(ForwardingInfo peers) {
        return new Message<T>(this.header.withParam(ParamType.FORWARD_TO, peers), this.payload);
    }

    private static Map<ParamType, Object> buildParams(ParamType type, Object value) {
        Map<ParamType, Object> params = NO_PARAMS;
        if (Tracing.isTracing()) {
            params = Tracing.instance.addTraceHeaders(new EnumMap<ParamType, Object>(ParamType.class));
        }
        if (type != null) {
            if (params.isEmpty()) {
                params = new EnumMap(ParamType.class);
            }
            params.put(type, value);
        }
        return params;
    }

    private static Map<ParamType, Object> addParam(Map<ParamType, Object> params, ParamType type, Object value) {
        if (type == null) {
            return params;
        }
        params = new EnumMap<ParamType, Object>(params);
        params.put(type, value);
        return params;
    }

    private static long nextId() {
        long id;
        while ((id = (long)nextId.incrementAndGet()) == 0L) {
        }
        return id;
    }

    @VisibleForTesting
    boolean hasId() {
        return this.id() != 0L;
    }

    static void validateLegacyProtocolMagic(int magic) throws InvalidLegacyProtocolMagic {
        if (magic != -900387334) {
            throw new InvalidLegacyProtocolMagic(magic);
        }
    }

    public String toString() {
        return "(from:" + this.from() + ", type:" + (Object)((Object)this.verb().stage) + " verb:" + (Object)((Object)this.verb()) + ')';
    }

    public static <T> Builder<T> builder(Message<T> message) {
        return new Builder().from(message.from()).withId(message.id()).ofVerb(message.verb()).withCreatedAt(message.createdAtNanos()).withExpiresAt(message.expiresAtNanos()).withFlags(message.header.flags).withParams(message.header.params).withPayload(message.payload);
    }

    public static <T> Builder<T> builder(Verb verb, T payload) {
        return new Builder().ofVerb(verb).withCreatedAt(MonotonicClock.approxTime.now()).withPayload(payload);
    }

    private IVersionedAsymmetricSerializer<T, ?> getPayloadSerializer() {
        return Message.getPayloadSerializer(this.verb(), this.id(), this.from());
    }

    private static <In, Out> IVersionedAsymmetricSerializer<In, Out> getPayloadSerializer(Verb verb, long id, InetAddressAndPort from) {
        return null != verb.serializer() ? verb.serializer() : MessagingService.instance().callbacks.responseSerializer(id, from);
    }

    public int serializedSize(int version) {
        switch (version) {
            case 10: {
                if (this.serializedSize30 == 0) {
                    this.serializedSize30 = Message.serializer.serializedSize(this, 10);
                }
                return this.serializedSize30;
            }
            case 11: {
                if (this.serializedSize3014 == 0) {
                    this.serializedSize3014 = Message.serializer.serializedSize(this, 11);
                }
                return this.serializedSize3014;
            }
            case 12: {
                if (this.serializedSize40 == 0) {
                    this.serializedSize40 = Message.serializer.serializedSize(this, 12);
                }
                return this.serializedSize40;
            }
        }
        throw new IllegalStateException();
    }

    private int payloadSize(int version) {
        switch (version) {
            case 10: {
                if (this.payloadSize30 < 0) {
                    this.payloadSize30 = Message.serializer.payloadSize(this, 10);
                }
                return this.payloadSize30;
            }
            case 11: {
                if (this.payloadSize3014 < 0) {
                    this.payloadSize3014 = Message.serializer.payloadSize(this, 11);
                }
                return this.payloadSize3014;
            }
            case 12: {
                if (this.payloadSize40 < 0) {
                    this.payloadSize40 = Message.serializer.payloadSize(this, 12);
                }
                return this.payloadSize40;
            }
        }
        throw new IllegalStateException();
    }

    static class OversizedMessageException
    extends RuntimeException {
        OversizedMessageException(int size) {
            super("Message of size " + size + " bytes exceeds allowed maximum of " + DatabaseDescriptor.getInternodeMaxMessageSizeInBytes() + " bytes");
        }
    }

    public static final class Serializer {
        private static final int CREATION_TIME_SIZE = 4;
        private static final int PRE_40_MESSAGE_PREFIX_SIZE = 12;
        private static final long TIMESTAMP_WRAPAROUND_GRACE_PERIOD_START = 0xFFFFFFFFL - TimeUnit.MINUTES.toMillis(15L);
        private static final long TIMESTAMP_WRAPAROUND_GRACE_PERIOD_END = TimeUnit.MINUTES.toMillis(15L);

        private Serializer() {
        }

        public <T> void serialize(Message<T> message, DataOutputPlus out, int version) throws IOException {
            if (version >= 12) {
                this.serializePost40(message, out, version);
            } else {
                this.serializePre40(message, out, version);
            }
        }

        public <T> Message<T> deserialize(DataInputPlus in, InetAddressAndPort peer, int version) throws IOException {
            return version >= 12 ? this.deserializePost40(in, peer, version) : this.deserializePre40(in, version);
        }

        public <T> Message<T> deserialize(DataInputPlus in, Header header, int version) throws IOException {
            return version >= 12 ? this.deserializePost40(in, header, version) : this.deserializePre40(in, header, version);
        }

        private <T> int serializedSize(Message<T> message, int version) {
            return version >= 12 ? this.serializedSizePost40(message, version) : this.serializedSizePre40(message, version);
        }

        int inferMessageSize(ByteBuffer buf, int index, int limit, int version) throws InvalidLegacyProtocolMagic {
            int size;
            int n = size = version >= 12 ? this.inferMessageSizePost40(buf, index, limit) : this.inferMessageSizePre40(buf, index, limit);
            if (size > DatabaseDescriptor.getInternodeMaxMessageSizeInBytes()) {
                throw new OversizedMessageException(size);
            }
            return size;
        }

        Header extractHeader(ByteBuffer buf, InetAddressAndPort from, long currentTimeNanos, int version) throws IOException {
            return version >= 12 ? this.extractHeaderPost40(buf, from, currentTimeNanos, version) : this.extractHeaderPre40(buf, currentTimeNanos, version);
        }

        private static long getExpiresAtNanos(long createdAtNanos, long currentTimeNanos, long expirationPeriodNanos) {
            if (!DatabaseDescriptor.hasCrossNodeTimeout() || createdAtNanos > currentTimeNanos) {
                createdAtNanos = currentTimeNanos;
            }
            return createdAtNanos + expirationPeriodNanos;
        }

        private void serializeHeaderPost40(Header header, DataOutputPlus out, int version) throws IOException {
            out.writeUnsignedVInt(header.id);
            out.writeInt((int)MonotonicClock.approxTime.translate().toMillisSinceEpoch(header.createdAtNanos));
            out.writeUnsignedVInt(TimeUnit.NANOSECONDS.toMillis(header.expiresAtNanos - header.createdAtNanos));
            out.writeUnsignedVInt(header.verb.id);
            out.writeUnsignedVInt(header.flags);
            this.serializeParams(header.params, out, version);
        }

        private Header deserializeHeaderPost40(DataInputPlus in, InetAddressAndPort peer, int version) throws IOException {
            long id = in.readUnsignedVInt();
            long currentTimeNanos = MonotonicClock.approxTime.now();
            MonotonicClockTranslation timeSnapshot = MonotonicClock.approxTime.translate();
            long creationTimeNanos = Serializer.calculateCreationTimeNanos(in.readInt(), timeSnapshot, currentTimeNanos);
            long expiresAtNanos = Serializer.getExpiresAtNanos(creationTimeNanos, currentTimeNanos, TimeUnit.MILLISECONDS.toNanos(in.readUnsignedVInt()));
            Verb verb = Verb.fromId(Ints.checkedCast((long)in.readUnsignedVInt()));
            int flags = Ints.checkedCast((long)in.readUnsignedVInt());
            Map<ParamType, Object> params = this.deserializeParams(in, version);
            return new Header(id, verb, peer, creationTimeNanos, expiresAtNanos, flags, params);
        }

        private void skipHeaderPost40(DataInputPlus in) throws IOException {
            VIntCoding.skipUnsignedVInt(in);
            in.skipBytesFully(4);
            VIntCoding.skipUnsignedVInt(in);
            VIntCoding.skipUnsignedVInt(in);
            VIntCoding.skipUnsignedVInt(in);
            this.skipParamsPost40(in);
        }

        private int serializedHeaderSizePost40(Header header, int version) {
            long size = 0L;
            size += (long)TypeSizes.sizeofUnsignedVInt(header.id);
            size += 4L;
            size += (long)TypeSizes.sizeofUnsignedVInt(TimeUnit.NANOSECONDS.toMillis(header.expiresAtNanos - header.createdAtNanos));
            size += (long)TypeSizes.sizeofUnsignedVInt(header.verb.id);
            size += (long)TypeSizes.sizeofUnsignedVInt(header.flags);
            return Ints.checkedCast((long)(size += this.serializedParamsSize(header.params, version)));
        }

        private Header extractHeaderPost40(ByteBuffer buf, InetAddressAndPort from, long currentTimeNanos, int version) throws IOException {
            MonotonicClockTranslation timeSnapshot = MonotonicClock.approxTime.translate();
            int index = buf.position();
            long id = VIntCoding.getUnsignedVInt(buf, index);
            int createdAtMillis = buf.getInt(index += VIntCoding.computeUnsignedVIntSize(id));
            long expiresInMillis = VIntCoding.getUnsignedVInt(buf, index += TypeSizes.sizeof(createdAtMillis));
            Verb verb = Verb.fromId(Ints.checkedCast((long)VIntCoding.getUnsignedVInt(buf, index += VIntCoding.computeUnsignedVIntSize(expiresInMillis))));
            int flags = Ints.checkedCast((long)VIntCoding.getUnsignedVInt(buf, index += VIntCoding.computeUnsignedVIntSize(verb.id)));
            Map<ParamType, Object> params = this.extractParams(buf, index += VIntCoding.computeUnsignedVIntSize(flags), version);
            long createdAtNanos = Serializer.calculateCreationTimeNanos(createdAtMillis, timeSnapshot, currentTimeNanos);
            long expiresAtNanos = Serializer.getExpiresAtNanos(createdAtNanos, currentTimeNanos, TimeUnit.MILLISECONDS.toNanos(expiresInMillis));
            return new Header(id, verb, from, createdAtNanos, expiresAtNanos, flags, params);
        }

        private <T> void serializePost40(Message<T> message, DataOutputPlus out, int version) throws IOException {
            this.serializeHeaderPost40(message.header, out, version);
            out.writeUnsignedVInt(((Message)message).payloadSize(version));
            ((Message)message).getPayloadSerializer().serialize(message.payload, out, version);
        }

        private <T> Message<T> deserializePost40(DataInputPlus in, InetAddressAndPort peer, int version) throws IOException {
            Header header = this.deserializeHeaderPost40(in, peer, version);
            VIntCoding.skipUnsignedVInt(in);
            Object payload = header.verb.serializer().deserialize(in, version);
            return new Message(header, payload);
        }

        private <T> Message<T> deserializePost40(DataInputPlus in, Header header, int version) throws IOException {
            this.skipHeaderPost40(in);
            VIntCoding.skipUnsignedVInt(in);
            Object payload = header.verb.serializer().deserialize(in, version);
            return new Message(header, payload);
        }

        private <T> int serializedSizePost40(Message<T> message, int version) {
            long size = 0L;
            size += (long)this.serializedHeaderSizePost40(message.header, version);
            int payloadSize = ((Message)message).payloadSize(version);
            return Ints.checkedCast((long)(size += (long)(TypeSizes.sizeofUnsignedVInt(payloadSize) + payloadSize)));
        }

        private int inferMessageSizePost40(ByteBuffer buf, int readerIndex, int readerLimit) {
            int index = readerIndex;
            int idSize = VIntCoding.computeUnsignedVIntSize(buf, index, readerLimit);
            if (idSize < 0) {
                return -1;
            }
            index += idSize;
            if ((index += 4) > readerLimit) {
                return -1;
            }
            int expirationSize = VIntCoding.computeUnsignedVIntSize(buf, index, readerLimit);
            if (expirationSize < 0) {
                return -1;
            }
            int verbIdSize = VIntCoding.computeUnsignedVIntSize(buf, index += expirationSize, readerLimit);
            if (verbIdSize < 0) {
                return -1;
            }
            int flagsSize = VIntCoding.computeUnsignedVIntSize(buf, index += verbIdSize, readerLimit);
            if (flagsSize < 0) {
                return -1;
            }
            int paramsSize = this.extractParamsSizePost40(buf, index += flagsSize, readerLimit);
            if (paramsSize < 0) {
                return -1;
            }
            long payloadSize = VIntCoding.getUnsignedVInt(buf, index += paramsSize, readerLimit);
            if (payloadSize < 0L) {
                return -1;
            }
            index = (int)((long)index + ((long)VIntCoding.computeUnsignedVIntSize(payloadSize) + payloadSize));
            return index - readerIndex;
        }

        private void serializeHeaderPre40(Header header, DataOutputPlus out, int version) throws IOException {
            out.writeInt(-900387334);
            out.writeInt(Ints.checkedCast((long)header.id));
            out.writeInt((int)MonotonicClock.approxTime.translate().toMillisSinceEpoch(header.createdAtNanos));
            InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(header.from, out, version);
            out.writeInt(header.verb.toPre40Verb().id);
            this.serializeParams(this.addFlagsToLegacyParams(header.params, header.flags), out, version);
        }

        private Header deserializeHeaderPre40(DataInputPlus in, int version) throws IOException {
            Message.validateLegacyProtocolMagic(in.readInt());
            int id = in.readInt();
            long currentTimeNanos = MonotonicClock.approxTime.now();
            MonotonicClockTranslation timeSnapshot = MonotonicClock.approxTime.translate();
            long creationTimeNanos = Serializer.calculateCreationTimeNanos(in.readInt(), timeSnapshot, currentTimeNanos);
            InetAddressAndPort from = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version);
            Verb verb = Verb.fromId(in.readInt());
            Map<ParamType, Object> params = this.deserializeParams(in, version);
            int flags = this.removeFlagsFromLegacyParams(params);
            return new Header(id, verb, from, creationTimeNanos, verb.expiresAtNanos(creationTimeNanos), flags, params);
        }

        private void skipHeaderPre40(DataInputPlus in) throws IOException {
            in.skipBytesFully(12);
            in.skipBytesFully(in.readByte());
            in.skipBytesFully(4);
            this.skipParamsPre40(in);
        }

        private int serializedHeaderSizePre40(Header header, int version) {
            long size = 0L;
            size += 12L;
            size += InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(header.from, version);
            size += (long)TypeSizes.sizeof(header.verb.id);
            return Ints.checkedCast((long)(size += this.serializedParamsSize(this.addFlagsToLegacyParams(header.params, header.flags), version)));
        }

        private Header extractHeaderPre40(ByteBuffer buf, long currentTimeNanos, int version) throws IOException {
            MonotonicClockTranslation timeSnapshot = MonotonicClock.approxTime.translate();
            int index = buf.position();
            long id = buf.getInt(index += 4);
            int createdAtMillis = buf.getInt(index += 4);
            InetAddressAndPort from = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.extract(buf, index += 4);
            index += 1 + buf.get(index);
            Verb verb = Verb.fromId(buf.getInt(index));
            Map<ParamType, Object> params = this.extractParams(buf, index += 4, version);
            int flags = this.removeFlagsFromLegacyParams(params);
            long createdAtNanos = Serializer.calculateCreationTimeNanos(createdAtMillis, timeSnapshot, currentTimeNanos);
            long expiresAtNanos = verb.expiresAtNanos(createdAtNanos);
            return new Header(id, verb, from, createdAtNanos, expiresAtNanos, flags, params);
        }

        private <T> void serializePre40(Message<T> message, DataOutputPlus out, int version) throws IOException {
            if (message.isFailureResponse()) {
                message = this.toPre40FailureResponse(message);
            }
            this.serializeHeaderPre40(message.header, out, version);
            if (message.payload != null && message.payload != NoPayload.noPayload) {
                int payloadSize = message.payloadSize(version);
                out.writeInt(payloadSize);
                message.getPayloadSerializer().serialize(message.payload, out, version);
            } else {
                out.writeInt(0);
            }
        }

        private <T> Message<T> deserializePre40(DataInputPlus in, int version) throws IOException {
            Header header = this.deserializeHeaderPre40(in, version);
            return this.deserializePre40(in, header, false, version);
        }

        private <T> Message<T> deserializePre40(DataInputPlus in, Header header, int version) throws IOException {
            return this.deserializePre40(in, header, true, version);
        }

        private <T> Message<T> deserializePre40(DataInputPlus in, Header header, boolean skipHeader, int version) throws IOException {
            if (skipHeader) {
                this.skipHeaderPre40(in);
            }
            int payloadSize = in.readInt();
            T payload = this.deserializePayloadPre40(in, version, Message.getPayloadSerializer(header.verb, header.id, header.from), payloadSize);
            Message message = new Message(header, payload);
            return header.params.containsKey((Object)ParamType.FAILURE_RESPONSE) ? this.toPost40FailureResponse(message) : message;
        }

        private <T> T deserializePayloadPre40(DataInputPlus in, int version, IVersionedAsymmetricSerializer<?, T> serializer, int payloadSize) throws IOException {
            if (payloadSize == 0 || serializer == null) {
                in.skipBytesFully(payloadSize);
                return null;
            }
            return serializer.deserialize(in, version);
        }

        private <T> int serializedSizePre40(Message<T> message, int version) {
            if (message.isFailureResponse()) {
                message = this.toPre40FailureResponse(message);
            }
            long size = 0L;
            size += (long)this.serializedHeaderSizePre40(message.header, version);
            int payloadSize = message.payloadSize(version);
            size += (long)TypeSizes.sizeof(payloadSize);
            return Ints.checkedCast((long)(size += (long)payloadSize));
        }

        private int inferMessageSizePre40(ByteBuffer buf, int readerIndex, int readerLimit) throws InvalidLegacyProtocolMagic {
            int index = readerIndex;
            if ((index += 4) > readerLimit) {
                return -1;
            }
            Message.validateLegacyProtocolMagic(buf.getInt(index - 4));
            index += 8;
            if (++index > readerLimit) {
                return -1;
            }
            index += buf.get(index - 1);
            if ((index += 4) > readerLimit) {
                return -1;
            }
            int paramsSize = this.extractParamsSizePre40(buf, index, readerLimit);
            if (paramsSize < 0) {
                return -1;
            }
            index += paramsSize;
            if ((index += 4) > readerLimit) {
                return -1;
            }
            index += buf.getInt(index - 4);
            return index - readerIndex;
        }

        private Message toPre40FailureResponse(Message post40) {
            EnumMap<ParamType, LegacyFlag> params = new EnumMap<ParamType, LegacyFlag>(ParamType.class);
            params.putAll(post40.header.params);
            params.put(ParamType.FAILURE_RESPONSE, LegacyFlag.instance);
            params.put(ParamType.FAILURE_REASON, (LegacyFlag)post40.payload);
            Header header = new Header(post40.id(), post40.verb().toPre40Verb(), post40.from(), post40.createdAtNanos(), post40.expiresAtNanos(), 0, params);
            return new Message(header, NoPayload.noPayload);
        }

        private Message<RequestFailureReason> toPost40FailureResponse(Message<?> pre40) {
            EnumMap params = new EnumMap(ParamType.class);
            params.putAll(pre40.header.params);
            params.remove((Object)ParamType.FAILURE_RESPONSE);
            RequestFailureReason reason = (RequestFailureReason)((Object)params.remove((Object)ParamType.FAILURE_REASON));
            if (null == reason) {
                reason = RequestFailureReason.UNKNOWN;
            }
            Header header = new Header(pre40.id(), Verb.FAILURE_RSP, pre40.from(), pre40.createdAtNanos(), pre40.expiresAtNanos(), pre40.header.flags, params);
            return new Message<RequestFailureReason>(header, (Object)reason);
        }

        private static long calculateCreationTimeNanos(int messageTimestampMillis, MonotonicClockTranslation timeSnapshot, long currentTimeNanos) {
            long currentTimeMillis = timeSnapshot.toMillisSinceEpoch(currentTimeNanos);
            long highBits = currentTimeMillis & 0xFFFFFFFF00000000L;
            long sentLowBits = (long)messageTimestampMillis & 0xFFFFFFFFL;
            long currentLowBits = currentTimeMillis & 0xFFFFFFFFL;
            if (sentLowBits > TIMESTAMP_WRAPAROUND_GRACE_PERIOD_START && currentLowBits < TIMESTAMP_WRAPAROUND_GRACE_PERIOD_END) {
                highBits -= 0x100000000L;
            }
            long sentTimeMillis = highBits | sentLowBits;
            return timeSnapshot.fromMillisSinceEpoch(sentTimeMillis);
        }

        private Map<ParamType, Object> addFlagsToLegacyParams(Map<ParamType, Object> params, int flags) {
            if (flags == 0) {
                return params;
            }
            EnumMap<ParamType, Object> extended = new EnumMap<ParamType, Object>(ParamType.class);
            extended.putAll(params);
            if (MessageFlag.CALL_BACK_ON_FAILURE.isIn(flags)) {
                extended.put(ParamType.FAILURE_CALLBACK, LegacyFlag.instance);
            }
            if (MessageFlag.TRACK_REPAIRED_DATA.isIn(flags)) {
                extended.put(ParamType.TRACK_REPAIRED_DATA, (Object)LegacyFlag.instance);
            }
            return extended;
        }

        private int removeFlagsFromLegacyParams(Map<ParamType, Object> params) {
            int flags = 0;
            if (null != params.remove((Object)ParamType.FAILURE_CALLBACK)) {
                flags = MessageFlag.CALL_BACK_ON_FAILURE.addTo(flags);
            }
            if (null != params.remove((Object)ParamType.TRACK_REPAIRED_DATA)) {
                flags = MessageFlag.TRACK_REPAIRED_DATA.addTo(flags);
            }
            return flags;
        }

        private void serializeParams(Map<ParamType, Object> params, DataOutputPlus out, int version) throws IOException {
            if (version >= 12) {
                out.writeUnsignedVInt(params.size());
            } else {
                out.writeInt(params.size());
            }
            for (Map.Entry<ParamType, Object> kv : params.entrySet()) {
                ParamType type = kv.getKey();
                if (version >= 12) {
                    out.writeUnsignedVInt(type.id);
                } else {
                    out.writeUTF(type.legacyAlias);
                }
                IVersionedSerializer serializer = type.serializer;
                Object value = kv.getValue();
                int length = Ints.checkedCast((long)serializer.serializedSize(value, version));
                if (version >= 12) {
                    out.writeUnsignedVInt(length);
                } else {
                    out.writeInt(length);
                }
                serializer.serialize(value, out, version);
            }
        }

        private Map<ParamType, Object> deserializeParams(DataInputPlus in, int version) throws IOException {
            int count;
            int n = count = version >= 12 ? Ints.checkedCast((long)in.readUnsignedVInt()) : in.readInt();
            if (count == 0) {
                return NO_PARAMS;
            }
            EnumMap<ParamType, Object> params = new EnumMap<ParamType, Object>(ParamType.class);
            for (int i = 0; i < count; ++i) {
                int length;
                ParamType type = version >= 12 ? ParamType.lookUpById(Ints.checkedCast((long)in.readUnsignedVInt())) : ParamType.lookUpByAlias(in.readUTF());
                int n2 = length = version >= 12 ? Ints.checkedCast((long)in.readUnsignedVInt()) : in.readInt();
                if (null != type) {
                    if (version < 12 && type == ParamType.RESPOND_TO) {
                        params.put(type, (Object)InetAddressAndPort.FwdFrmSerializer.fwdFrmSerializer.pre40DeserializeWithLength(in, version, length));
                        continue;
                    }
                    params.put(type, type.serializer.deserialize(in, version));
                    continue;
                }
                in.skipBytesFully(length);
            }
            return params;
        }

        /*
         * Loose catch block
         */
        private Map<ParamType, Object> extractParams(ByteBuffer buf, int readerIndex, int version) throws IOException {
            long count;
            long l = count = version >= 12 ? VIntCoding.getUnsignedVInt(buf, readerIndex) : (long)buf.getInt(readerIndex);
            if (count == 0L) {
                return NO_PARAMS;
            }
            int position = buf.position();
            buf.position(readerIndex);
            try {
                try (DataInputBuffer in = new DataInputBuffer(buf, false);){
                    Map<ParamType, Object> map = this.deserializeParams(in, version);
                    return map;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                buf.position(position);
            }
        }

        private void skipParamsPost40(DataInputPlus in) throws IOException {
            int count = Ints.checkedCast((long)in.readUnsignedVInt());
            for (int i = 0; i < count; ++i) {
                VIntCoding.skipUnsignedVInt(in);
                in.skipBytesFully(Ints.checkedCast((long)in.readUnsignedVInt()));
            }
        }

        private void skipParamsPre40(DataInputPlus in) throws IOException {
            int count = in.readInt();
            for (int i = 0; i < count; ++i) {
                in.skipBytesFully(in.readShort());
                in.skipBytesFully(in.readInt());
            }
        }

        private long serializedParamsSize(Map<ParamType, Object> params, int version) {
            long size = version >= 12 ? (long)VIntCoding.computeUnsignedVIntSize(params.size()) : (long)TypeSizes.sizeof(params.size());
            for (Map.Entry<ParamType, Object> kv : params.entrySet()) {
                ParamType type = kv.getKey();
                Object value = kv.getValue();
                long valueLength = type.serializer.serializedSize(value, version);
                size = version >= 12 ? (size += (long)(TypeSizes.sizeofUnsignedVInt(type.id) + TypeSizes.sizeofUnsignedVInt(valueLength))) : (size += (long)(TypeSizes.sizeof(type.legacyAlias) + 4));
                size += valueLength;
            }
            return size;
        }

        private int extractParamsSizePost40(ByteBuffer buf, int readerIndex, int readerLimit) {
            int index = readerIndex;
            long paramsCount = VIntCoding.getUnsignedVInt(buf, index, readerLimit);
            if (paramsCount < 0L) {
                return -1;
            }
            index += VIntCoding.computeUnsignedVIntSize(paramsCount);
            int i = 0;
            while ((long)i < paramsCount) {
                long type = VIntCoding.getUnsignedVInt(buf, index, readerLimit);
                if (type < 0L) {
                    return -1;
                }
                long length = VIntCoding.getUnsignedVInt(buf, index += VIntCoding.computeUnsignedVIntSize(type), readerLimit);
                if (length < 0L) {
                    return -1;
                }
                index = (int)((long)index + ((long)VIntCoding.computeUnsignedVIntSize(length) + length));
                ++i;
            }
            return index - readerIndex;
        }

        private int extractParamsSizePre40(ByteBuffer buf, int readerIndex, int readerLimit) {
            int index = readerIndex;
            if ((index += 4) > readerLimit) {
                return -1;
            }
            int paramsCount = buf.getInt(index - 4);
            for (int i = 0; i < paramsCount; ++i) {
                if ((index += 2) > readerLimit) {
                    return -1;
                }
                index += buf.getShort(index - 2);
                if ((index += 4) > readerLimit) {
                    return -1;
                }
                index += buf.getInt(index - 4);
            }
            return index - readerIndex;
        }

        private <T> int payloadSize(Message<T> message, int version) {
            long payloadSize = message.payload != null && message.payload != NoPayload.noPayload ? ((Message)message).getPayloadSerializer().serializedSize(message.payload, version) : 0L;
            return Ints.checkedCast((long)payloadSize);
        }
    }

    public static class Builder<T> {
        private Verb verb;
        private InetAddressAndPort from;
        private T payload;
        private int flags = 0;
        private final Map<ParamType, Object> params = new EnumMap<ParamType, Object>(ParamType.class);
        private long createdAtNanos;
        private long expiresAtNanos;
        private long id;
        private boolean hasId;

        private Builder() {
        }

        public Builder<T> from(InetAddressAndPort from) {
            this.from = from;
            return this;
        }

        public Builder<T> withPayload(T payload) {
            this.payload = payload;
            return this;
        }

        public Builder<T> withFlag(MessageFlag flag) {
            this.flags = flag.addTo(this.flags);
            return this;
        }

        public Builder<T> withFlags(int flags) {
            this.flags = flags;
            return this;
        }

        public Builder<T> withParam(ParamType type, Object value) {
            this.params.put(type, value);
            return this;
        }

        public Builder<T> withTracingParams() {
            if (Tracing.isTracing()) {
                Tracing.instance.addTraceHeaders(this.params);
            }
            return this;
        }

        public Builder<T> withoutParam(ParamType type) {
            this.params.remove((Object)type);
            return this;
        }

        public Builder<T> withParams(Map<ParamType, Object> params) {
            this.params.putAll(params);
            return this;
        }

        public Builder<T> ofVerb(Verb verb) {
            this.verb = verb;
            if (this.expiresAtNanos == 0L && verb != null && this.createdAtNanos != 0L) {
                this.expiresAtNanos = verb.expiresAtNanos(this.createdAtNanos);
            }
            if (!this.verb.isResponse() && this.from == null) {
                this.from = FBUtilities.getBroadcastAddressAndPort();
            }
            return this;
        }

        public Builder<T> withCreatedAt(long createdAtNanos) {
            this.createdAtNanos = createdAtNanos;
            if (this.expiresAtNanos == 0L && this.verb != null) {
                this.expiresAtNanos = this.verb.expiresAtNanos(createdAtNanos);
            }
            return this;
        }

        public Builder<T> withExpiresAt(long expiresAtNanos) {
            this.expiresAtNanos = expiresAtNanos;
            return this;
        }

        public Builder<T> withId(long id) {
            this.id = id;
            this.hasId = true;
            return this;
        }

        public Message<T> build() {
            if (this.verb == null) {
                throw new IllegalArgumentException();
            }
            if (this.from == null) {
                throw new IllegalArgumentException();
            }
            if (this.payload == null) {
                throw new IllegalArgumentException();
            }
            return new Message(new Header(this.hasId ? this.id : Message.nextId(), this.verb, this.from, this.createdAtNanos, this.expiresAtNanos, this.flags, this.params), this.payload);
        }
    }

    public static class Header {
        public final long id;
        public final Verb verb;
        public final InetAddressAndPort from;
        public final long createdAtNanos;
        public final long expiresAtNanos;
        private final int flags;
        private final Map<ParamType, Object> params;

        private Header(long id, Verb verb, InetAddressAndPort from, long createdAtNanos, long expiresAtNanos, int flags, Map<ParamType, Object> params) {
            this.id = id;
            this.verb = verb;
            this.from = from;
            this.expiresAtNanos = expiresAtNanos;
            this.createdAtNanos = createdAtNanos;
            this.flags = flags;
            this.params = params;
        }

        Header withFlag(MessageFlag flag) {
            return new Header(this.id, this.verb, this.from, this.createdAtNanos, this.expiresAtNanos, flag.addTo(this.flags), this.params);
        }

        Header withParam(ParamType type, Object value) {
            return new Header(this.id, this.verb, this.from, this.createdAtNanos, this.expiresAtNanos, this.flags, Message.addParam(this.params, type, value));
        }

        boolean callBackOnFailure() {
            return MessageFlag.CALL_BACK_ON_FAILURE.isIn(this.flags);
        }

        boolean trackRepairedData() {
            return MessageFlag.TRACK_REPAIRED_DATA.isIn(this.flags);
        }

        @Nullable
        ForwardingInfo forwardTo() {
            return (ForwardingInfo)this.params.get((Object)ParamType.FORWARD_TO);
        }

        @Nullable
        InetAddressAndPort respondTo() {
            return (InetAddressAndPort)this.params.get((Object)ParamType.RESPOND_TO);
        }

        @Nullable
        public UUID traceSession() {
            return (UUID)this.params.get((Object)ParamType.TRACE_SESSION);
        }

        @Nullable
        public Tracing.TraceType traceType() {
            return (Tracing.TraceType)((Object)this.params.getOrDefault((Object)ParamType.TRACE_TYPE, (Object)Tracing.TraceType.QUERY));
        }
    }

    public static final class InvalidLegacyProtocolMagic
    extends IOException {
        public final int read;

        private InvalidLegacyProtocolMagic(int read) {
            super(String.format("Read %d, Expected %d", read, -900387334));
            this.read = read;
        }
    }
}

